#
# OpenAPI Petstore
# 
# This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
# The version of the OpenAPI document: 1.0.0
# 
# Generated by: https://openapi-generator.tech
#

import json
import tables
import marshal
import options

import model_category
import model_tag

type Status* {.pure.} = enum
  Available
  Pending
  Sold

type Pet* = object
  ## A pet for sale in the pet store
  id*: Option[int64]
  category*: Option[Category]
  name*: string
  photoUrls*: seq[string]
  tags*: Option[seq[Tag]]
  status*: Option[Status] ## pet status in the store

func `%`*(v: Status): JsonNode =
  result = case v:
    of Status.Available: %"available"
    of Status.Pending: %"pending"
    of Status.Sold: %"sold"
func `$`*(v: Status): string =
  result = case v:
    of Status.Available: $("available")
    of Status.Pending: $("pending")
    of Status.Sold: $("sold")

proc to*(node: JsonNode, T: typedesc[Status]): Status =
  if node.kind != JString:
    raise newException(ValueError, "Expected string for enum Status, got " & $node.kind)
  let strVal = node.getStr()
  case strVal:
  of $("available"):
    return Status.Available
  of $("pending"):
    return Status.Pending
  of $("sold"):
    return Status.Sold
  else:
    raise newException(ValueError, "Invalid enum value for Status: " & strVal)

