#
# OpenAPI Petstore
# 
# This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
# The version of the OpenAPI document: 1.0.0
# 
# Generated by: https://openapi-generator.tech
#

import httpclient
import json
import logging
import marshal
import options
import strformat
import strutils
import tables
import typetraits
import uri

import ../models/model_user

const basepath = "http://petstore.swagger.io/v2"

template constructResult[T](response: Response): untyped =
  if response.code in {Http200, Http201, Http202, Http204, Http206}:
    try:
      (some(to(parseJson(response.body), T)), response)
    except JsonParsingError:
      # The server returned a malformed response though the response code is 2XX
      # TODO: need better error handling
      error("JsonParsingError")
      (none(T.typedesc), response)
  else:
    (none(T.typedesc), response)


proc createUser*(httpClient: HttpClient, user: User): Response =
  ## Create user
  httpClient.headers["Content-Type"] = "application/json"
  httpClient.post(basepath & "/user", $(%user))



proc createUsersWithArrayInput*(httpClient: HttpClient, user: seq[User]): Response =
  ## Creates list of users with given input array
  httpClient.headers["Content-Type"] = "application/json"
  httpClient.post(basepath & "/user/createWithArray", $(%user))



proc createUsersWithListInput*(httpClient: HttpClient, user: seq[User]): Response =
  ## Creates list of users with given input array
  httpClient.headers["Content-Type"] = "application/json"
  httpClient.post(basepath & "/user/createWithList", $(%user))



proc deleteUser*(httpClient: HttpClient, username: string): Response =
  ## Delete user
  httpClient.delete(basepath & fmt"/user/{username}")



proc getUserByName*(httpClient: HttpClient, username: string): (Option[User], Response) =
  ## Get user by user name

  let response = httpClient.get(basepath & fmt"/user/{username}")
  constructResult[User](response)


proc loginUser*(httpClient: HttpClient, username: string, password: string): (Option[string], Response) =
  ## Logs user into the system
  var query_params_list: seq[(string, string)] = @[]
  query_params_list.add(("username", $username))
  query_params_list.add(("password", $password))
  let url_encoded_query_params = encodeQuery(query_params_list)

  let response = httpClient.get(basepath & "/user/login" & "?" & url_encoded_query_params)
  constructResult[string](response)


proc logoutUser*(httpClient: HttpClient): Response =
  ## Logs out current logged in user session
  httpClient.get(basepath & "/user/logout")



proc updateUser*(httpClient: HttpClient, username: string, user: User): Response =
  ## Updated user
  httpClient.headers["Content-Type"] = "application/json"
  httpClient.put(basepath & fmt"/user/{username}", $(%user))


