/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package org.openapitools.client.models

import com.google.gson.GsonBuilder
import com.google.gson.JsonSyntaxException
import io.kotlintest.shouldBe
import io.kotlintest.specs.ShouldSpec
import org.junit.jupiter.api.Assertions

import org.openapitools.client.models.ApiAnyOfUserOrPet
import org.openapitools.client.models.ApiCategory
import org.openapitools.client.models.ApiPet
import org.openapitools.client.models.ApiTag
import org.openapitools.client.models.ApiUser
import java.lang.RuntimeException

class ApiAnyOfUserOrPetTest : ShouldSpec() {
    init {
        should("test custom type adapter") {
            val gson = GsonBuilder()
                .registerTypeAdapterFactory(ApiUser.CustomTypeAdapterFactory())
                .registerTypeAdapterFactory(ApiCategory.CustomTypeAdapterFactory())
                .registerTypeAdapterFactory(ApiPet.CustomTypeAdapterFactory())
                .registerTypeAdapterFactory(ApiTag.CustomTypeAdapterFactory())
                .registerTypeAdapterFactory(ApiAnyOfUserOrPet.CustomTypeAdapterFactory())
                .create()

            // test Category
            val categoryJson = "{\"id\":123,\"name\":\"category\"}"
            val category = gson.fromJson(categoryJson, ApiCategory::class.java)
            //val category = gson.fromJson("{\"name\":\"category\"}", ApiCategory::class.java)
            category.id shouldBe 123L
            category.name shouldBe "category"

            // test Pet
            val petJson = "{\"id\":123,\"name\":\"pet\",\"photoUrls\":[\"https://a.com\"],\"category\":{\"id\":456,\"name\":\"pet category\"},\"tags\":[{\"id\":678,\"name\":\"pet tag\"}],\"status\":\"available\"}"
            val pet = gson.fromJson(petJson, ApiPet::class.java)
            pet.id shouldBe 123L
            pet.name shouldBe "pet"
            pet.photoUrls shouldBe arrayOf("https://a.com")
            pet.tags shouldBe arrayOf(ApiTag(678, "pet tag"))
            pet.category shouldBe ApiCategory(456, "pet category")
            pet.status shouldBe ApiPet.Status.AVAILABLE

            // test invalid json (missing required fields)
            val petJsonMissingRequiredFields = "{\"id\":123,\"category\":{\"id\":456,\"name\":\"pet category\"},\"tags\":[{\"id\":678,\"name\":\"pet tag\"}],\"status\":\"available\"}"
            Assertions.assertThrows(IllegalArgumentException::class.java) {
                val failedPet = gson.fromJson(petJsonMissingRequiredFields, ApiPet::class.java)
                failedPet.id shouldBe 123L
            }

            // test AnyOfUserOrPet (anyOf schema)
            // invalid json
            Assertions.assertThrows(JsonSyntaxException::class.java) {
                val failed = gson.fromJson(categoryJson, ApiAnyOfUserOrPet::class.java)
                if (failed != null) {
                    throw RuntimeException("this exception shouldn't be thrown")
                }
            }

            // valid json, actualInstance should be Pet
            val anyOfUserOrPet = gson.fromJson(petJson, ApiAnyOfUserOrPet::class.java)
            (anyOfUserOrPet.actualInstance is ApiPet) shouldBe true
            (anyOfUserOrPet.actualInstance is ApiUser) shouldBe false

            val petFromAnyOf: ApiPet = anyOfUserOrPet.actualInstance as ApiPet

            petFromAnyOf.id shouldBe 123L
            petFromAnyOf.name shouldBe "pet"
            petFromAnyOf.photoUrls shouldBe arrayOf("https://a.com")
            petFromAnyOf.tags shouldBe arrayOf(ApiTag(678, "pet tag"))
            petFromAnyOf.category shouldBe ApiCategory(456, "pet category")
            petFromAnyOf.status shouldBe ApiPet.Status.AVAILABLE
        }

    }
}
