/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package org.openapitools.client.apis

import com.fasterxml.jackson.annotation.JsonProperty

import org.springframework.web.client.RestClient
import org.springframework.web.client.RestClientResponseException

import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter
import org.springframework.http.ResponseEntity
import org.springframework.http.MediaType


import org.openapitools.client.models.ModelApiResponse
import org.openapitools.client.models.Pet
import org.openapitools.client.infrastructure.*

open class PetApi(client: RestClient) : ApiClient(client) {

    constructor(baseUrl: String) : this(RestClient.builder()
        .baseUrl(baseUrl)
        .messageConverters { it.add(MappingJackson2HttpMessageConverter()) }
        .build()
    )


    @Throws(RestClientResponseException::class)
    fun addPet(pet: Pet): Pet {
        val result = addPetWithHttpInfo(pet = pet)
        return result.body!!
    }

    @Throws(RestClientResponseException::class)
    fun addPetWithHttpInfo(pet: Pet): ResponseEntity<Pet> {
        val localVariableConfig = addPetRequestConfig(pet = pet)
        return request<Pet, Pet>(
            localVariableConfig
        )
    }

    fun addPetRequestConfig(pet: Pet) : RequestConfig<Pet> {
        val localVariableBody = pet
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Content-Type"] = "application/xml"
        localVariableHeaders["Accept"] = "application/xml, application/json"

        val params = mutableMapOf<String, Any>(
        )

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/pet",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    @Throws(RestClientResponseException::class)
    fun deletePet(petId: kotlin.Long, apiKey: kotlin.String? = null): Unit {
        deletePetWithHttpInfo(petId = petId, apiKey = apiKey)
    }

    @Throws(RestClientResponseException::class)
    fun deletePetWithHttpInfo(petId: kotlin.Long, apiKey: kotlin.String? = null): ResponseEntity<Unit> {
        val localVariableConfig = deletePetRequestConfig(petId = petId, apiKey = apiKey)
        return request<Unit, Unit>(
            localVariableConfig
        )
    }

    fun deletePetRequestConfig(petId: kotlin.Long, apiKey: kotlin.String? = null) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        apiKey?.apply { localVariableHeaders["api_key"] = this.toString() }
        
        val params = mutableMapOf<String, Any>(
            "petId" to petId,
        )

        return RequestConfig(
            method = RequestMethod.DELETE,
            path = "/pet/{petId}",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * enum for parameter status
     */
    enum class StatusFindPetsByStatus(val value: kotlin.String) {
        @JsonProperty(value = "available") available("available"),
        @JsonProperty(value = "pending") pending("pending"),
        @JsonProperty(value = "sold") sold("sold"),
    }


    @Throws(RestClientResponseException::class)
    fun findPetsByStatus(status: kotlin.collections.List<StatusFindPetsByStatus>): kotlin.collections.List<Pet> {
        val result = findPetsByStatusWithHttpInfo(status = status)
        return result.body!!
    }

    @Throws(RestClientResponseException::class)
    fun findPetsByStatusWithHttpInfo(status: kotlin.collections.List<StatusFindPetsByStatus>): ResponseEntity<kotlin.collections.List<Pet>> {
        val localVariableConfig = findPetsByStatusRequestConfig(status = status)
        return request<Unit, kotlin.collections.List<Pet>>(
            localVariableConfig
        )
    }

    fun findPetsByStatusRequestConfig(status: kotlin.collections.List<StatusFindPetsByStatus>) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("status", toMultiValue(status.toList(), "csv"))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/xml, application/json"

        val params = mutableMapOf<String, Any>(
        )

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/pet/findByStatus",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    @Throws(RestClientResponseException::class)
    @Deprecated(message = "This operation is deprecated.")
    fun findPetsByTags(tags: kotlin.collections.List<kotlin.String>): kotlin.collections.List<Pet> {
        val result = findPetsByTagsWithHttpInfo(tags = tags)
        return result.body!!
    }

    @Throws(RestClientResponseException::class)
    @Deprecated(message = "This operation is deprecated.")
    fun findPetsByTagsWithHttpInfo(tags: kotlin.collections.List<kotlin.String>): ResponseEntity<kotlin.collections.List<Pet>> {
        val localVariableConfig = findPetsByTagsRequestConfig(tags = tags)
        return request<Unit, kotlin.collections.List<Pet>>(
            localVariableConfig
        )
    }

    @Deprecated(message = "This operation is deprecated.")
    fun findPetsByTagsRequestConfig(tags: kotlin.collections.List<kotlin.String>) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("tags", toMultiValue(tags.toList(), "csv"))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/xml, application/json"

        val params = mutableMapOf<String, Any>(
        )

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/pet/findByTags",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    @Throws(RestClientResponseException::class)
    fun getPetById(petId: kotlin.Long): Pet {
        val result = getPetByIdWithHttpInfo(petId = petId)
        return result.body!!
    }

    @Throws(RestClientResponseException::class)
    fun getPetByIdWithHttpInfo(petId: kotlin.Long): ResponseEntity<Pet> {
        val localVariableConfig = getPetByIdRequestConfig(petId = petId)
        return request<Unit, Pet>(
            localVariableConfig
        )
    }

    fun getPetByIdRequestConfig(petId: kotlin.Long) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/xml, application/json"

        val params = mutableMapOf<String, Any>(
            "petId" to petId,
        )

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/pet/{petId}",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    @Throws(RestClientResponseException::class)
    fun updatePet(pet: Pet): Pet {
        val result = updatePetWithHttpInfo(pet = pet)
        return result.body!!
    }

    @Throws(RestClientResponseException::class)
    fun updatePetWithHttpInfo(pet: Pet): ResponseEntity<Pet> {
        val localVariableConfig = updatePetRequestConfig(pet = pet)
        return request<Pet, Pet>(
            localVariableConfig
        )
    }

    fun updatePetRequestConfig(pet: Pet) : RequestConfig<Pet> {
        val localVariableBody = pet
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Content-Type"] = "application/xml"
        localVariableHeaders["Accept"] = "application/xml, application/json"

        val params = mutableMapOf<String, Any>(
        )

        return RequestConfig(
            method = RequestMethod.PUT,
            path = "/pet",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    @Throws(RestClientResponseException::class)
    fun updatePetWithForm(petId: kotlin.Long, name: kotlin.String? = null, status: kotlin.String? = null): Unit {
        updatePetWithFormWithHttpInfo(petId = petId, name = name, status = status)
    }

    @Throws(RestClientResponseException::class)
    fun updatePetWithFormWithHttpInfo(petId: kotlin.Long, name: kotlin.String? = null, status: kotlin.String? = null): ResponseEntity<Unit> {
        val localVariableConfig = updatePetWithFormRequestConfig(petId = petId, name = name, status = status)
        return request<Map<String, PartConfig<*>>, Unit>(
            localVariableConfig
        )
    }

    fun updatePetWithFormRequestConfig(petId: kotlin.Long, name: kotlin.String? = null, status: kotlin.String? = null) : RequestConfig<Map<String, PartConfig<*>>> {
        val localVariableBody = mapOf(
            "name" to PartConfig(body = name, headers = mutableMapOf()),
            "status" to PartConfig(body = status, headers = mutableMapOf()),)
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("Content-Type" to "application/x-www-form-urlencoded")
        
        val params = mutableMapOf<String, Any>(
            "petId" to petId,
        )

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/pet/{petId}",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    @Throws(RestClientResponseException::class)
    fun uploadFile(petId: kotlin.Long, additionalMetadata: kotlin.String? = null, file: java.io.File? = null): ModelApiResponse {
        val result = uploadFileWithHttpInfo(petId = petId, additionalMetadata = additionalMetadata, file = file)
        return result.body!!
    }

    @Throws(RestClientResponseException::class)
    fun uploadFileWithHttpInfo(petId: kotlin.Long, additionalMetadata: kotlin.String? = null, file: java.io.File? = null): ResponseEntity<ModelApiResponse> {
        val localVariableConfig = uploadFileRequestConfig(petId = petId, additionalMetadata = additionalMetadata, file = file)
        return request<Map<String, PartConfig<*>>, ModelApiResponse>(
            localVariableConfig
        )
    }

    fun uploadFileRequestConfig(petId: kotlin.Long, additionalMetadata: kotlin.String? = null, file: java.io.File? = null) : RequestConfig<Map<String, PartConfig<*>>> {
        val localVariableBody = mapOf(
            "additionalMetadata" to PartConfig(body = additionalMetadata, headers = mutableMapOf()),
            "file" to PartConfig(body = file, headers = mutableMapOf()),)
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("Content-Type" to "multipart/form-data")
        localVariableHeaders["Accept"] = "application/json"

        val params = mutableMapOf<String, Any>(
            "petId" to petId,
        )

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/pet/{petId}/uploadImage",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

}
