/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package org.openapitools.client.apis

import com.fasterxml.jackson.annotation.JsonProperty

import org.springframework.web.reactive.function.client.WebClient
import org.springframework.web.reactive.function.client.WebClientResponseException
import org.springframework.http.codec.json.Jackson2JsonDecoder
import org.springframework.http.codec.json.Jackson2JsonEncoder
import org.springframework.http.ResponseEntity
import org.springframework.http.MediaType
import reactor.core.publisher.Mono
import org.springframework.util.LinkedMultiValueMap

import org.openapitools.client.models.ModelApiResponse
import org.openapitools.client.models.Pet
import org.openapitools.client.infrastructure.*

open class PetApi(client: WebClient) : ApiClient(client) {

    constructor(baseUrl: String) : this(WebClient.builder()
        .baseUrl(baseUrl)
        .codecs {
            it.defaultCodecs().jackson2JsonEncoder(Jackson2JsonEncoder(Serializer.jacksonObjectMapper, MediaType.APPLICATION_JSON))
            it.defaultCodecs().jackson2JsonDecoder(Jackson2JsonDecoder(Serializer.jacksonObjectMapper, MediaType.APPLICATION_JSON))
        }
        .build()
    )


    @Throws(WebClientResponseException::class)
    fun addPet(pet: Pet): Mono<Pet> {
        return addPetWithHttpInfo(pet = pet)
            .map { it.body!! }
    }

    @Throws(WebClientResponseException::class)
    fun addPetWithHttpInfo(pet: Pet): Mono<ResponseEntity<Pet>> {
        val localVariableConfig = addPetRequestConfig(pet = pet)
        return request<Pet, Pet>(
            localVariableConfig
        )
    }

    fun addPetRequestConfig(pet: Pet) : RequestConfig<Pet> {
        val localVariableBody = pet
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Content-Type"] = "application/xml"
        localVariableHeaders["Accept"] = "application/xml, application/json"

        val params = mutableMapOf<String, Any>(
        )

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/pet",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    @Throws(WebClientResponseException::class)
    fun deletePet(petId: kotlin.Long, apiKey: kotlin.String? = null): Mono<Unit> {
        return deletePetWithHttpInfo(petId = petId, apiKey = apiKey)
            .map { Unit }
    }

    @Throws(WebClientResponseException::class)
    fun deletePetWithHttpInfo(petId: kotlin.Long, apiKey: kotlin.String? = null): Mono<ResponseEntity<Unit>> {
        val localVariableConfig = deletePetRequestConfig(petId = petId, apiKey = apiKey)
        return request<Unit, Unit>(
            localVariableConfig
        )
    }

    fun deletePetRequestConfig(petId: kotlin.Long, apiKey: kotlin.String? = null) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        apiKey?.apply { localVariableHeaders["api_key"] = this.toString() }
        
        val params = mutableMapOf<String, Any>(
            "petId" to petId,
        )

        return RequestConfig(
            method = RequestMethod.DELETE,
            path = "/pet/{petId}",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * enum for parameter status
     */
    enum class StatusFindPetsByStatus(val value: kotlin.String) {
        @JsonProperty(value = "available") available("available"),
        @JsonProperty(value = "pending") pending("pending"),
        @JsonProperty(value = "sold") sold("sold"),
    }


    @Throws(WebClientResponseException::class)
    fun findPetsByStatus(status: kotlin.collections.List<StatusFindPetsByStatus>): Mono<kotlin.collections.List<Pet>> {
        return findPetsByStatusWithHttpInfo(status = status)
            .map { it.body!! }
    }

    @Throws(WebClientResponseException::class)
    fun findPetsByStatusWithHttpInfo(status: kotlin.collections.List<StatusFindPetsByStatus>): Mono<ResponseEntity<kotlin.collections.List<Pet>>> {
        val localVariableConfig = findPetsByStatusRequestConfig(status = status)
        return request<Unit, kotlin.collections.List<Pet>>(
            localVariableConfig
        )
    }

    fun findPetsByStatusRequestConfig(status: kotlin.collections.List<StatusFindPetsByStatus>) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("status", toMultiValue(status.toList(), "csv"))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/xml, application/json"

        val params = mutableMapOf<String, Any>(
        )

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/pet/findByStatus",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    @Throws(WebClientResponseException::class)
    @Deprecated(message = "This operation is deprecated.")
    fun findPetsByTags(tags: kotlin.collections.List<kotlin.String>): Mono<kotlin.collections.List<Pet>> {
        return findPetsByTagsWithHttpInfo(tags = tags)
            .map { it.body!! }
    }

    @Throws(WebClientResponseException::class)
    @Deprecated(message = "This operation is deprecated.")
    fun findPetsByTagsWithHttpInfo(tags: kotlin.collections.List<kotlin.String>): Mono<ResponseEntity<kotlin.collections.List<Pet>>> {
        val localVariableConfig = findPetsByTagsRequestConfig(tags = tags)
        return request<Unit, kotlin.collections.List<Pet>>(
            localVariableConfig
        )
    }

    @Deprecated(message = "This operation is deprecated.")
    fun findPetsByTagsRequestConfig(tags: kotlin.collections.List<kotlin.String>) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("tags", toMultiValue(tags.toList(), "csv"))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/xml, application/json"

        val params = mutableMapOf<String, Any>(
        )

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/pet/findByTags",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    @Throws(WebClientResponseException::class)
    fun getPetById(petId: kotlin.Long): Mono<Pet> {
        return getPetByIdWithHttpInfo(petId = petId)
            .map { it.body!! }
    }

    @Throws(WebClientResponseException::class)
    fun getPetByIdWithHttpInfo(petId: kotlin.Long): Mono<ResponseEntity<Pet>> {
        val localVariableConfig = getPetByIdRequestConfig(petId = petId)
        return request<Unit, Pet>(
            localVariableConfig
        )
    }

    fun getPetByIdRequestConfig(petId: kotlin.Long) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/xml, application/json"

        val params = mutableMapOf<String, Any>(
            "petId" to petId,
        )

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/pet/{petId}",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    @Throws(WebClientResponseException::class)
    fun updatePet(pet: Pet): Mono<Pet> {
        return updatePetWithHttpInfo(pet = pet)
            .map { it.body!! }
    }

    @Throws(WebClientResponseException::class)
    fun updatePetWithHttpInfo(pet: Pet): Mono<ResponseEntity<Pet>> {
        val localVariableConfig = updatePetRequestConfig(pet = pet)
        return request<Pet, Pet>(
            localVariableConfig
        )
    }

    fun updatePetRequestConfig(pet: Pet) : RequestConfig<Pet> {
        val localVariableBody = pet
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Content-Type"] = "application/xml"
        localVariableHeaders["Accept"] = "application/xml, application/json"

        val params = mutableMapOf<String, Any>(
        )

        return RequestConfig(
            method = RequestMethod.PUT,
            path = "/pet",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    @Throws(WebClientResponseException::class)
    fun updatePetWithForm(petId: kotlin.Long, name: kotlin.String? = null, status: kotlin.String? = null): Mono<Unit> {
        return updatePetWithFormWithHttpInfo(petId = petId, name = name, status = status)
            .map { Unit }
    }

    @Throws(WebClientResponseException::class)
    fun updatePetWithFormWithHttpInfo(petId: kotlin.Long, name: kotlin.String? = null, status: kotlin.String? = null): Mono<ResponseEntity<Unit>> {
        val localVariableConfig = updatePetWithFormRequestConfig(petId = petId, name = name, status = status)
        return request<Map<String, PartConfig<*>>, Unit>(
            localVariableConfig
        )
    }

    fun updatePetWithFormRequestConfig(petId: kotlin.Long, name: kotlin.String? = null, status: kotlin.String? = null) : RequestConfig<Map<String, PartConfig<*>>> {
        val localVariableBody = mapOf(
            "name" to PartConfig(body = name, headers = mutableMapOf()),
            "status" to PartConfig(body = status, headers = mutableMapOf()),)
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("Content-Type" to "application/x-www-form-urlencoded")
        
        val params = mutableMapOf<String, Any>(
            "petId" to petId,
        )

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/pet/{petId}",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    @Throws(WebClientResponseException::class)
    fun uploadFile(petId: kotlin.Long, additionalMetadata: kotlin.String? = null, file: java.io.File? = null): Mono<ModelApiResponse> {
        return uploadFileWithHttpInfo(petId = petId, additionalMetadata = additionalMetadata, file = file)
            .map { it.body!! }
    }

    @Throws(WebClientResponseException::class)
    fun uploadFileWithHttpInfo(petId: kotlin.Long, additionalMetadata: kotlin.String? = null, file: java.io.File? = null): Mono<ResponseEntity<ModelApiResponse>> {
        val localVariableConfig = uploadFileRequestConfig(petId = petId, additionalMetadata = additionalMetadata, file = file)
        return request<Map<String, PartConfig<*>>, ModelApiResponse>(
            localVariableConfig
        )
    }

    fun uploadFileRequestConfig(petId: kotlin.Long, additionalMetadata: kotlin.String? = null, file: java.io.File? = null) : RequestConfig<Map<String, PartConfig<*>>> {
        val localVariableBody = mapOf(
            "additionalMetadata" to PartConfig(body = additionalMetadata, headers = mutableMapOf()),
            "file" to PartConfig(body = file, headers = mutableMapOf()),)
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("Content-Type" to "multipart/form-data")
        localVariableHeaders["Accept"] = "application/json"

        val params = mutableMapOf<String, Any>(
            "petId" to petId,
        )

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/pet/{petId}/uploadImage",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

}
