# This file was generated by the Julia OpenAPI Code Generator
# Do not modify this file directly. Modify the OpenAPI specification instead.

struct UserApi <: OpenAPI.APIClientImpl
    client::OpenAPI.Clients.Client
end

"""
The default API base path for APIs in `UserApi`.
This can be used to construct the `OpenAPI.Clients.Client` instance.
"""
basepath(::Type{ UserApi }) = "http://petstore.swagger.io/v2"

const _returntypes_create_user_UserApi = Dict{Regex,Type}(
    Regex("^" * replace("0", "x"=>".") * "\$") => Nothing,
)

function _oacinternal_create_user(_api::UserApi, user::User; _mediaType=nothing)
    _ctx = OpenAPI.Clients.Ctx(_api.client, "POST", _returntypes_create_user_UserApi, "/user", ["api_key", ], user)
    OpenAPI.Clients.set_header_accept(_ctx, [])
    OpenAPI.Clients.set_header_content_type(_ctx, (_mediaType === nothing) ? ["application/json", ] : [_mediaType])
    return _ctx
end

@doc raw"""Create user

This can only be done by the logged in user.

Params:
- `user`::`User` (required)

Return: `Nothing`, `OpenAPI.Clients.ApiResponse`
"""
function create_user(_api::UserApi, user::User; _mediaType=nothing)
    _ctx = _oacinternal_create_user(_api, user; _mediaType=_mediaType)
    return OpenAPI.Clients.exec(_ctx)
end

function create_user(_api::UserApi, response_stream::Channel, user::User; _mediaType=nothing)
    _ctx = _oacinternal_create_user(_api, user; _mediaType=_mediaType)
    return OpenAPI.Clients.exec(_ctx, response_stream)
end

const _returntypes_create_users_with_array_input_UserApi = Dict{Regex,Type}(
    Regex("^" * replace("0", "x"=>".") * "\$") => Nothing,
)

function _oacinternal_create_users_with_array_input(_api::UserApi, user::Vector{User}; _mediaType=nothing)
    _ctx = OpenAPI.Clients.Ctx(_api.client, "POST", _returntypes_create_users_with_array_input_UserApi, "/user/createWithArray", ["api_key", ], user)
    OpenAPI.Clients.set_header_accept(_ctx, [])
    OpenAPI.Clients.set_header_content_type(_ctx, (_mediaType === nothing) ? ["application/json", ] : [_mediaType])
    return _ctx
end

@doc raw"""Creates list of users with given input array



Params:
- `user`::`Vector{User}` (required)

Return: `Nothing`, `OpenAPI.Clients.ApiResponse`
"""
function create_users_with_array_input(_api::UserApi, user::Vector{User}; _mediaType=nothing)
    _ctx = _oacinternal_create_users_with_array_input(_api, user; _mediaType=_mediaType)
    return OpenAPI.Clients.exec(_ctx)
end

function create_users_with_array_input(_api::UserApi, response_stream::Channel, user::Vector{User}; _mediaType=nothing)
    _ctx = _oacinternal_create_users_with_array_input(_api, user; _mediaType=_mediaType)
    return OpenAPI.Clients.exec(_ctx, response_stream)
end

const _returntypes_create_users_with_list_input_UserApi = Dict{Regex,Type}(
    Regex("^" * replace("0", "x"=>".") * "\$") => Nothing,
)

function _oacinternal_create_users_with_list_input(_api::UserApi, user::Vector{User}; _mediaType=nothing)
    _ctx = OpenAPI.Clients.Ctx(_api.client, "POST", _returntypes_create_users_with_list_input_UserApi, "/user/createWithList", ["api_key", ], user)
    OpenAPI.Clients.set_header_accept(_ctx, [])
    OpenAPI.Clients.set_header_content_type(_ctx, (_mediaType === nothing) ? ["application/json", ] : [_mediaType])
    return _ctx
end

@doc raw"""Creates list of users with given input array



Params:
- `user`::`Vector{User}` (required)

Return: `Nothing`, `OpenAPI.Clients.ApiResponse`
"""
function create_users_with_list_input(_api::UserApi, user::Vector{User}; _mediaType=nothing)
    _ctx = _oacinternal_create_users_with_list_input(_api, user; _mediaType=_mediaType)
    return OpenAPI.Clients.exec(_ctx)
end

function create_users_with_list_input(_api::UserApi, response_stream::Channel, user::Vector{User}; _mediaType=nothing)
    _ctx = _oacinternal_create_users_with_list_input(_api, user; _mediaType=_mediaType)
    return OpenAPI.Clients.exec(_ctx, response_stream)
end

const _returntypes_delete_user_UserApi = Dict{Regex,Type}(
    Regex("^" * replace("400", "x"=>".") * "\$") => Nothing,
    Regex("^" * replace("404", "x"=>".") * "\$") => Nothing,
)

function _oacinternal_delete_user(_api::UserApi, username::String; _mediaType=nothing)
    _ctx = OpenAPI.Clients.Ctx(_api.client, "DELETE", _returntypes_delete_user_UserApi, "/user/{username}", ["api_key", ])
    OpenAPI.Clients.set_param(_ctx.path, "username", username)  # type String
    OpenAPI.Clients.set_header_accept(_ctx, [])
    OpenAPI.Clients.set_header_content_type(_ctx, (_mediaType === nothing) ? [] : [_mediaType])
    return _ctx
end

@doc raw"""Delete user

This can only be done by the logged in user.

Params:
- `username`::`String` (required)

Return: `Nothing`, `OpenAPI.Clients.ApiResponse`
"""
function delete_user(_api::UserApi, username::String; _mediaType=nothing)
    _ctx = _oacinternal_delete_user(_api, username; _mediaType=_mediaType)
    return OpenAPI.Clients.exec(_ctx)
end

function delete_user(_api::UserApi, response_stream::Channel, username::String; _mediaType=nothing)
    _ctx = _oacinternal_delete_user(_api, username; _mediaType=_mediaType)
    return OpenAPI.Clients.exec(_ctx, response_stream)
end

const _returntypes_get_user_by_name_UserApi = Dict{Regex,Type}(
    Regex("^" * replace("200", "x"=>".") * "\$") => User,
    Regex("^" * replace("400", "x"=>".") * "\$") => Nothing,
    Regex("^" * replace("404", "x"=>".") * "\$") => Nothing,
)

function _oacinternal_get_user_by_name(_api::UserApi, username::String; _mediaType=nothing)
    _ctx = OpenAPI.Clients.Ctx(_api.client, "GET", _returntypes_get_user_by_name_UserApi, "/user/{username}", [])
    OpenAPI.Clients.set_param(_ctx.path, "username", username)  # type String
    OpenAPI.Clients.set_header_accept(_ctx, ["application/xml", "application/json", ])
    OpenAPI.Clients.set_header_content_type(_ctx, (_mediaType === nothing) ? [] : [_mediaType])
    return _ctx
end

@doc raw"""Get user by user name



Params:
- `username`::`String` (required)

Return: `User`, `OpenAPI.Clients.ApiResponse`
"""
function get_user_by_name(_api::UserApi, username::String; _mediaType=nothing)
    _ctx = _oacinternal_get_user_by_name(_api, username; _mediaType=_mediaType)
    return OpenAPI.Clients.exec(_ctx)
end

function get_user_by_name(_api::UserApi, response_stream::Channel, username::String; _mediaType=nothing)
    _ctx = _oacinternal_get_user_by_name(_api, username; _mediaType=_mediaType)
    return OpenAPI.Clients.exec(_ctx, response_stream)
end

const _returntypes_login_user_UserApi = Dict{Regex,Type}(
    Regex("^" * replace("200", "x"=>".") * "\$") => String,
    Regex("^" * replace("400", "x"=>".") * "\$") => Nothing,
)

function _oacinternal_login_user(_api::UserApi, username::String, password::String; _mediaType=nothing)
        OpenAPI.validate_param("username", "login_user", :pattern, username, r"^[a-zA-Z0-9]+[a-zA-Z0-9\.\-_]*[a-zA-Z0-9]+$")

    _ctx = OpenAPI.Clients.Ctx(_api.client, "GET", _returntypes_login_user_UserApi, "/user/login", [])
    OpenAPI.Clients.set_param(_ctx.query, "username", username; style="form", is_explode=true)  # type String
    OpenAPI.Clients.set_param(_ctx.query, "password", password; style="form", is_explode=true)  # type String
    OpenAPI.Clients.set_header_accept(_ctx, ["application/xml", "application/json", ])
    OpenAPI.Clients.set_header_content_type(_ctx, (_mediaType === nothing) ? [] : [_mediaType])
    return _ctx
end

@doc raw"""Logs user into the system



Params:
- `username`::`String` (required)
- `password`::`String` (required)

Return: `String`, `OpenAPI.Clients.ApiResponse`
"""
function login_user(_api::UserApi, username::String, password::String; _mediaType=nothing)
    _ctx = _oacinternal_login_user(_api, username, password; _mediaType=_mediaType)
    return OpenAPI.Clients.exec(_ctx)
end

function login_user(_api::UserApi, response_stream::Channel, username::String, password::String; _mediaType=nothing)
    _ctx = _oacinternal_login_user(_api, username, password; _mediaType=_mediaType)
    return OpenAPI.Clients.exec(_ctx, response_stream)
end

const _returntypes_logout_user_UserApi = Dict{Regex,Type}(
    Regex("^" * replace("0", "x"=>".") * "\$") => Nothing,
)

function _oacinternal_logout_user(_api::UserApi; _mediaType=nothing)
    _ctx = OpenAPI.Clients.Ctx(_api.client, "GET", _returntypes_logout_user_UserApi, "/user/logout", ["api_key", ])
    OpenAPI.Clients.set_header_accept(_ctx, [])
    OpenAPI.Clients.set_header_content_type(_ctx, (_mediaType === nothing) ? [] : [_mediaType])
    return _ctx
end

@doc raw"""Logs out current logged in user session



Params:

Return: `Nothing`, `OpenAPI.Clients.ApiResponse`
"""
function logout_user(_api::UserApi; _mediaType=nothing)
    _ctx = _oacinternal_logout_user(_api; _mediaType=_mediaType)
    return OpenAPI.Clients.exec(_ctx)
end

function logout_user(_api::UserApi, response_stream::Channel; _mediaType=nothing)
    _ctx = _oacinternal_logout_user(_api; _mediaType=_mediaType)
    return OpenAPI.Clients.exec(_ctx, response_stream)
end

const _returntypes_update_user_UserApi = Dict{Regex,Type}(
    Regex("^" * replace("400", "x"=>".") * "\$") => Nothing,
    Regex("^" * replace("404", "x"=>".") * "\$") => Nothing,
)

function _oacinternal_update_user(_api::UserApi, username::String, user::User; _mediaType=nothing)
    _ctx = OpenAPI.Clients.Ctx(_api.client, "PUT", _returntypes_update_user_UserApi, "/user/{username}", ["api_key", ], user)
    OpenAPI.Clients.set_param(_ctx.path, "username", username)  # type String
    OpenAPI.Clients.set_header_accept(_ctx, [])
    OpenAPI.Clients.set_header_content_type(_ctx, (_mediaType === nothing) ? ["application/json", ] : [_mediaType])
    return _ctx
end

@doc raw"""Updated user

This can only be done by the logged in user.

Params:
- `username`::`String` (required)
- `user`::`User` (required)

Return: `Nothing`, `OpenAPI.Clients.ApiResponse`
"""
function update_user(_api::UserApi, username::String, user::User; _mediaType=nothing)
    _ctx = _oacinternal_update_user(_api, username, user; _mediaType=_mediaType)
    return OpenAPI.Clients.exec(_ctx)
end

function update_user(_api::UserApi, response_stream::Channel, username::String, user::User; _mediaType=nothing)
    _ctx = _oacinternal_update_user(_api, username, user; _mediaType=_mediaType)
    return OpenAPI.Clients.exec(_ctx, response_stream)
end

export create_user
export create_users_with_array_input
export create_users_with_list_input
export delete_user
export get_user_by_name
export login_user
export logout_user
export update_user
