# Julia API client for OpenAPIGenPetStoreClient

This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 1.0.0
- Generator version: 7.20.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.JuliaClientCodegen


## Installation
Place the Julia files generated under the `src` folder in your Julia project. Include OpenAPIGenPetStoreClient.jl in the project code.
It would include the module named OpenAPIGenPetStoreClient.

Documentation is generated as markdown files under the `docs` folder. You can include them in your project documentation.
Documentation is also embedded in Julia which can be used with a Julia specific documentation generator.

## API Endpoints

Class | Method
------------ | -------------
*FakeApi* | [**uuid_default_value**](docs/FakeApi.md#uuid_default_value)<br/>**GET** /fake/uuid_default_value_test<br/>test uuid default value
*PetApi* | [**add_pet**](docs/PetApi.md#add_pet)<br/>**POST** /pet<br/>Add a new pet to the store
*PetApi* | [**delete_pet**](docs/PetApi.md#delete_pet)<br/>**DELETE** /pet/{petId}<br/>Deletes a pet
*PetApi* | [**find_pets_by_status**](docs/PetApi.md#find_pets_by_status)<br/>**GET** /pet/findByStatus<br/>Finds Pets by status
*PetApi* | [**find_pets_by_tags**](docs/PetApi.md#find_pets_by_tags)<br/>**GET** /pet/findByTags<br/>Finds Pets by tags
*PetApi* | [**get_pet_by_id**](docs/PetApi.md#get_pet_by_id)<br/>**GET** /pet/{petId}<br/>Find pet by ID
*PetApi* | [**update_pet**](docs/PetApi.md#update_pet)<br/>**PUT** /pet<br/>Update an existing pet
*PetApi* | [**update_pet_with_form**](docs/PetApi.md#update_pet_with_form)<br/>**POST** /pet/{petId}<br/>Updates a pet in the store with form data
*PetApi* | [**upload_file**](docs/PetApi.md#upload_file)<br/>**POST** /pet/{petId}/uploadImage<br/>uploads an image
*StoreApi* | [**delete_order**](docs/StoreApi.md#delete_order)<br/>**DELETE** /store/order/{orderId}<br/>Delete purchase order by ID
*StoreApi* | [**get_inventory**](docs/StoreApi.md#get_inventory)<br/>**GET** /store/inventory<br/>Returns pet inventories by status
*StoreApi* | [**get_order_by_id**](docs/StoreApi.md#get_order_by_id)<br/>**GET** /store/order/{orderId}<br/>Find purchase order by ID
*StoreApi* | [**place_order**](docs/StoreApi.md#place_order)<br/>**POST** /store/order<br/>Place an order for a pet
*UserApi* | [**create_user**](docs/UserApi.md#create_user)<br/>**POST** /user<br/>Create user
*UserApi* | [**create_users_with_array_input**](docs/UserApi.md#create_users_with_array_input)<br/>**POST** /user/createWithArray<br/>Creates list of users with given input array
*UserApi* | [**create_users_with_list_input**](docs/UserApi.md#create_users_with_list_input)<br/>**POST** /user/createWithList<br/>Creates list of users with given input array
*UserApi* | [**delete_user**](docs/UserApi.md#delete_user)<br/>**DELETE** /user/{username}<br/>Delete user
*UserApi* | [**get_user_by_name**](docs/UserApi.md#get_user_by_name)<br/>**GET** /user/{username}<br/>Get user by user name
*UserApi* | [**login_user**](docs/UserApi.md#login_user)<br/>**GET** /user/login<br/>Logs user into the system
*UserApi* | [**logout_user**](docs/UserApi.md#logout_user)<br/>**GET** /user/logout<br/>Logs out current logged in user session
*UserApi* | [**update_user**](docs/UserApi.md#update_user)<br/>**PUT** /user/{username}<br/>Updated user


## Models

 - [ApiResponse](docs/ApiResponse.md)
 - [Category](docs/Category.md)
 - [MappedModel](docs/MappedModel.md)
 - [Order](docs/Order.md)
 - [Pet](docs/Pet.md)
 - [Tag](docs/Tag.md)
 - [User](docs/User.md)


<a id="authorization"></a>
## Authorization

Authentication schemes defined for the API:
<a id="petstore_auth"></a>
### petstore_auth
- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: http://petstore.swagger.io/api/oauth/dialog
- **Scopes**: 
 - **write:pets**: modify pets in your account
 - **read:pets**: read your pets

Example
```
    using OpenAPI
    using OpenAPI.Clients
    import OpenAPI.Clients: Client, set_header
    client = Client(server_uri)
    set_header(client, "Authorization", "Bearer $bearer_auth")
    api = MyApi(client)
    result = callApi(api, args...; api_key)
```
<a id="api_key"></a>
### api_key
- **Type**: API key

Example
```
    using OpenAPI
    using OpenAPI.Clients
    import OpenAPI.Clients: Client
    client = Client(server_uri)
    api = MyApi(client)
    result = callApi(api, args...; api_key)
```

## Author



