/**
 * OpenAPI Petstore
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD.
    define(['expect.js', '../../src/index'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    factory(require('expect.js'), require('../../src/index'));
  } else {
    // Browser globals (root is window)
    factory(root.expect, root.OpenApiPetstore);
  }
}(this, function(expect, OpenApiPetstore) {
  'use strict';

  var api_instance;
  var id = 129038120;

  beforeEach(function() {
    api_instance = new OpenApiPetstore.PetApi();
  });

  var getProperty = function(object, getter, property) {
    // Use getter method if present; otherwise, get the property directly.
    if (typeof object[getter] === 'function')
      return object[getter]();
    else
      return object[property];
  }

  var setProperty = function(object, setter, property, value) {
    // Use setter method if present; otherwise, set the property directly.
    if (typeof object[setter] === 'function')
      object[setter](value);
    else
      object[property] = value;
  }

  var createRandomPet = function() {
    var pet = new OpenApiPetstore.Pet();
    setProperty(pet, "setId", "id", id);
    setProperty(pet, "setName", "name", "pet" + id);

    var category = new OpenApiPetstore.Category();
    setProperty(category, "setId", "id", id);
    setProperty(category, "setName", "name", "category" + id);
    setProperty(pet, "setCategory", "category", category);

    setProperty(pet, "setStatus", "status", "available");
    var photos = ["http://foo.bar.com/1", "http://foo.bar.com/2"];
    setProperty(pet, "setPhotoUrls", "photoUrls", photos);

    return pet;
  }

  describe('PetApi', function() {
    it('should create and get pet', function(done) {
      this.timeout(15000);
      var pet = createRandomPet();
      try {
        //api_instance.addPet(pet, {_base_path_index: 1}, function(error) {
        api_instance.addPet(pet, null, function(error) {
          if (error) throw error;

          api_instance.getPetById(pet.id, function(error, fetched, response) {
            if (error) throw error;
            expect(response.status).to.be(200);
            expect(response.ok).to.be(true);
            expect(response.get('Content-Type')).to.be('application/json');

            expect(fetched).to.be.a(OpenApiPetstore.Pet);
            expect(JSON.stringify(fetched)).to.be('{"name":"pet129038120","photoUrls":["http://foo.bar.com/1","http://foo.bar.com/2"],"id":129038120,"category":{"name":"category129038120","id":129038120},"tags":[],"status":"available"}');

            // test ApiClient.convertToType 
            var tag_result = OpenApiPetstore.ApiClient.convertToType(JSON.stringify(fetched), OpenApiPetstore.Pet);
            expect(tag_result).to.be.a(OpenApiPetstore.Pet);

            // test returned object `Pet`
            expect(fetched.id).to.be(pet.id);
            expect(getProperty(fetched, "getPhotoUrls", "photoUrls"))
              .to.eql(getProperty(pet, "getPhotoUrls", "photoUrls"));
            expect(getProperty(fetched, "getCategory", "category"))
              .to.be.a(OpenApiPetstore.Category);
            expect(getProperty(getProperty(fetched, "getCategory", "category"), "getName", "name"))
              .to.be(getProperty(getProperty(pet, "getCategory", "category"), "getName", "name"));

            api_instance.deletePet(pet.id);
            done();
          });
        });
      } catch (error) {
        done(error);
      }
    });
    describe('addPet', function() {
      it('should call addPet successfully', function(done) {
        //uncomment below and update the code to test addPet
        //instance.addPet(function(error) {
        //  if (error) throw error;
        //expect().to.be();
        //});
        done();
      });
    });
    describe('deletePet', function() {
      it('should call deletePet successfully', function(done) {
        //uncomment below and update the code to test deletePet
        //instance.deletePet(function(error) {
        //  if (error) throw error;
        //expect().to.be();
        //});
        done();
      });
    });
    describe('findPetsByStatus', function() {
      it('should call findPetsByStatus successfully', function(done) {
        //uncomment below and update the code to test findPetsByStatus
        //instance.findPetsByStatus(function(error) {
        //  if (error) throw error;
        //expect().to.be();
        //});
        done();
      });
    });
    describe('findPetsByTags', function() {
      it('should call findPetsByTags successfully', function(done) {
        //uncomment below and update the code to test findPetsByTags
        //instance.findPetsByTags(function(error) {
        //  if (error) throw error;
        //expect().to.be();
        //});
        done();
      });
    });
    describe('getPetById', function() {
      it('should call getPetById successfully', function(done) {
        //uncomment below and update the code to test getPetById
        //instance.getPetById(function(error) {
        //  if (error) throw error;
        //expect().to.be();
        //});
        done();
      });
    });
    describe('updatePet', function() {
      it('should call updatePet successfully', function(done) {
        //uncomment below and update the code to test updatePet
        //instance.updatePet(function(error) {
        //  if (error) throw error;
        //expect().to.be();
        //});
        done();
      });
    });
    describe('updatePetWithForm', function() {
      it('should call updatePetWithForm successfully', function(done) {
        //uncomment below and update the code to test updatePetWithForm
        //instance.updatePetWithForm(function(error) {
        //  if (error) throw error;
        //expect().to.be();
        //});
        done();
      });
    });
    describe('uploadFile', function() {
      it('should call uploadFile successfully', function(done) {
        //uncomment below and update the code to test uploadFile
        //instance.uploadFile(function(error) {
        //  if (error) throw error;
        //expect().to.be();
        //});
        done();
      });
    });
  });

}));
