lazy val root = (project in file(".")).
  settings(
    organization := "org.openapitools",
    name := "petstore-retrofit2-rx2",
    version := "1.0.0",
    scalaVersion := "2.11.12",
    scalacOptions ++= Seq("-feature"),
    compile / javacOptions ++= Seq("-Xlint:deprecation"),
    Compile / packageDoc / publishArtifact := false,
    resolvers += Resolver.mavenLocal,
    libraryDependencies ++= Seq(
      "com.squareup.retrofit2" % "retrofit" % "2.11.0" % "compile",
      "com.squareup.retrofit2" % "converter-scalars" % "2.11.0" % "compile",
      "com.squareup.retrofit2" % "converter-gson" % "2.11.0" % "compile",
      "com.squareup.retrofit2" % "adapter-rxjava2" % "2.11.0" % "compile",
      "io.reactivex.rxjava2" % "rxjava" % "2.1.1" % "compile",
      "io.swagger" % "swagger-annotations" % "1.5.21" % "compile",
      "org.apache.oltu.oauth2" % "org.apache.oltu.oauth2.client" % "1.0.1" % "compile",
      "io.gsonfire" % "gson-fire" % "1.9.0" % "compile",
      "jakarta.annotation" % "jakarta.annotation-api" % "1.3.5" % "compile",
      "org.junit.jupiter" % "junit-jupiter-api" % "5.10.3" % "test",
      "com.novocode" % "junit-interface" % "0.11" % "test"
    )
  )
