/*
 * OpenAPI Petstore
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.api;

import static org.junit.jupiter.api.Assertions.*;

import org.junit.jupiter.api.Test;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.auth.ApiKeyAuth;
import org.openapitools.client.model.Category;
import org.openapitools.client.model.Pet;
import org.openapitools.client.model.Tag;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * API tests for PetApi
 */
public class PetApiTest {

    private final PetApi api = new PetApi();
    private final long petId = 5638l;


    /**
     * Add a new pet to the store
     *
     * @throws ApiException if the Api call fails
     */
    @Test
    public void addPetTest() throws ApiException {
        // add pet
        Pet body = new Pet();
        body.setId(petId);
        body.setName("jersey2 java8 pet");
        Category category = new Category();
        category.setId(petId);
        category.setName("jersey2 java8 category");
        body.setCategory(category);
        body.setStatus(Pet.StatusEnum.AVAILABLE);
        body.setPhotoUrls(new HashSet<>(Arrays.asList("A", "B", "C")));
        Tag tag = new Tag();
        tag.setId(petId);
        tag.setName("jersey2 java8 tag");
        body.setTags(Arrays.asList(tag));

        api.addPet(body);

        //get pet by ID
        Pet result = api.getPetById(petId);
        assertEquals(result.getId(), body.getId());
        assertEquals(result.getCategory(), category);
        assertEquals(result.getName(), body.getName());
        assertEquals(result.getPhotoUrls(), body.getPhotoUrls());
        assertEquals(result.getStatus(), body.getStatus());
        assertEquals(result.getTags(), body.getTags());

        // update pet
        api.updatePetWithForm(petId, "jersey2 java8 pet 2", "sold");

        //get pet by ID
        Pet result2 = api.getPetById(petId);
        assertEquals(result2.getId(), body.getId());
        assertEquals(result2.getCategory(), category);
        assertEquals(result2.getName(), "jersey2 java8 pet 2");
        assertEquals(result2.getPhotoUrls(), body.getPhotoUrls());
        assertEquals(result2.getStatus(), Pet.StatusEnum.SOLD);
        assertEquals(result2.getTags(), body.getTags());

        // delete pet
        api.deletePet(petId, "empty api key");

        try {
            Pet result3 = api.getPetById(petId);
            assertEquals(false, true);
        } catch (ApiException e) {
//            System.err.println("Exception when calling PetApi#getPetById");
//            System.err.println("Status code: " + e.getCode());
//            System.err.println("Reason: " + e.getResponseBody());
//            System.err.println("Response headers: " + e.getResponseHeaders());

            assertEquals(e.getCode(), 404);
            assertEquals(e.getResponseBody(), "{\"code\":1,\"type\":\"error\",\"message\":\"Pet not found\"}");

        }

    }

    /**
     * Deletes a pet
     *
     * @throws ApiException if the Api call fails
     */
    @Test
    public void deletePetTest() throws ApiException {
        Long petId = null;
        String apiKey = null;
        // TODO: test validations
        //api.deletePet(petId, apiKey);
    }

    /**
     * Finds Pets by status
     * <p>
     * Multiple status values can be provided with comma separated strings
     *
     * @throws ApiException if the Api call fails
     */
    @Test
    public void findPetsByStatusTest() throws ApiException {
        List<String> status = null;
        //List<Pet> response = api.findPetsByStatus(status);
        // TODO: test validations
    }

    /**
     * Finds Pets by tags
     * <p>
     * Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
     *
     * @throws ApiException if the Api call fails
     */
    @Test
    public void findPetsByTagsTest() throws ApiException {
        Set<String> tags = null;
        //Set<Pet> response = api.findPetsByTags(tags);
        // TODO: test validations
    }

    /**
     * Find pet by ID
     * <p>
     * Returns a single pet
     *
     * @throws ApiException if the Api call fails
     */
    @Test
    public void getPetByIdTest() throws ApiException {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://petstore.swagger.io:80/v2");

        // Configure API key authorization: api_key
        ApiKeyAuth api_key = (ApiKeyAuth) defaultClient.getAuthentication("api_key");
        api_key.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //api_key.setApiKeyPrefix("Token");

        PetApi apiInstance = new PetApi(defaultClient);
        Long petId = 56L; // Long | ID of pet to return
        try {
            Pet result = apiInstance.getPetById(petId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling PetApi#getPetById");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
        }

    }

    /**
     * Update an existing pet
     *
     * @throws ApiException if the Api call fails
     */
    @Test
    public void updatePetTest() throws ApiException {
        Pet body = null;
        //api.updatePet(body);
        // TODO: test validations
    }

    /**
     * Updates a pet in the store with form data
     *
     * @throws ApiException if the Api call fails
     */
    @Test
    public void updatePetWithFormTest() throws ApiException {
        Long petId = null;
        String name = null;
        String status = null;
        //api.updatePetWithForm(petId, name, status);
        // TODO: test validations
    }

    /**
     * uploads an image
     *
     * @throws ApiException if the Api call fails
     */
    @Test
    public void uploadFileTest() throws ApiException {
        Long petId = null;
        String additionalMetadata = null;
        File file = null;
        //ModelApiResponse response = api.uploadFile(petId, additionalMetadata, file);
        // TODO: test validations
    }

    /**
     * uploads an image (required)
     *
     * @throws ApiException if the Api call fails
     */
    @Test
    public void uploadFileWithRequiredFileTest() throws ApiException {
        Long petId = null;
        File requiredFile = null;
        String additionalMetadata = null;
        //ModelApiResponse response = api.uploadFileWithRequiredFile(petId, requiredFile, additionalMetadata);
        // TODO: test validations
    }

}
