# petstore-micronaut

This is a generated client based on [Micronaut](https://micronaut.io/) framework.

## Configuration

A Micronaut's application can be created by defining a main class and running:
```java
import io.micronaut.runtime.Micronaut;
import io.micronaut.context.ApplicationContext;

public class Application {

    public static void main(String[] args) {
        ApplicationContext context = Micronaut.run(Application.class);
    }
}
```

More detailed description can be found in the [Micronaut Guide](https://docs.micronaut.io/latest/guide/#ideSetup).

All the properties can be changed in the [application.yml][src/main/resources/application.yml] file or when creating micronaut application as described in [Configuration section of guide](https://docs.micronaut.io/latest/guide/#config).

## Api Guides

Description on how to create Apis is given inside individual api guides:

* [AnotherFakeApi](docs/apis/AnotherFakeApi.md)
* [FakeApi](docs/apis/FakeApi.md)
* [FakeClassnameTags123Api](docs/apis/FakeClassnameTags123Api.md)
* [PetApi](docs/apis/PetApi.md)
* [StoreApi](docs/apis/StoreApi.md)
* [UserApi](docs/apis/UserApi.md)


## Auth methods

Details on auth methods can be found in the [auth.md](doc/auth.md).

## Author









