/*
 * OpenAPI Petstore
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.openapitools.client.api;

import org.openapitools.client.ApiResponse;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.openapitools.client.model.ModelApiResponse;
import org.openapitools.client.model.Pet;
import java.util.Set;

/**
 * OpenAPI Petstore
 *
 * <p>This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 */
public interface PetApi {

 /**
  * Add a new pet to the store
  * 
  * @param pet Pet object that needs to be added to the store (required)
  * @return {@code ApiResponse<Void>}
  */
  ApiResponse<Void> addPet(Pet pet);

 /**
  * Deletes a pet
  * 
  * @param petId Pet id to delete (required)
  * @param apiKey  (optional)
  * @return {@code ApiResponse<Void>}
  */
  ApiResponse<Void> deletePet(Long petId, String apiKey);

 /**
  * Finds Pets by status
  * Multiple status values can be provided with comma separated strings
  * @param status Status values that need to be considered for filter (required)
  * @return {@code ApiResponse<List<Pet>>}
  */
  ApiResponse<List<Pet>> findPetsByStatus(List<String> status);

 /**
  * Finds Pets by tags
  * Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
  * @param tags Tags to filter by (required)
  * @return {@code ApiResponse<List<Pet>>}
  * @deprecated
  */
  @Deprecated
  ApiResponse<List<Pet>> findPetsByTags(Set<String> tags);

 /**
  * Find pet by ID
  * Returns a single pet
  * @param petId ID of pet to return (required)
  * @return {@code ApiResponse<Pet>}
  */
  ApiResponse<Pet> getPetById(Long petId);

 /**
  * Update an existing pet
  * 
  * @param pet Pet object that needs to be added to the store (required)
  * @return {@code ApiResponse<Void>}
  */
  ApiResponse<Void> updatePet(Pet pet);

 /**
  * Updates a pet in the store with form data
  * 
  * @param petId ID of pet that needs to be updated (required)
  * @param name Updated name of the pet (optional)
  * @param status Updated status of the pet (optional)
  * @return {@code ApiResponse<Void>}
  */
  ApiResponse<Void> updatePetWithForm(Long petId, String name, String status);

 /**
  * uploads an image
  * 
  * @param petId ID of pet to update (required)
  * @param additionalMetadata Additional data to pass to server (optional)
  * @param _file file to upload (optional)
  * @return {@code ApiResponse<ModelApiResponse>}
  */
  ApiResponse<ModelApiResponse> uploadFile(Long petId, String additionalMetadata, File _file);

 /**
  * uploads an image (required)
  * 
  * @param petId ID of pet to update (required)
  * @param requiredFile file to upload (required)
  * @param additionalMetadata Additional data to pass to server (optional)
  * @return {@code ApiResponse<ModelApiResponse>}
  */
  ApiResponse<ModelApiResponse> uploadFileWithRequiredFile(Long petId, File requiredFile, String additionalMetadata);

}
