extends DemoApiBee
class_name DemoStoreApi

# THIS FILE WAS AUTOMATICALLY GENERATED by the OpenAPI Generator project.
# For more information on how to customize templates, see:
# https://openapi-generator.tech
# https://github.com/OpenAPITools/openapi-generator/tree/master/modules/openapi-generator/src/main/resources/gdscript
# The OpenAPI Generator Community, © Public Domain, 2022

# API DemoStoreApi
# Instantiate this object and use it to make requests to the API.

func _bzz_get_api_name() -> String:
	return "DemoStoreApi"


# Operation deleteOrder → DELETE /store/order/{orderId}
# Delete purchase order by ID
#
# For valid response try integer IDs with value < 1000. Anything above 1000 or nonintegers will generate API errors
func delete_order(
	# orderId: String = ""   Eg: orderId_example
	# ID of the order that needs to be deleted
	orderId: String,
	on_success: Callable = Callable(),  # func(response: DemoApiResponse)
	on_failure: Callable = Callable(),  # func(error: DemoApiError)
):

	# Convert the String HTTP method to a Constant Godot understands
	var bzz_method := self._bzz_convert_http_method("DELETE")

	# Compute the URL path to the API resource
	var bzz_path := "/v2/store/order/{orderId}".replace("{" + "orderId" + "}", _bzz_urlize_path_param(orderId))

	# Collect the headers
	var bzz_headers := Dictionary()

	# Collect the query parameters
	# Note: we do not support multiple values for a single param (for now), nor arrays
	var bzz_query := Dictionary()

	var bzz_body = null

	self._bzz_request(
		bzz_method, bzz_path, bzz_headers, bzz_query, bzz_body,
		func(bzz_response):
			on_success.call(bzz_response)
			,
		func(bzz_error):
			on_failure.call(bzz_error)
			,  # ざわ‥
	)


func delete_order_threaded(
	# orderId: String = ""   Eg: orderId_example
	# ID of the order that needs to be deleted
	orderId: String,
	on_success: Callable = Callable(),  # func(response: DemoApiResponse)
	on_failure: Callable = Callable(),  # func(error: DemoApiError)
) -> Thread:
	var bzz_thread := Thread.new()
	var bzz_callable := Callable(self, "delete_order")
	bzz_callable.bind(
		orderId,
		on_success,
		on_failure,
	)
	bzz_thread.start(bzz_callable)
	return bzz_thread


# Operation getInventory → GET /store/inventory
# Returns pet inventories by status
#
# Returns a map of status codes to quantities
func get_inventory(
	on_success: Callable = Callable(),  # func(response: DemoApiResponse)
	on_failure: Callable = Callable(),  # func(error: DemoApiError)
):

	# Convert the String HTTP method to a Constant Godot understands
	var bzz_method := self._bzz_convert_http_method("GET")

	# Compute the URL path to the API resource
	var bzz_path := "/v2/store/inventory"

	# Collect the headers
	var bzz_headers := Dictionary()
	var bzz_mimes_produced_by_server := ['application/json']
	for bzz_mime in BZZ_CONSUMABLE_CONTENT_TYPES:
		if bzz_mime in bzz_mimes_produced_by_server:
			bzz_headers["Accept"] = bzz_mime
			break

	# Collect the query parameters
	# Note: we do not support multiple values for a single param (for now), nor arrays
	var bzz_query := Dictionary()

	var bzz_body = null

	self._bzz_request(
		bzz_method, bzz_path, bzz_headers, bzz_query, bzz_body,
		func(bzz_response):
			on_success.call(bzz_response)
			,
		func(bzz_error):
			on_failure.call(bzz_error)
			,  # ざわ‥
	)


func get_inventory_threaded(
	on_success: Callable = Callable(),  # func(response: DemoApiResponse)
	on_failure: Callable = Callable(),  # func(error: DemoApiError)
) -> Thread:
	var bzz_thread := Thread.new()
	var bzz_callable := Callable(self, "get_inventory")
	bzz_callable.bind(
		on_success,
		on_failure,
	)
	bzz_thread.start(bzz_callable)
	return bzz_thread


# Operation getOrderById → GET /store/order/{orderId}
# Find purchase order by ID
#
# For valid response try integer IDs with value <= 5 or > 10. Other values will generate exceptions
func get_order_by_id(
	# orderId: float   Eg: 789
	# ID of pet that needs to be fetched
	orderId: float,
	on_success: Callable = Callable(),  # func(response: DemoApiResponse)
	on_failure: Callable = Callable(),  # func(error: DemoApiError)
):

	# Validate param `orderId` constraints
	if orderId > 5:
		var error := DemoApiError.new()
		error.identifier = "get_order_by_id.param.validation.maximum"
		error.message = "Invalid value for `orderId`, must be smaller than or equal to 5."
		on_failure.call(error)
		return
	if orderId < 1:
		var error := DemoApiError.new()
		error.identifier = "get_order_by_id.param.validation.minimum"
		error.message = "Invalid value for `orderId`, must be greater than or equal to 1."
		on_failure.call(error)
		return

	# Convert the String HTTP method to a Constant Godot understands
	var bzz_method := self._bzz_convert_http_method("GET")

	# Compute the URL path to the API resource
	var bzz_path := "/v2/store/order/{orderId}".replace("{" + "orderId" + "}", _bzz_urlize_path_param(orderId))

	# Collect the headers
	var bzz_headers := Dictionary()
	var bzz_mimes_produced_by_server := ['application/xml', 'application/json']
	for bzz_mime in BZZ_CONSUMABLE_CONTENT_TYPES:
		if bzz_mime in bzz_mimes_produced_by_server:
			bzz_headers["Accept"] = bzz_mime
			break

	# Collect the query parameters
	# Note: we do not support multiple values for a single param (for now), nor arrays
	var bzz_query := Dictionary()

	var bzz_body = null

	self._bzz_request(
		bzz_method, bzz_path, bzz_headers, bzz_query, bzz_body,
		func(bzz_response):
			bzz_response.data = DemoOrderModel.bzz_denormalize_single(bzz_response.data)
			on_success.call(bzz_response)
			,
		func(bzz_error):
			on_failure.call(bzz_error)
			,  # ざわ‥
	)


func get_order_by_id_threaded(
	# orderId: float   Eg: 789
	# ID of pet that needs to be fetched
	orderId: float,
	on_success: Callable = Callable(),  # func(response: DemoApiResponse)
	on_failure: Callable = Callable(),  # func(error: DemoApiError)
) -> Thread:
	var bzz_thread := Thread.new()
	var bzz_callable := Callable(self, "get_order_by_id")
	bzz_callable.bind(
		orderId,
		on_success,
		on_failure,
	)
	bzz_thread.start(bzz_callable)
	return bzz_thread


# Operation placeOrder → POST /store/order
# Place an order for a pet
func place_order(
	# demoOrderModel: DemoOrderModel
	# order placed for purchasing the pet
	demoOrderModel: DemoOrderModel,
	on_success: Callable = Callable(),  # func(response: DemoApiResponse)
	on_failure: Callable = Callable(),  # func(error: DemoApiError)
):

	# Convert the String HTTP method to a Constant Godot understands
	var bzz_method := self._bzz_convert_http_method("POST")

	# Compute the URL path to the API resource
	var bzz_path := "/v2/store/order"

	# Collect the headers
	var bzz_headers := Dictionary()
	var bzz_mimes_consumable_by_server := ['application/json']
	var bzz_found_producible_mime := false
	for bzz_mime in BZZ_PRODUCIBLE_CONTENT_TYPES:
		if bzz_mime in bzz_mimes_consumable_by_server:
			bzz_headers["Content-Type"] = bzz_mime
			bzz_found_producible_mime = true
			break
	if not bzz_found_producible_mime:
		var error := DemoApiError.new()
		error.identifier = "place_order.headers.content_type"
		error.message = "That endpoint only accepts %s as content type(s) and none are supported by this client."
		on_failure.call(error)
		return
	var bzz_mimes_produced_by_server := ['application/xml', 'application/json']
	for bzz_mime in BZZ_CONSUMABLE_CONTENT_TYPES:
		if bzz_mime in bzz_mimes_produced_by_server:
			bzz_headers["Accept"] = bzz_mime
			break

	# Collect the query parameters
	# Note: we do not support multiple values for a single param (for now), nor arrays
	var bzz_query := Dictionary()

	var bzz_body = null
	bzz_body = demoOrderModel

	self._bzz_request(
		bzz_method, bzz_path, bzz_headers, bzz_query, bzz_body,
		func(bzz_response):
			bzz_response.data = DemoOrderModel.bzz_denormalize_single(bzz_response.data)
			on_success.call(bzz_response)
			,
		func(bzz_error):
			on_failure.call(bzz_error)
			,  # ざわ‥
	)


func place_order_threaded(
	# demoOrderModel: DemoOrderModel
	# order placed for purchasing the pet
	demoOrderModel: DemoOrderModel,
	on_success: Callable = Callable(),  # func(response: DemoApiResponse)
	on_failure: Callable = Callable(),  # func(error: DemoApiError)
) -> Thread:
	var bzz_thread := Thread.new()
	var bzz_callable := Callable(self, "place_order")
	bzz_callable.bind(
		demoOrderModel,
		on_success,
		on_failure,
	)
	bzz_thread.start(bzz_callable)
	return bzz_thread


