/*
 * OpenAPI Petstore
 *
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using OpenAPIDateConverter = Org.OpenAPITools.Client.OpenAPIDateConverter;

namespace Org.OpenAPITools.Model
{
    /// <summary>
    /// CopyActivity
    /// </summary>
    [DataContract(Name = "CopyActivity")]
    public partial class CopyActivity : EntityBase, IEquatable<CopyActivity>
    {
        /// <summary>
        /// Defines Schema
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum SchemaEnum
        {
            /// <summary>
            /// Enum ScopeActivity for value: ScopeActivity
            /// </summary>
            [EnumMember(Value = "ScopeActivity")]
            ScopeActivity = 1
        }


        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "$schema", IsRequired = true, EmitDefaultValue = true)]
        public SchemaEnum Schema { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="CopyActivity" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected CopyActivity() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="CopyActivity" /> class.
        /// </summary>
        /// <param name="schema">schema (required) (default to SchemaEnum.ScopeActivity).</param>
        /// <param name="copyActivitytt">copyActivitytt (required).</param>
        public CopyActivity(SchemaEnum schema = SchemaEnum.ScopeActivity, string copyActivitytt = default) : base()
        {
            this.Schema = schema;
            // to ensure "copyActivitytt" is required (not null)
            if (copyActivitytt == null)
            {
                throw new ArgumentNullException("copyActivitytt is a required property for CopyActivity and cannot be null");
            }
            this.CopyActivitytt = copyActivitytt;
        }

        /// <summary>
        /// Gets or Sets CopyActivitytt
        /// </summary>
        [DataMember(Name = "copyActivitytt", IsRequired = true, EmitDefaultValue = true)]
        public string CopyActivitytt { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class CopyActivity {\n");
            sb.Append("  ").Append(base.ToString().Replace("\n", "\n  ")).Append("\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  CopyActivitytt: ").Append(CopyActivitytt).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public override string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as CopyActivity);
        }

        /// <summary>
        /// Returns true if CopyActivity instances are equal
        /// </summary>
        /// <param name="input">Instance of CopyActivity to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(CopyActivity input)
        {
            if (input == null)
            {
                return false;
            }
            return base.Equals(input) && 
                (
                    this.Schema == input.Schema ||
                    this.Schema.Equals(input.Schema)
                ) && base.Equals(input) && 
                (
                    this.CopyActivitytt == input.CopyActivitytt ||
                    (this.CopyActivitytt != null &&
                    this.CopyActivitytt.Equals(input.CopyActivitytt))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = base.GetHashCode();
                hashCode = (hashCode * 59) + this.Schema.GetHashCode();
                if (this.CopyActivitytt != null)
                {
                    hashCode = (hashCode * 59) + this.CopyActivitytt.GetHashCode();
                }
                return hashCode;
            }
        }

    }

}
