/*
 * OpenAPI Petstore
 *
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Org.OpenAPITools.Client.OpenAPIDateConverter;
using OpenAPIClientUtils = Org.OpenAPITools.Client.ClientUtils;

namespace Org.OpenAPITools.Model
{
    /// <summary>
    /// TestResult
    /// </summary>
    [DataContract(Name = "TestResult")]
    public partial class TestResult : IEquatable<TestResult>, IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Code
        /// </summary>

        [DataMember(Name = "code", EmitDefaultValue = false)]
        public TestResultCode? Code
        {
            get{ return _Code;}
            set
            {
                _Code = value;
                _flagCode = true;
            }
        }
        private TestResultCode? _Code;
        private bool _flagCode;

        /// <summary>
        /// Returns false as Code should not be serialized given that it's read-only.
        /// </summary>
        /// <returns>false (boolean)</returns>
        public bool ShouldSerializeCode()
        {
            return _flagCode;
        }
        /// <summary>
        /// Initializes a new instance of the <see cref="TestResult" /> class.
        /// </summary>
        /// <param name="code">code.</param>
        /// <param name="uuid">Result unique identifier.</param>
        /// <param name="data">list of named parameters for current message.</param>
        public TestResult(TestResultCode? code = default, string uuid = default, Dictionary<string, string> data = default)
        {
            this._Code = code;
            if (this.Code != null)
            {
                this._flagCode = true;
            }
            this._Uuid = uuid;
            if (this.Uuid != null)
            {
                this._flagUuid = true;
            }
            this._Data = data;
            if (this.Data != null)
            {
                this._flagData = true;
            }
            this.AdditionalProperties = new Dictionary<string, object>();
        }

        /// <summary>
        /// Result unique identifier
        /// </summary>
        /// <value>Result unique identifier</value>
        [DataMember(Name = "uuid", EmitDefaultValue = false)]
        public string Uuid
        {
            get{ return _Uuid;}
            set
            {
                _Uuid = value;
                _flagUuid = true;
            }
        }
        private string _Uuid;
        private bool _flagUuid;

        /// <summary>
        /// Returns false as Uuid should not be serialized given that it's read-only.
        /// </summary>
        /// <returns>false (boolean)</returns>
        public bool ShouldSerializeUuid()
        {
            return _flagUuid;
        }
        /// <summary>
        /// list of named parameters for current message
        /// </summary>
        /// <value>list of named parameters for current message</value>
        [DataMember(Name = "data", EmitDefaultValue = false)]
        public Dictionary<string, string> Data
        {
            get{ return _Data;}
            set
            {
                _Data = value;
                _flagData = true;
            }
        }
        private Dictionary<string, string> _Data;
        private bool _flagData;

        /// <summary>
        /// Returns false as Data should not be serialized given that it's read-only.
        /// </summary>
        /// <returns>false (boolean)</returns>
        public bool ShouldSerializeData()
        {
            return _flagData;
        }
        /// <summary>
        /// Gets or Sets additional properties
        /// </summary>
        [JsonExtensionData]
        public IDictionary<string, object> AdditionalProperties { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class TestResult {\n");
            sb.Append("  Code: ").Append(Code).Append("\n");
            sb.Append("  Uuid: ").Append(Uuid).Append("\n");
            sb.Append("  Data: ").Append(Data).Append("\n");
            sb.Append("  AdditionalProperties: ").Append(AdditionalProperties).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return OpenAPIClientUtils.compareLogic.Compare(this, input as TestResult).AreEqual;
        }

        /// <summary>
        /// Returns true if TestResult instances are equal
        /// </summary>
        /// <param name="input">Instance of TestResult to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(TestResult input)
        {
            return OpenAPIClientUtils.compareLogic.Compare(this, input).AreEqual;
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                hashCode = (hashCode * 59) + this.Code.GetHashCode();
                if (this.Uuid != null)
                {
                    hashCode = (hashCode * 59) + this.Uuid.GetHashCode();
                }
                if (this.Data != null)
                {
                    hashCode = (hashCode * 59) + this.Data.GetHashCode();
                }
                if (this.AdditionalProperties != null)
                {
                    hashCode = (hashCode * 59) + this.AdditionalProperties.GetHashCode();
                }
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }

}
