/*
 * OpenAPI Petstore
 *
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using JsonSubTypes;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Org.OpenAPITools.Client.OpenAPIDateConverter;
using OpenAPIClientUtils = Org.OpenAPITools.Client.ClientUtils;

namespace Org.OpenAPITools.Model
{
    /// <summary>
    /// Descendant1
    /// </summary>
    [DataContract(Name = "Descendant1")]
    public partial class Descendant1 : TestDescendants, IEquatable<Descendant1>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Descendant1" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected Descendant1()
        {
            this.AdditionalProperties = new Dictionary<string, object>();
        }
        /// <summary>
        /// Initializes a new instance of the <see cref="Descendant1" /> class.
        /// </summary>
        /// <param name="descendantName">descendantName (required).</param>
        /// <param name="alternativeName">alternativeName (required).</param>
        /// <param name="objectType">objectType (required) (default to ObjectTypeEnum.Descendant1).</param>
        public Descendant1(string descendantName = default, string alternativeName = default, ObjectTypeEnum objectType = ObjectTypeEnum.Descendant1) : base(alternativeName, objectType)
        {
            // to ensure "descendantName" is required (not null)
            if (descendantName == null)
            {
                throw new ArgumentNullException("descendantName is a required property for Descendant1 and cannot be null");
            }
            this._DescendantName = descendantName;
            this.AdditionalProperties = new Dictionary<string, object>();
        }

        /// <summary>
        /// Gets or Sets DescendantName
        /// </summary>
        [DataMember(Name = "descendantName", IsRequired = true, EmitDefaultValue = true)]
        public string DescendantName
        {
            get{ return _DescendantName;}
            set
            {
                _DescendantName = value;
                _flagDescendantName = true;
            }
        }
        private string _DescendantName;
        private bool _flagDescendantName;

        /// <summary>
        /// Returns false as DescendantName should not be serialized given that it's read-only.
        /// </summary>
        /// <returns>false (boolean)</returns>
        public bool ShouldSerializeDescendantName()
        {
            return _flagDescendantName;
        }
        /// <summary>
        /// Gets or Sets additional properties
        /// </summary>
        [JsonExtensionData]
        public IDictionary<string, object> AdditionalProperties { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class Descendant1 {\n");
            sb.Append("  ").Append(base.ToString().Replace("\n", "\n  ")).Append("\n");
            sb.Append("  DescendantName: ").Append(DescendantName).Append("\n");
            sb.Append("  AdditionalProperties: ").Append(AdditionalProperties).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public override string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return OpenAPIClientUtils.compareLogic.Compare(this, input as Descendant1).AreEqual;
        }

        /// <summary>
        /// Returns true if Descendant1 instances are equal
        /// </summary>
        /// <param name="input">Instance of Descendant1 to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(Descendant1 input)
        {
            return OpenAPIClientUtils.compareLogic.Compare(this, input).AreEqual;
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = base.GetHashCode();
                if (this.DescendantName != null)
                {
                    hashCode = (hashCode * 59) + this.DescendantName.GetHashCode();
                }
                if (this.AdditionalProperties != null)
                {
                    hashCode = (hashCode * 59) + this.AdditionalProperties.GetHashCode();
                }
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            return this.BaseValidate(validationContext);
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        protected IEnumerable<ValidationResult> BaseValidate(ValidationContext validationContext)
        {
            foreach (var x in base.BaseValidate(validationContext))
            {
                yield return x;
            }
            yield break;
        }
    }

}
