// <auto-generated>
/*
 * OpenAPI Petstore
 *
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Text.Json;
using System.Text.Json.Serialization;
using System.ComponentModel.DataAnnotations;
using OpenAPIClientUtils = Org.OpenAPITools.Client.ClientUtils;
using Org.OpenAPITools.Client;

namespace Org.OpenAPITools.Model
{
    /// <summary>
    /// FormatTest
    /// </summary>
    public partial class FormatTest : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="FormatTest" /> class.
        /// </summary>
        /// <param name="byte">byte</param>
        /// <param name="date">date</param>
        /// <param name="number">number</param>
        /// <param name="password">password</param>
        /// <param name="stringFormattedAsDecimalRequired">stringFormattedAsDecimalRequired</param>
        /// <param name="binary">binary</param>
        /// <param name="dateTime">dateTime</param>
        /// <param name="decimal">decimal</param>
        /// <param name="double">double</param>
        /// <param name="duplicatePropertyName2">duplicatePropertyName2</param>
        /// <param name="duplicatePropertyName">duplicatePropertyName</param>
        /// <param name="float">float</param>
        /// <param name="int32">int32</param>
        /// <param name="int32Range">int32Range</param>
        /// <param name="int64">int64</param>
        /// <param name="int64Negative">int64Negative</param>
        /// <param name="int64NegativeExclusive">int64NegativeExclusive</param>
        /// <param name="int64Positive">int64Positive</param>
        /// <param name="int64PositiveExclusive">int64PositiveExclusive</param>
        /// <param name="integer">integer</param>
        /// <param name="patternWithBackslash">None</param>
        /// <param name="patternWithDigits">A string that is a 10 digit number. Can have leading zeros.</param>
        /// <param name="patternWithDigitsAndDelimiter">A string starting with &#39;image_&#39; (case insensitive) and one to three digits following i.e. Image_01.</param>
        /// <param name="string">string</param>
        /// <param name="stringFormattedAsDecimal">stringFormattedAsDecimal</param>
        /// <param name="unsignedInteger">unsignedInteger</param>
        /// <param name="unsignedLong">unsignedLong</param>
        /// <param name="uuid">uuid</param>
        [JsonConstructor]
        public FormatTest(byte[] @byte, DateOnly date, decimal number, string password, decimal stringFormattedAsDecimalRequired, Option<System.IO.Stream> binary = default, Option<DateTime?> dateTime = default, Option<decimal?> @decimal = default, Option<double?> @double = default, Option<string> duplicatePropertyName2 = default, Option<string> duplicatePropertyName = default, Option<float?> @float = default, Option<int?> int32 = default, Option<int?> int32Range = default, Option<long?> int64 = default, Option<long?> int64Negative = default, Option<long?> int64NegativeExclusive = default, Option<long?> int64Positive = default, Option<long?> int64PositiveExclusive = default, Option<int?> integer = default, Option<string> patternWithBackslash = default, Option<string> patternWithDigits = default, Option<string> patternWithDigitsAndDelimiter = default, Option<string> @string = default, Option<decimal?> stringFormattedAsDecimal = default, Option<uint?> unsignedInteger = default, Option<ulong?> unsignedLong = default, Option<Guid?> uuid = default)
        {
            Byte = @byte;
            Date = date;
            Number = number;
            Password = password;
            StringFormattedAsDecimalRequired = stringFormattedAsDecimalRequired;
            BinaryOption = binary;
            DateTimeOption = dateTime;
            DecimalOption = @decimal;
            DoubleOption = @double;
            DuplicatePropertyName2Option = duplicatePropertyName2;
            DuplicatePropertyNameOption = duplicatePropertyName;
            FloatOption = @float;
            Int32Option = int32;
            Int32RangeOption = int32Range;
            Int64Option = int64;
            Int64NegativeOption = int64Negative;
            Int64NegativeExclusiveOption = int64NegativeExclusive;
            Int64PositiveOption = int64Positive;
            Int64PositiveExclusiveOption = int64PositiveExclusive;
            IntegerOption = integer;
            PatternWithBackslashOption = patternWithBackslash;
            PatternWithDigitsOption = patternWithDigits;
            PatternWithDigitsAndDelimiterOption = patternWithDigitsAndDelimiter;
            StringOption = @string;
            StringFormattedAsDecimalOption = stringFormattedAsDecimal;
            UnsignedIntegerOption = unsignedInteger;
            UnsignedLongOption = unsignedLong;
            UuidOption = uuid;
            OnCreated();
        }

        partial void OnCreated();

        /// <summary>
        /// Gets or Sets Byte
        /// </summary>
        [JsonPropertyName("byte")]
        public byte[] Byte { get; set; }

        /// <summary>
        /// Gets or Sets Date
        /// </summary>
        /* <example>Sun Feb 02 00:00:00 UTC 2020</example> */
        [JsonPropertyName("date")]
        public DateOnly Date { get; set; }

        /// <summary>
        /// Gets or Sets Number
        /// </summary>
        [JsonPropertyName("number")]
        public decimal Number { get; set; }

        /// <summary>
        /// Gets or Sets Password
        /// </summary>
        [JsonPropertyName("password")]
        public string Password { get; set; }

        /// <summary>
        /// Gets or Sets StringFormattedAsDecimalRequired
        /// </summary>
        [JsonPropertyName("string_formatted_as_decimal_required")]
        public decimal StringFormattedAsDecimalRequired { get; set; }

        /// <summary>
        /// Used to track the state of Binary
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<System.IO.Stream> BinaryOption { get; private set; }

        /// <summary>
        /// Gets or Sets Binary
        /// </summary>
        [JsonPropertyName("binary")]
        public System.IO.Stream Binary { get { return this.BinaryOption; } set { this.BinaryOption = new(value); } }

        /// <summary>
        /// Used to track the state of DateTime
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<DateTime?> DateTimeOption { get; private set; }

        /// <summary>
        /// Gets or Sets DateTime
        /// </summary>
        /* <example>2007-12-03T10:15:30+01:00</example> */
        [JsonPropertyName("dateTime")]
        public DateTime? DateTime { get { return this.DateTimeOption; } set { this.DateTimeOption = new(value); } }

        /// <summary>
        /// Used to track the state of Decimal
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<decimal?> DecimalOption { get; private set; }

        /// <summary>
        /// Gets or Sets Decimal
        /// </summary>
        [JsonPropertyName("decimal")]
        public decimal? Decimal { get { return this.DecimalOption; } set { this.DecimalOption = new(value); } }

        /// <summary>
        /// Used to track the state of Double
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<double?> DoubleOption { get; private set; }

        /// <summary>
        /// Gets or Sets Double
        /// </summary>
        [JsonPropertyName("double")]
        public double? Double { get { return this.DoubleOption; } set { this.DoubleOption = new(value); } }

        /// <summary>
        /// Used to track the state of DuplicatePropertyName2
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<string> DuplicatePropertyName2Option { get; private set; }

        /// <summary>
        /// Gets or Sets DuplicatePropertyName2
        /// </summary>
        [JsonPropertyName("duplicate_property_name")]
        public string DuplicatePropertyName2 { get { return this.DuplicatePropertyName2Option; } set { this.DuplicatePropertyName2Option = new(value); } }

        /// <summary>
        /// Used to track the state of DuplicatePropertyName
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<string> DuplicatePropertyNameOption { get; private set; }

        /// <summary>
        /// Gets or Sets DuplicatePropertyName
        /// </summary>
        [JsonPropertyName("@duplicate_property_name")]
        public string DuplicatePropertyName { get { return this.DuplicatePropertyNameOption; } set { this.DuplicatePropertyNameOption = new(value); } }

        /// <summary>
        /// Used to track the state of Float
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<float?> FloatOption { get; private set; }

        /// <summary>
        /// Gets or Sets Float
        /// </summary>
        [JsonPropertyName("float")]
        public float? Float { get { return this.FloatOption; } set { this.FloatOption = new(value); } }

        /// <summary>
        /// Used to track the state of Int32
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<int?> Int32Option { get; private set; }

        /// <summary>
        /// Gets or Sets Int32
        /// </summary>
        [JsonPropertyName("int32")]
        public int? Int32 { get { return this.Int32Option; } set { this.Int32Option = new(value); } }

        /// <summary>
        /// Used to track the state of Int32Range
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<int?> Int32RangeOption { get; private set; }

        /// <summary>
        /// Gets or Sets Int32Range
        /// </summary>
        [JsonPropertyName("int32Range")]
        public int? Int32Range { get { return this.Int32RangeOption; } set { this.Int32RangeOption = new(value); } }

        /// <summary>
        /// Used to track the state of Int64
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<long?> Int64Option { get; private set; }

        /// <summary>
        /// Gets or Sets Int64
        /// </summary>
        [JsonPropertyName("int64")]
        public long? Int64 { get { return this.Int64Option; } set { this.Int64Option = new(value); } }

        /// <summary>
        /// Used to track the state of Int64Negative
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<long?> Int64NegativeOption { get; private set; }

        /// <summary>
        /// Gets or Sets Int64Negative
        /// </summary>
        [JsonPropertyName("int64Negative")]
        public long? Int64Negative { get { return this.Int64NegativeOption; } set { this.Int64NegativeOption = new(value); } }

        /// <summary>
        /// Used to track the state of Int64NegativeExclusive
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<long?> Int64NegativeExclusiveOption { get; private set; }

        /// <summary>
        /// Gets or Sets Int64NegativeExclusive
        /// </summary>
        [JsonPropertyName("int64NegativeExclusive")]
        public long? Int64NegativeExclusive { get { return this.Int64NegativeExclusiveOption; } set { this.Int64NegativeExclusiveOption = new(value); } }

        /// <summary>
        /// Used to track the state of Int64Positive
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<long?> Int64PositiveOption { get; private set; }

        /// <summary>
        /// Gets or Sets Int64Positive
        /// </summary>
        [JsonPropertyName("int64Positive")]
        public long? Int64Positive { get { return this.Int64PositiveOption; } set { this.Int64PositiveOption = new(value); } }

        /// <summary>
        /// Used to track the state of Int64PositiveExclusive
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<long?> Int64PositiveExclusiveOption { get; private set; }

        /// <summary>
        /// Gets or Sets Int64PositiveExclusive
        /// </summary>
        [JsonPropertyName("int64PositiveExclusive")]
        public long? Int64PositiveExclusive { get { return this.Int64PositiveExclusiveOption; } set { this.Int64PositiveExclusiveOption = new(value); } }

        /// <summary>
        /// Used to track the state of Integer
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<int?> IntegerOption { get; private set; }

        /// <summary>
        /// Gets or Sets Integer
        /// </summary>
        [JsonPropertyName("integer")]
        public int? Integer { get { return this.IntegerOption; } set { this.IntegerOption = new(value); } }

        /// <summary>
        /// Used to track the state of PatternWithBackslash
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<string> PatternWithBackslashOption { get; private set; }

        /// <summary>
        /// None
        /// </summary>
        /// <value>None</value>
        [JsonPropertyName("pattern_with_backslash")]
        public string PatternWithBackslash { get { return this.PatternWithBackslashOption; } set { this.PatternWithBackslashOption = new(value); } }

        /// <summary>
        /// Used to track the state of PatternWithDigits
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<string> PatternWithDigitsOption { get; private set; }

        /// <summary>
        /// A string that is a 10 digit number. Can have leading zeros.
        /// </summary>
        /// <value>A string that is a 10 digit number. Can have leading zeros.</value>
        [JsonPropertyName("pattern_with_digits")]
        public string PatternWithDigits { get { return this.PatternWithDigitsOption; } set { this.PatternWithDigitsOption = new(value); } }

        /// <summary>
        /// Used to track the state of PatternWithDigitsAndDelimiter
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<string> PatternWithDigitsAndDelimiterOption { get; private set; }

        /// <summary>
        /// A string starting with &#39;image_&#39; (case insensitive) and one to three digits following i.e. Image_01.
        /// </summary>
        /// <value>A string starting with &#39;image_&#39; (case insensitive) and one to three digits following i.e. Image_01.</value>
        [JsonPropertyName("pattern_with_digits_and_delimiter")]
        public string PatternWithDigitsAndDelimiter { get { return this.PatternWithDigitsAndDelimiterOption; } set { this.PatternWithDigitsAndDelimiterOption = new(value); } }

        /// <summary>
        /// Used to track the state of String
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<string> StringOption { get; private set; }

        /// <summary>
        /// Gets or Sets String
        /// </summary>
        [JsonPropertyName("string")]
        public string String { get { return this.StringOption; } set { this.StringOption = new(value); } }

        /// <summary>
        /// Used to track the state of StringFormattedAsDecimal
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<decimal?> StringFormattedAsDecimalOption { get; private set; }

        /// <summary>
        /// Gets or Sets StringFormattedAsDecimal
        /// </summary>
        [JsonPropertyName("string_formatted_as_decimal")]
        public decimal? StringFormattedAsDecimal { get { return this.StringFormattedAsDecimalOption; } set { this.StringFormattedAsDecimalOption = new(value); } }

        /// <summary>
        /// Used to track the state of UnsignedInteger
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<uint?> UnsignedIntegerOption { get; private set; }

        /// <summary>
        /// Gets or Sets UnsignedInteger
        /// </summary>
        [JsonPropertyName("unsigned_integer")]
        public uint? UnsignedInteger { get { return this.UnsignedIntegerOption; } set { this.UnsignedIntegerOption = new(value); } }

        /// <summary>
        /// Used to track the state of UnsignedLong
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<ulong?> UnsignedLongOption { get; private set; }

        /// <summary>
        /// Gets or Sets UnsignedLong
        /// </summary>
        [JsonPropertyName("unsigned_long")]
        public ulong? UnsignedLong { get { return this.UnsignedLongOption; } set { this.UnsignedLongOption = new(value); } }

        /// <summary>
        /// Used to track the state of Uuid
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<Guid?> UuidOption { get; private set; }

        /// <summary>
        /// Gets or Sets Uuid
        /// </summary>
        /* <example>72f98069-206d-4f12-9f12-3d1e525a8e84</example> */
        [JsonPropertyName("uuid")]
        public Guid? Uuid { get { return this.UuidOption; } set { this.UuidOption = new(value); } }

        /// <summary>
        /// Gets or Sets additional properties
        /// </summary>
        [JsonExtensionData]
        public Dictionary<string, JsonElement> AdditionalProperties { get; } = new Dictionary<string, JsonElement>();

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class FormatTest {\n");
            sb.Append("  Byte: ").Append(Byte).Append("\n");
            sb.Append("  Date: ").Append(Date).Append("\n");
            sb.Append("  Number: ").Append(Number).Append("\n");
            sb.Append("  Password: ").Append(Password).Append("\n");
            sb.Append("  StringFormattedAsDecimalRequired: ").Append(StringFormattedAsDecimalRequired).Append("\n");
            sb.Append("  Binary: ").Append(Binary).Append("\n");
            sb.Append("  DateTime: ").Append(DateTime).Append("\n");
            sb.Append("  Decimal: ").Append(Decimal).Append("\n");
            sb.Append("  Double: ").Append(Double).Append("\n");
            sb.Append("  DuplicatePropertyName2: ").Append(DuplicatePropertyName2).Append("\n");
            sb.Append("  DuplicatePropertyName: ").Append(DuplicatePropertyName).Append("\n");
            sb.Append("  Float: ").Append(Float).Append("\n");
            sb.Append("  Int32: ").Append(Int32).Append("\n");
            sb.Append("  Int32Range: ").Append(Int32Range).Append("\n");
            sb.Append("  Int64: ").Append(Int64).Append("\n");
            sb.Append("  Int64Negative: ").Append(Int64Negative).Append("\n");
            sb.Append("  Int64NegativeExclusive: ").Append(Int64NegativeExclusive).Append("\n");
            sb.Append("  Int64Positive: ").Append(Int64Positive).Append("\n");
            sb.Append("  Int64PositiveExclusive: ").Append(Int64PositiveExclusive).Append("\n");
            sb.Append("  Integer: ").Append(Integer).Append("\n");
            sb.Append("  PatternWithBackslash: ").Append(PatternWithBackslash).Append("\n");
            sb.Append("  PatternWithDigits: ").Append(PatternWithDigits).Append("\n");
            sb.Append("  PatternWithDigitsAndDelimiter: ").Append(PatternWithDigitsAndDelimiter).Append("\n");
            sb.Append("  String: ").Append(String).Append("\n");
            sb.Append("  StringFormattedAsDecimal: ").Append(StringFormattedAsDecimal).Append("\n");
            sb.Append("  UnsignedInteger: ").Append(UnsignedInteger).Append("\n");
            sb.Append("  UnsignedLong: ").Append(UnsignedLong).Append("\n");
            sb.Append("  Uuid: ").Append(Uuid).Append("\n");
            sb.Append("  AdditionalProperties: ").Append(AdditionalProperties).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            // Number (decimal) maximum
            if (this.Number > (decimal)543.2)
            {
                yield return new ValidationResult("Invalid value for Number, must be a value less than or equal to 543.2.", new [] { "Number" });
            }

            // Number (decimal) minimum
            if (this.Number < (decimal)32.1)
            {
                yield return new ValidationResult("Invalid value for Number, must be a value greater than or equal to 32.1.", new [] { "Number" });
            }

            // Password (string) maxLength
            if (this.Password != null && this.Password.Length > 64)
            {
                yield return new ValidationResult("Invalid value for Password, length must be less than 64.", new [] { "Password" });
            }

            // Password (string) minLength
            if (this.Password != null && this.Password.Length < 10)
            {
                yield return new ValidationResult("Invalid value for Password, length must be greater than 10.", new [] { "Password" });
            }

            // Double (double) maximum
            if (this.DoubleOption.IsSet && this.DoubleOption.Value > (double)123.4)
            {
                yield return new ValidationResult("Invalid value for Double, must be a value less than or equal to 123.4.", new [] { "Double" });
            }

            // Double (double) minimum
            if (this.DoubleOption.IsSet && this.DoubleOption.Value < (double)67.8)
            {
                yield return new ValidationResult("Invalid value for Double, must be a value greater than or equal to 67.8.", new [] { "Double" });
            }

            // Float (float) maximum
            if (this.FloatOption.IsSet && this.FloatOption.Value > (float)987.6)
            {
                yield return new ValidationResult("Invalid value for Float, must be a value less than or equal to 987.6.", new [] { "Float" });
            }

            // Float (float) minimum
            if (this.FloatOption.IsSet && this.FloatOption.Value < (float)54.3)
            {
                yield return new ValidationResult("Invalid value for Float, must be a value greater than or equal to 54.3.", new [] { "Float" });
            }

            // Int32 (int) maximum
            if (this.Int32Option.IsSet && this.Int32Option.Value > (int)200)
            {
                yield return new ValidationResult("Invalid value for Int32, must be a value less than or equal to 200.", new [] { "Int32" });
            }

            // Int32 (int) minimum
            if (this.Int32Option.IsSet && this.Int32Option.Value < (int)20)
            {
                yield return new ValidationResult("Invalid value for Int32, must be a value greater than or equal to 20.", new [] { "Int32" });
            }

            // Int32Range (int) maximum
            if (this.Int32RangeOption.IsSet && this.Int32RangeOption.Value > (int)2147483647)
            {
                yield return new ValidationResult("Invalid value for Int32Range, must be a value less than or equal to 2147483647.", new [] { "Int32Range" });
            }

            // Int32Range (int) minimum
            if (this.Int32RangeOption.IsSet && this.Int32RangeOption.Value < (int)-2147483648)
            {
                yield return new ValidationResult("Invalid value for Int32Range, must be a value greater than or equal to -2147483648.", new [] { "Int32Range" });
            }

            // Int64Negative (long) maximum
            if (this.Int64NegativeOption.IsSet && this.Int64NegativeOption.Value > (long)-2147483649)
            {
                yield return new ValidationResult("Invalid value for Int64Negative, must be a value less than or equal to -2147483649.", new [] { "Int64Negative" });
            }

            // Int64NegativeExclusive (long) maximum
            if (this.Int64NegativeExclusiveOption.IsSet && this.Int64NegativeExclusiveOption.Value <= (long)-2147483648)
            {
                yield return new ValidationResult("Invalid value for Int64NegativeExclusive, must be a value less than -2147483648.", new [] { "Int64NegativeExclusive" });
            }

            // Int64Positive (long) minimum
            if (this.Int64PositiveOption.IsSet && this.Int64PositiveOption.Value < (long)2147483648)
            {
                yield return new ValidationResult("Invalid value for Int64Positive, must be a value greater than or equal to 2147483648.", new [] { "Int64Positive" });
            }

            // Int64PositiveExclusive (long) minimum
            if (this.Int64PositiveExclusiveOption.IsSet && this.Int64PositiveExclusiveOption.Value < (long)2147483647)
            {
                yield return new ValidationResult("Invalid value for Int64PositiveExclusive, must be a value greater than 2147483647.", new [] { "Int64PositiveExclusive" });
            }

            // Integer (int) maximum
            if (this.IntegerOption.IsSet && this.IntegerOption.Value > (int)100)
            {
                yield return new ValidationResult("Invalid value for Integer, must be a value less than or equal to 100.", new [] { "Integer" });
            }

            // Integer (int) minimum
            if (this.IntegerOption.IsSet && this.IntegerOption.Value < (int)10)
            {
                yield return new ValidationResult("Invalid value for Integer, must be a value greater than or equal to 10.", new [] { "Integer" });
            }

            if (this.PatternWithBackslashOption.Value != null) {
                // PatternWithBackslash (string) pattern
                Regex regexPatternWithBackslash = new Regex(@"^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\/([0-9]|[1-2][0-9]|3[0-2]))$", RegexOptions.CultureInvariant);

                if (this.PatternWithBackslashOption.Value != null &&!regexPatternWithBackslash.Match(this.PatternWithBackslashOption.Value).Success)
                {
                    yield return new System.ComponentModel.DataAnnotations.ValidationResult("Invalid value for PatternWithBackslash, must match a pattern of " + regexPatternWithBackslash, new [] { "PatternWithBackslash" });
                }
            }

            if (this.PatternWithDigitsOption.Value != null) {
                // PatternWithDigits (string) pattern
                Regex regexPatternWithDigits = new Regex(@"^\d{10}$", RegexOptions.CultureInvariant);

                if (this.PatternWithDigitsOption.Value != null &&!regexPatternWithDigits.Match(this.PatternWithDigitsOption.Value).Success)
                {
                    yield return new System.ComponentModel.DataAnnotations.ValidationResult("Invalid value for PatternWithDigits, must match a pattern of " + regexPatternWithDigits, new [] { "PatternWithDigits" });
                }
            }

            if (this.PatternWithDigitsAndDelimiterOption.Value != null) {
                // PatternWithDigitsAndDelimiter (string) pattern
                Regex regexPatternWithDigitsAndDelimiter = new Regex(@"^image_\d{1,3}$", RegexOptions.CultureInvariant | RegexOptions.IgnoreCase);

                if (this.PatternWithDigitsAndDelimiterOption.Value != null &&!regexPatternWithDigitsAndDelimiter.Match(this.PatternWithDigitsAndDelimiterOption.Value).Success)
                {
                    yield return new System.ComponentModel.DataAnnotations.ValidationResult("Invalid value for PatternWithDigitsAndDelimiter, must match a pattern of " + regexPatternWithDigitsAndDelimiter, new [] { "PatternWithDigitsAndDelimiter" });
                }
            }

            if (this.StringOption.Value != null) {
                // String (string) pattern
                Regex regexString = new Regex(@"[a-z]", RegexOptions.CultureInvariant | RegexOptions.IgnoreCase);

                if (this.StringOption.Value != null &&!regexString.Match(this.StringOption.Value).Success)
                {
                    yield return new System.ComponentModel.DataAnnotations.ValidationResult("Invalid value for String, must match a pattern of " + regexString, new [] { "String" });
                }
            }

            // UnsignedInteger (uint) maximum
            if (this.UnsignedIntegerOption.IsSet && this.UnsignedIntegerOption.Value > (uint)200)
            {
                yield return new ValidationResult("Invalid value for UnsignedInteger, must be a value less than or equal to 200.", new [] { "UnsignedInteger" });
            }

            // UnsignedInteger (uint) minimum
            if (this.UnsignedIntegerOption.IsSet && this.UnsignedIntegerOption.Value < (uint)20)
            {
                yield return new ValidationResult("Invalid value for UnsignedInteger, must be a value greater than or equal to 20.", new [] { "UnsignedInteger" });
            }

            yield break;
        }
    }

    /// <summary>
    /// A Json converter for type <see cref="FormatTest" />
    /// </summary>
    public class FormatTestJsonConverter : JsonConverter<FormatTest>
    {
        /// <summary>
        /// The format to use to serialize Date
        /// </summary>
        public static string DateFormat { get; set; } = "yyyy'-'MM'-'dd";

        /// <summary>
        /// The format to use to serialize DateTime
        /// </summary>
        public static string DateTimeFormat { get; set; } = "yyyy'-'MM'-'dd'T'HH':'mm':'ss'.'fffffffK";

        /// <summary>
        /// Deserializes json to <see cref="FormatTest" />
        /// </summary>
        /// <param name="utf8JsonReader"></param>
        /// <param name="typeToConvert"></param>
        /// <param name="jsonSerializerOptions"></param>
        /// <returns></returns>
        /// <exception cref="JsonException"></exception>
        public override FormatTest Read(ref Utf8JsonReader utf8JsonReader, Type typeToConvert, JsonSerializerOptions jsonSerializerOptions)
        {
            int currentDepth = utf8JsonReader.CurrentDepth;

            if (utf8JsonReader.TokenType != JsonTokenType.StartObject && utf8JsonReader.TokenType != JsonTokenType.StartArray)
                throw new JsonException();

            JsonTokenType startingTokenType = utf8JsonReader.TokenType;

            Option<byte[]> varByte = default;
            Option<DateOnly?> date = default;
            Option<decimal?> number = default;
            Option<string> password = default;
            Option<decimal?> stringFormattedAsDecimalRequired = default;
            Option<System.IO.Stream> binary = default;
            Option<DateTime?> dateTime = default;
            Option<decimal?> varDecimal = default;
            Option<double?> varDouble = default;
            Option<string> duplicatePropertyName2 = default;
            Option<string> duplicatePropertyName = default;
            Option<float?> varFloat = default;
            Option<int?> int32 = default;
            Option<int?> int32Range = default;
            Option<long?> int64 = default;
            Option<long?> int64Negative = default;
            Option<long?> int64NegativeExclusive = default;
            Option<long?> int64Positive = default;
            Option<long?> int64PositiveExclusive = default;
            Option<int?> integer = default;
            Option<string> patternWithBackslash = default;
            Option<string> patternWithDigits = default;
            Option<string> patternWithDigitsAndDelimiter = default;
            Option<string> varString = default;
            Option<decimal?> stringFormattedAsDecimal = default;
            Option<uint?> unsignedInteger = default;
            Option<ulong?> unsignedLong = default;
            Option<Guid?> uuid = default;

            while (utf8JsonReader.Read())
            {
                if (startingTokenType == JsonTokenType.StartObject && utf8JsonReader.TokenType == JsonTokenType.EndObject && currentDepth == utf8JsonReader.CurrentDepth)
                    break;

                if (startingTokenType == JsonTokenType.StartArray && utf8JsonReader.TokenType == JsonTokenType.EndArray && currentDepth == utf8JsonReader.CurrentDepth)
                    break;

                if (utf8JsonReader.TokenType == JsonTokenType.PropertyName && currentDepth == utf8JsonReader.CurrentDepth - 1)
                {
                    string localVarJsonPropertyName = utf8JsonReader.GetString();
                    utf8JsonReader.Read();

                    switch (localVarJsonPropertyName)
                    {
                        case "byte":
                            varByte = new Option<byte[]>(JsonSerializer.Deserialize<byte[]>(ref utf8JsonReader, jsonSerializerOptions));
                            break;
                        case "date":
                            date = new Option<DateOnly?>(JsonSerializer.Deserialize<DateOnly>(ref utf8JsonReader, jsonSerializerOptions));
                            break;
                        case "number":
                            number = new Option<decimal?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (decimal?)null : utf8JsonReader.GetDecimal());
                            break;
                        case "password":
                            password = new Option<string>(utf8JsonReader.GetString());
                            break;
                        case "string_formatted_as_decimal_required":
                            stringFormattedAsDecimalRequired = new Option<decimal?>(utf8JsonReader.GetDecimal());
                            break;
                        case "binary":
                            binary = new Option<System.IO.Stream>(JsonSerializer.Deserialize<System.IO.Stream>(ref utf8JsonReader, jsonSerializerOptions));
                            break;
                        case "dateTime":
                            dateTime = new Option<DateTime?>(JsonSerializer.Deserialize<DateTime>(ref utf8JsonReader, jsonSerializerOptions));
                            break;
                        case "decimal":
                            varDecimal = new Option<decimal?>(JsonSerializer.Deserialize<decimal>(ref utf8JsonReader, jsonSerializerOptions));
                            break;
                        case "double":
                            varDouble = new Option<double?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (double?)null : utf8JsonReader.GetDouble());
                            break;
                        case "duplicate_property_name":
                            duplicatePropertyName2 = new Option<string>(utf8JsonReader.GetString());
                            break;
                        case "@duplicate_property_name":
                            duplicatePropertyName = new Option<string>(utf8JsonReader.GetString());
                            break;
                        case "float":
                            varFloat = new Option<float?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (float?)null : (float)utf8JsonReader.GetDouble());
                            break;
                        case "int32":
                            int32 = new Option<int?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (int?)null : utf8JsonReader.GetInt32());
                            break;
                        case "int32Range":
                            int32Range = new Option<int?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (int?)null : utf8JsonReader.GetInt32());
                            break;
                        case "int64":
                            int64 = new Option<long?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (long?)null : utf8JsonReader.GetInt64());
                            break;
                        case "int64Negative":
                            int64Negative = new Option<long?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (int?)null : utf8JsonReader.GetInt32());
                            break;
                        case "int64NegativeExclusive":
                            int64NegativeExclusive = new Option<long?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (int?)null : utf8JsonReader.GetInt32());
                            break;
                        case "int64Positive":
                            int64Positive = new Option<long?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (int?)null : utf8JsonReader.GetInt32());
                            break;
                        case "int64PositiveExclusive":
                            int64PositiveExclusive = new Option<long?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (int?)null : utf8JsonReader.GetInt32());
                            break;
                        case "integer":
                            integer = new Option<int?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (int?)null : utf8JsonReader.GetInt32());
                            break;
                        case "pattern_with_backslash":
                            patternWithBackslash = new Option<string>(utf8JsonReader.GetString());
                            break;
                        case "pattern_with_digits":
                            patternWithDigits = new Option<string>(utf8JsonReader.GetString());
                            break;
                        case "pattern_with_digits_and_delimiter":
                            patternWithDigitsAndDelimiter = new Option<string>(utf8JsonReader.GetString());
                            break;
                        case "string":
                            varString = new Option<string>(utf8JsonReader.GetString());
                            break;
                        case "string_formatted_as_decimal":
                            stringFormattedAsDecimal = new Option<decimal?>(utf8JsonReader.GetDecimal());
                            break;
                        case "unsigned_integer":
                            unsignedInteger = new Option<uint?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (uint?)null : utf8JsonReader.GetUInt32());
                            break;
                        case "unsigned_long":
                            unsignedLong = new Option<ulong?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (ulong?)null : utf8JsonReader.GetUInt64());
                            break;
                        case "uuid":
                            uuid = new Option<Guid?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (Guid?)null : utf8JsonReader.GetGuid());
                            break;
                        default:
                            break;
                    }
                }
            }

            if (!varByte.IsSet)
                throw new ArgumentException("Property is required for class FormatTest.", nameof(varByte));

            if (!date.IsSet)
                throw new ArgumentException("Property is required for class FormatTest.", nameof(date));

            if (!number.IsSet)
                throw new ArgumentException("Property is required for class FormatTest.", nameof(number));

            if (!password.IsSet)
                throw new ArgumentException("Property is required for class FormatTest.", nameof(password));

            if (!stringFormattedAsDecimalRequired.IsSet)
                throw new ArgumentException("Property is required for class FormatTest.", nameof(stringFormattedAsDecimalRequired));

            if (varByte.IsSet && varByte.Value == null)
                throw new ArgumentNullException(nameof(varByte), "Property is not nullable for class FormatTest.");

            if (date.IsSet && date.Value == null)
                throw new ArgumentNullException(nameof(date), "Property is not nullable for class FormatTest.");

            if (number.IsSet && number.Value == null)
                throw new ArgumentNullException(nameof(number), "Property is not nullable for class FormatTest.");

            if (password.IsSet && password.Value == null)
                throw new ArgumentNullException(nameof(password), "Property is not nullable for class FormatTest.");

            if (stringFormattedAsDecimalRequired.IsSet && stringFormattedAsDecimalRequired.Value == null)
                throw new ArgumentNullException(nameof(stringFormattedAsDecimalRequired), "Property is not nullable for class FormatTest.");

            if (binary.IsSet && binary.Value == null)
                throw new ArgumentNullException(nameof(binary), "Property is not nullable for class FormatTest.");

            if (dateTime.IsSet && dateTime.Value == null)
                throw new ArgumentNullException(nameof(dateTime), "Property is not nullable for class FormatTest.");

            if (varDecimal.IsSet && varDecimal.Value == null)
                throw new ArgumentNullException(nameof(varDecimal), "Property is not nullable for class FormatTest.");

            if (varDouble.IsSet && varDouble.Value == null)
                throw new ArgumentNullException(nameof(varDouble), "Property is not nullable for class FormatTest.");

            if (duplicatePropertyName2.IsSet && duplicatePropertyName2.Value == null)
                throw new ArgumentNullException(nameof(duplicatePropertyName2), "Property is not nullable for class FormatTest.");

            if (duplicatePropertyName.IsSet && duplicatePropertyName.Value == null)
                throw new ArgumentNullException(nameof(duplicatePropertyName), "Property is not nullable for class FormatTest.");

            if (varFloat.IsSet && varFloat.Value == null)
                throw new ArgumentNullException(nameof(varFloat), "Property is not nullable for class FormatTest.");

            if (int32.IsSet && int32.Value == null)
                throw new ArgumentNullException(nameof(int32), "Property is not nullable for class FormatTest.");

            if (int32Range.IsSet && int32Range.Value == null)
                throw new ArgumentNullException(nameof(int32Range), "Property is not nullable for class FormatTest.");

            if (int64.IsSet && int64.Value == null)
                throw new ArgumentNullException(nameof(int64), "Property is not nullable for class FormatTest.");

            if (int64Negative.IsSet && int64Negative.Value == null)
                throw new ArgumentNullException(nameof(int64Negative), "Property is not nullable for class FormatTest.");

            if (int64NegativeExclusive.IsSet && int64NegativeExclusive.Value == null)
                throw new ArgumentNullException(nameof(int64NegativeExclusive), "Property is not nullable for class FormatTest.");

            if (int64Positive.IsSet && int64Positive.Value == null)
                throw new ArgumentNullException(nameof(int64Positive), "Property is not nullable for class FormatTest.");

            if (int64PositiveExclusive.IsSet && int64PositiveExclusive.Value == null)
                throw new ArgumentNullException(nameof(int64PositiveExclusive), "Property is not nullable for class FormatTest.");

            if (integer.IsSet && integer.Value == null)
                throw new ArgumentNullException(nameof(integer), "Property is not nullable for class FormatTest.");

            if (patternWithBackslash.IsSet && patternWithBackslash.Value == null)
                throw new ArgumentNullException(nameof(patternWithBackslash), "Property is not nullable for class FormatTest.");

            if (patternWithDigits.IsSet && patternWithDigits.Value == null)
                throw new ArgumentNullException(nameof(patternWithDigits), "Property is not nullable for class FormatTest.");

            if (patternWithDigitsAndDelimiter.IsSet && patternWithDigitsAndDelimiter.Value == null)
                throw new ArgumentNullException(nameof(patternWithDigitsAndDelimiter), "Property is not nullable for class FormatTest.");

            if (varString.IsSet && varString.Value == null)
                throw new ArgumentNullException(nameof(varString), "Property is not nullable for class FormatTest.");

            if (stringFormattedAsDecimal.IsSet && stringFormattedAsDecimal.Value == null)
                throw new ArgumentNullException(nameof(stringFormattedAsDecimal), "Property is not nullable for class FormatTest.");

            if (unsignedInteger.IsSet && unsignedInteger.Value == null)
                throw new ArgumentNullException(nameof(unsignedInteger), "Property is not nullable for class FormatTest.");

            if (unsignedLong.IsSet && unsignedLong.Value == null)
                throw new ArgumentNullException(nameof(unsignedLong), "Property is not nullable for class FormatTest.");

            if (uuid.IsSet && uuid.Value == null)
                throw new ArgumentNullException(nameof(uuid), "Property is not nullable for class FormatTest.");

            return new FormatTest(varByte.Value, date.Value.Value, number.Value.Value, password.Value, stringFormattedAsDecimalRequired.Value.Value, binary, dateTime, varDecimal, varDouble, duplicatePropertyName2, duplicatePropertyName, varFloat, int32, int32Range, int64, int64Negative, int64NegativeExclusive, int64Positive, int64PositiveExclusive, integer, patternWithBackslash, patternWithDigits, patternWithDigitsAndDelimiter, varString, stringFormattedAsDecimal, unsignedInteger, unsignedLong, uuid);
        }

        /// <summary>
        /// Serializes a <see cref="FormatTest" />
        /// </summary>
        /// <param name="writer"></param>
        /// <param name="formatTest"></param>
        /// <param name="jsonSerializerOptions"></param>
        /// <exception cref="NotImplementedException"></exception>
        public override void Write(Utf8JsonWriter writer, FormatTest formatTest, JsonSerializerOptions jsonSerializerOptions)
        {
            writer.WriteStartObject();

            WriteProperties(writer, formatTest, jsonSerializerOptions);
            writer.WriteEndObject();
        }

        /// <summary>
        /// Serializes the properties of <see cref="FormatTest" />
        /// </summary>
        /// <param name="writer"></param>
        /// <param name="formatTest"></param>
        /// <param name="jsonSerializerOptions"></param>
        /// <exception cref="NotImplementedException"></exception>
        public void WriteProperties(Utf8JsonWriter writer, FormatTest formatTest, JsonSerializerOptions jsonSerializerOptions)
        {
            if (formatTest.Byte == null)
                throw new ArgumentNullException(nameof(formatTest.Byte), "Property is required for class FormatTest.");

            if (formatTest.Password == null)
                throw new ArgumentNullException(nameof(formatTest.Password), "Property is required for class FormatTest.");

            if (formatTest.BinaryOption.IsSet && formatTest.Binary == null)
                throw new ArgumentNullException(nameof(formatTest.Binary), "Property is required for class FormatTest.");

            if (formatTest.DuplicatePropertyName2Option.IsSet && formatTest.DuplicatePropertyName2 == null)
                throw new ArgumentNullException(nameof(formatTest.DuplicatePropertyName2), "Property is required for class FormatTest.");

            if (formatTest.DuplicatePropertyNameOption.IsSet && formatTest.DuplicatePropertyName == null)
                throw new ArgumentNullException(nameof(formatTest.DuplicatePropertyName), "Property is required for class FormatTest.");

            if (formatTest.PatternWithBackslashOption.IsSet && formatTest.PatternWithBackslash == null)
                throw new ArgumentNullException(nameof(formatTest.PatternWithBackslash), "Property is required for class FormatTest.");

            if (formatTest.PatternWithDigitsOption.IsSet && formatTest.PatternWithDigits == null)
                throw new ArgumentNullException(nameof(formatTest.PatternWithDigits), "Property is required for class FormatTest.");

            if (formatTest.PatternWithDigitsAndDelimiterOption.IsSet && formatTest.PatternWithDigitsAndDelimiter == null)
                throw new ArgumentNullException(nameof(formatTest.PatternWithDigitsAndDelimiter), "Property is required for class FormatTest.");

            if (formatTest.StringOption.IsSet && formatTest.String == null)
                throw new ArgumentNullException(nameof(formatTest.String), "Property is required for class FormatTest.");

            writer.WritePropertyName("byte");
            JsonSerializer.Serialize(writer, formatTest.Byte, jsonSerializerOptions);
            writer.WriteString("date", formatTest.Date.ToString(DateFormat));

            writer.WriteNumber("number", formatTest.Number);

            writer.WriteString("password", formatTest.Password);

            writer.WriteString("string_formatted_as_decimal_required", formatTest.StringFormattedAsDecimalRequired.ToString());

            if (formatTest.BinaryOption.IsSet)
            {
                writer.WritePropertyName("binary");
                JsonSerializer.Serialize(writer, formatTest.Binary, jsonSerializerOptions);
            }
            if (formatTest.DateTimeOption.IsSet)
                writer.WriteString("dateTime", formatTest.DateTimeOption.Value.Value.ToString(DateTimeFormat));

            if (formatTest.DecimalOption.IsSet)
            {
                writer.WritePropertyName("decimal");
                JsonSerializer.Serialize(writer, formatTest.Decimal, jsonSerializerOptions);
            }
            if (formatTest.DoubleOption.IsSet)
                writer.WriteNumber("double", formatTest.DoubleOption.Value.Value);

            if (formatTest.DuplicatePropertyName2Option.IsSet)
                writer.WriteString("duplicate_property_name", formatTest.DuplicatePropertyName2);

            if (formatTest.DuplicatePropertyNameOption.IsSet)
                writer.WriteString("@duplicate_property_name", formatTest.DuplicatePropertyName);

            if (formatTest.FloatOption.IsSet)
                writer.WriteNumber("float", formatTest.FloatOption.Value.Value);

            if (formatTest.Int32Option.IsSet)
                writer.WriteNumber("int32", formatTest.Int32Option.Value.Value);

            if (formatTest.Int32RangeOption.IsSet)
                writer.WriteNumber("int32Range", formatTest.Int32RangeOption.Value.Value);

            if (formatTest.Int64Option.IsSet)
                writer.WriteNumber("int64", formatTest.Int64Option.Value.Value);

            if (formatTest.Int64NegativeOption.IsSet)
                writer.WriteNumber("int64Negative", formatTest.Int64NegativeOption.Value.Value);

            if (formatTest.Int64NegativeExclusiveOption.IsSet)
                writer.WriteNumber("int64NegativeExclusive", formatTest.Int64NegativeExclusiveOption.Value.Value);

            if (formatTest.Int64PositiveOption.IsSet)
                writer.WriteNumber("int64Positive", formatTest.Int64PositiveOption.Value.Value);

            if (formatTest.Int64PositiveExclusiveOption.IsSet)
                writer.WriteNumber("int64PositiveExclusive", formatTest.Int64PositiveExclusiveOption.Value.Value);

            if (formatTest.IntegerOption.IsSet)
                writer.WriteNumber("integer", formatTest.IntegerOption.Value.Value);

            if (formatTest.PatternWithBackslashOption.IsSet)
                writer.WriteString("pattern_with_backslash", formatTest.PatternWithBackslash);

            if (formatTest.PatternWithDigitsOption.IsSet)
                writer.WriteString("pattern_with_digits", formatTest.PatternWithDigits);

            if (formatTest.PatternWithDigitsAndDelimiterOption.IsSet)
                writer.WriteString("pattern_with_digits_and_delimiter", formatTest.PatternWithDigitsAndDelimiter);

            if (formatTest.StringOption.IsSet)
                writer.WriteString("string", formatTest.String);

            if (formatTest.StringFormattedAsDecimalOption.IsSet)
                writer.WriteString("string_formatted_as_decimal", formatTest.StringFormattedAsDecimal.ToString());

            if (formatTest.UnsignedIntegerOption.IsSet)
                writer.WriteNumber("unsigned_integer", formatTest.UnsignedIntegerOption.Value.Value);

            if (formatTest.UnsignedLongOption.IsSet)
                writer.WriteNumber("unsigned_long", formatTest.UnsignedLongOption.Value.Value);

            if (formatTest.UuidOption.IsSet)
                writer.WriteString("uuid", formatTest.UuidOption.Value.Value);
        }
    }
}
