// <auto-generated>
/*
 * OpenAPI Petstore
 *
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Text.Json;
using System.Text.Json.Serialization;
using System.ComponentModel.DataAnnotations;
using OpenAPIClientUtils = Org.OpenAPITools.Client.ClientUtils;
using Org.OpenAPITools.Client;

namespace Org.OpenAPITools.Model
{
    /// <summary>
    /// MapTest
    /// </summary>
    public partial class MapTest : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="MapTest" /> class.
        /// </summary>
        /// <param name="directMap">directMap</param>
        /// <param name="indirectMap">indirectMap</param>
        /// <param name="mapMapOfString">mapMapOfString</param>
        /// <param name="mapOfEnumString">mapOfEnumString</param>
        [JsonConstructor]
        public MapTest(Option<Dictionary<string, bool>> directMap = default, Option<Dictionary<string, bool>> indirectMap = default, Option<Dictionary<string, Dictionary<string, string>>> mapMapOfString = default, Option<Dictionary<string, MapTestMapOfEnumStringValue>> mapOfEnumString = default)
        {
            DirectMapOption = directMap;
            IndirectMapOption = indirectMap;
            MapMapOfStringOption = mapMapOfString;
            MapOfEnumStringOption = mapOfEnumString;
            OnCreated();
        }

        partial void OnCreated();

        /// <summary>
        /// Used to track the state of DirectMap
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<Dictionary<string, bool>> DirectMapOption { get; private set; }

        /// <summary>
        /// Gets or Sets DirectMap
        /// </summary>
        [JsonPropertyName("direct_map")]
        public Dictionary<string, bool> DirectMap { get { return this.DirectMapOption; } set { this.DirectMapOption = new Option<Dictionary<string, bool>>(value); } }

        /// <summary>
        /// Used to track the state of IndirectMap
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<Dictionary<string, bool>> IndirectMapOption { get; private set; }

        /// <summary>
        /// Gets or Sets IndirectMap
        /// </summary>
        [JsonPropertyName("indirect_map")]
        public Dictionary<string, bool> IndirectMap { get { return this.IndirectMapOption; } set { this.IndirectMapOption = new Option<Dictionary<string, bool>>(value); } }

        /// <summary>
        /// Used to track the state of MapMapOfString
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<Dictionary<string, Dictionary<string, string>>> MapMapOfStringOption { get; private set; }

        /// <summary>
        /// Gets or Sets MapMapOfString
        /// </summary>
        [JsonPropertyName("map_map_of_string")]
        public Dictionary<string, Dictionary<string, string>> MapMapOfString { get { return this.MapMapOfStringOption; } set { this.MapMapOfStringOption = new Option<Dictionary<string, Dictionary<string, string>>>(value); } }

        /// <summary>
        /// Used to track the state of MapOfEnumString
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<Dictionary<string, MapTestMapOfEnumStringValue>> MapOfEnumStringOption { get; private set; }

        /// <summary>
        /// Gets or Sets MapOfEnumString
        /// </summary>
        [JsonPropertyName("map_of_enum_string")]
        public Dictionary<string, MapTestMapOfEnumStringValue> MapOfEnumString { get { return this.MapOfEnumStringOption; } set { this.MapOfEnumStringOption = new Option<Dictionary<string, MapTestMapOfEnumStringValue>>(value); } }

        /// <summary>
        /// Gets or Sets additional properties
        /// </summary>
        [JsonExtensionData]
        public Dictionary<string, JsonElement> AdditionalProperties { get; } = new Dictionary<string, JsonElement>();

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class MapTest {\n");
            sb.Append("  DirectMap: ").Append(DirectMap).Append("\n");
            sb.Append("  IndirectMap: ").Append(IndirectMap).Append("\n");
            sb.Append("  MapMapOfString: ").Append(MapMapOfString).Append("\n");
            sb.Append("  MapOfEnumString: ").Append(MapOfEnumString).Append("\n");
            sb.Append("  AdditionalProperties: ").Append(AdditionalProperties).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }

    /// <summary>
    /// A Json converter for type <see cref="MapTest" />
    /// </summary>
    public class MapTestJsonConverter : JsonConverter<MapTest>
    {
        /// <summary>
        /// Deserializes json to <see cref="MapTest" />
        /// </summary>
        /// <param name="utf8JsonReader"></param>
        /// <param name="typeToConvert"></param>
        /// <param name="jsonSerializerOptions"></param>
        /// <returns></returns>
        /// <exception cref="JsonException"></exception>
        public override MapTest Read(ref Utf8JsonReader utf8JsonReader, Type typeToConvert, JsonSerializerOptions jsonSerializerOptions)
        {
            int currentDepth = utf8JsonReader.CurrentDepth;

            if (utf8JsonReader.TokenType != JsonTokenType.StartObject && utf8JsonReader.TokenType != JsonTokenType.StartArray)
                throw new JsonException();

            JsonTokenType startingTokenType = utf8JsonReader.TokenType;

            Option<Dictionary<string, bool>> directMap = default;
            Option<Dictionary<string, bool>> indirectMap = default;
            Option<Dictionary<string, Dictionary<string, string>>> mapMapOfString = default;
            Option<Dictionary<string, MapTestMapOfEnumStringValue>> mapOfEnumString = default;

            while (utf8JsonReader.Read())
            {
                if (startingTokenType == JsonTokenType.StartObject && utf8JsonReader.TokenType == JsonTokenType.EndObject && currentDepth == utf8JsonReader.CurrentDepth)
                    break;

                if (startingTokenType == JsonTokenType.StartArray && utf8JsonReader.TokenType == JsonTokenType.EndArray && currentDepth == utf8JsonReader.CurrentDepth)
                    break;

                if (utf8JsonReader.TokenType == JsonTokenType.PropertyName && currentDepth == utf8JsonReader.CurrentDepth - 1)
                {
                    string localVarJsonPropertyName = utf8JsonReader.GetString();
                    utf8JsonReader.Read();

                    switch (localVarJsonPropertyName)
                    {
                        case "direct_map":
                            directMap = new Option<Dictionary<string, bool>>(JsonSerializer.Deserialize<Dictionary<string, bool>>(ref utf8JsonReader, jsonSerializerOptions));
                            break;
                        case "indirect_map":
                            indirectMap = new Option<Dictionary<string, bool>>(JsonSerializer.Deserialize<Dictionary<string, bool>>(ref utf8JsonReader, jsonSerializerOptions));
                            break;
                        case "map_map_of_string":
                            mapMapOfString = new Option<Dictionary<string, Dictionary<string, string>>>(JsonSerializer.Deserialize<Dictionary<string, Dictionary<string, string>>>(ref utf8JsonReader, jsonSerializerOptions));
                            break;
                        case "map_of_enum_string":
                            mapOfEnumString = new Option<Dictionary<string, MapTestMapOfEnumStringValue>>(JsonSerializer.Deserialize<Dictionary<string, MapTestMapOfEnumStringValue>>(ref utf8JsonReader, jsonSerializerOptions));
                            break;
                        default:
                            break;
                    }
                }
            }

            if (directMap.IsSet && directMap.Value == null)
                throw new ArgumentNullException(nameof(directMap), "Property is not nullable for class MapTest.");

            if (indirectMap.IsSet && indirectMap.Value == null)
                throw new ArgumentNullException(nameof(indirectMap), "Property is not nullable for class MapTest.");

            if (mapMapOfString.IsSet && mapMapOfString.Value == null)
                throw new ArgumentNullException(nameof(mapMapOfString), "Property is not nullable for class MapTest.");

            if (mapOfEnumString.IsSet && mapOfEnumString.Value == null)
                throw new ArgumentNullException(nameof(mapOfEnumString), "Property is not nullable for class MapTest.");

            return new MapTest(directMap, indirectMap, mapMapOfString, mapOfEnumString);
        }

        /// <summary>
        /// Serializes a <see cref="MapTest" />
        /// </summary>
        /// <param name="writer"></param>
        /// <param name="mapTest"></param>
        /// <param name="jsonSerializerOptions"></param>
        /// <exception cref="NotImplementedException"></exception>
        public override void Write(Utf8JsonWriter writer, MapTest mapTest, JsonSerializerOptions jsonSerializerOptions)
        {
            writer.WriteStartObject();

            WriteProperties(writer, mapTest, jsonSerializerOptions);
            writer.WriteEndObject();
        }

        /// <summary>
        /// Serializes the properties of <see cref="MapTest" />
        /// </summary>
        /// <param name="writer"></param>
        /// <param name="mapTest"></param>
        /// <param name="jsonSerializerOptions"></param>
        /// <exception cref="NotImplementedException"></exception>
        public void WriteProperties(Utf8JsonWriter writer, MapTest mapTest, JsonSerializerOptions jsonSerializerOptions)
        {
            if (mapTest.DirectMapOption.IsSet && mapTest.DirectMap == null)
                throw new ArgumentNullException(nameof(mapTest.DirectMap), "Property is required for class MapTest.");

            if (mapTest.IndirectMapOption.IsSet && mapTest.IndirectMap == null)
                throw new ArgumentNullException(nameof(mapTest.IndirectMap), "Property is required for class MapTest.");

            if (mapTest.MapMapOfStringOption.IsSet && mapTest.MapMapOfString == null)
                throw new ArgumentNullException(nameof(mapTest.MapMapOfString), "Property is required for class MapTest.");

            if (mapTest.MapOfEnumStringOption.IsSet && mapTest.MapOfEnumString == null)
                throw new ArgumentNullException(nameof(mapTest.MapOfEnumString), "Property is required for class MapTest.");

            if (mapTest.DirectMapOption.IsSet)
            {
                writer.WritePropertyName("direct_map");
                JsonSerializer.Serialize(writer, mapTest.DirectMap, jsonSerializerOptions);
            }
            if (mapTest.IndirectMapOption.IsSet)
            {
                writer.WritePropertyName("indirect_map");
                JsonSerializer.Serialize(writer, mapTest.IndirectMap, jsonSerializerOptions);
            }
            if (mapTest.MapMapOfStringOption.IsSet)
            {
                writer.WritePropertyName("map_map_of_string");
                JsonSerializer.Serialize(writer, mapTest.MapMapOfString, jsonSerializerOptions);
            }
            if (mapTest.MapOfEnumStringOption.IsSet)
            {
                writer.WritePropertyName("map_of_enum_string");
                JsonSerializer.Serialize(writer, mapTest.MapOfEnumString, jsonSerializerOptions);
            }
        }
    }
}
