/*
 * Files.com API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 0.0.1
 * Contact: support@files.com
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

using System;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.DependencyInjection;
using System.Collections.Generic;
using System.Security.Cryptography;
using Org.OpenAPITools.Client;
using Org.OpenAPITools.Api;
using Org.OpenAPITools.Extensions;
using Xunit;

namespace Org.OpenAPITools.Test.Api
{
    /// <summary>
    ///  Tests the dependency injection.
    /// </summary>
    public class DependencyInjectionTest
    {
        private readonly IHost _hostUsingConfigureWithoutAClient =
            Host.CreateDefaultBuilder([]).ConfigureApi((context, services, options) =>
            {
                ApiKeyToken apiKeyToken1 = new("<token>", ClientUtils.ApiKeyHeader.XFilesAPIKey, timeout: TimeSpan.FromSeconds(1));
                options.AddTokens(apiKeyToken1);
            })
            .Build();

        private readonly IHost _hostUsingConfigureWithAClient =
            Host.CreateDefaultBuilder([]).ConfigureApi((context, services, options) =>
            {
                ApiKeyToken apiKeyToken1 = new("<token>", ClientUtils.ApiKeyHeader.XFilesAPIKey, timeout: TimeSpan.FromSeconds(1));
                options.AddTokens(apiKeyToken1);
                options.AddApiHttpClients(client => client.BaseAddress = new Uri(ClientUtils.BASE_ADDRESS));
            })
            .Build();

        private readonly IHost _hostUsingAddWithoutAClient =
            Host.CreateDefaultBuilder([]).ConfigureServices((host, services) =>
            {
                services.AddApi(options =>
                {
                    ApiKeyToken apiKeyToken1 = new("<token>", ClientUtils.ApiKeyHeader.XFilesAPIKey, timeout: TimeSpan.FromSeconds(1));
                    options.AddTokens(apiKeyToken1);
                });
            })
            .Build();

        private readonly IHost _hostUsingAddWithAClient =
            Host.CreateDefaultBuilder([]).ConfigureServices((host, services) =>
            {
                services.AddApi(options =>
                {
                    ApiKeyToken apiKeyToken1 = new("<token>", ClientUtils.ApiKeyHeader.XFilesAPIKey, timeout: TimeSpan.FromSeconds(1));
                    options.AddTokens(apiKeyToken1);
                    options.AddApiHttpClients(client => client.BaseAddress = new Uri(ClientUtils.BASE_ADDRESS));
                });
            })
            .Build();

        /// <summary>
        /// Test dependency injection when using the configure method
        /// </summary>
        [Fact]
        public void ConfigureApiWithAClientTest()
        {
            var aPIKEYSApi = _hostUsingConfigureWithAClient.Services.GetRequiredService<IAPIKEYSApi>();
            Assert.True(aPIKEYSApi.HttpClient.BaseAddress != null);

            var aPIKeysApi = _hostUsingConfigureWithAClient.Services.GetRequiredService<IAPIKeysApi>();
            Assert.True(aPIKeysApi.HttpClient.BaseAddress != null);

            var apiKeysApi = _hostUsingConfigureWithAClient.Services.GetRequiredService<IApiKeysApi>();
            Assert.True(apiKeysApi.HttpClient.BaseAddress != null);
        }

        /// <summary>
        /// Test dependency injection when using the configure method
        /// </summary>
        [Fact]
        public void ConfigureApiWithoutAClientTest()
        {
            var aPIKEYSApi = _hostUsingConfigureWithoutAClient.Services.GetRequiredService<IAPIKEYSApi>();
            Assert.True(aPIKEYSApi.HttpClient.BaseAddress != null);

            var aPIKeysApi = _hostUsingConfigureWithoutAClient.Services.GetRequiredService<IAPIKeysApi>();
            Assert.True(aPIKeysApi.HttpClient.BaseAddress != null);

            var apiKeysApi = _hostUsingConfigureWithoutAClient.Services.GetRequiredService<IApiKeysApi>();
            Assert.True(apiKeysApi.HttpClient.BaseAddress != null);
        }

        /// <summary>
        /// Test dependency injection when using the add method
        /// </summary>
        [Fact]
        public void AddApiWithAClientTest()
        {
            var aPIKEYSApi = _hostUsingAddWithAClient.Services.GetRequiredService<IAPIKEYSApi>();
            Assert.True(aPIKEYSApi.HttpClient.BaseAddress != null);
            
            var aPIKeysApi = _hostUsingAddWithAClient.Services.GetRequiredService<IAPIKeysApi>();
            Assert.True(aPIKeysApi.HttpClient.BaseAddress != null);
            
            var apiKeysApi = _hostUsingAddWithAClient.Services.GetRequiredService<IApiKeysApi>();
            Assert.True(apiKeysApi.HttpClient.BaseAddress != null);
        }

        /// <summary>
        /// Test dependency injection when using the add method
        /// </summary>
        [Fact]
        public void AddApiWithoutAClientTest()
        {
            var aPIKEYSApi = _hostUsingAddWithoutAClient.Services.GetRequiredService<IAPIKEYSApi>();
            Assert.True(aPIKEYSApi.HttpClient.BaseAddress != null);

            var aPIKeysApi = _hostUsingAddWithoutAClient.Services.GetRequiredService<IAPIKeysApi>();
            Assert.True(aPIKeysApi.HttpClient.BaseAddress != null);

            var apiKeysApi = _hostUsingAddWithoutAClient.Services.GetRequiredService<IApiKeysApi>();
            Assert.True(apiKeysApi.HttpClient.BaseAddress != null);
        }
    }
}
