// <auto-generated>
/*
 * Minimal reproduction for csharp webhook bug
 *
 * This is an example API to reproduce a bug with webhooks in csharp codegen
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

#nullable enable

using System;
using System.Collections.Generic;
using System.Net;
using System.Threading.Tasks;
using Microsoft.Extensions.Logging;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Text.Json;
using Org.OpenAPITools.Client;
using Org.OpenAPITools.Model;
using System.Diagnostics.CodeAnalysis;

namespace Org.OpenAPITools.Api
{
    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// This class is registered as transient.
    /// </summary>
    public interface IDefaultApi : IApi
    {
        /// <summary>
        /// The class containing the events
        /// </summary>
        DefaultApiEvents Events { get; }

        /// <summary>
        /// Example webhook
        /// </summary>
        /// <remarks>
        /// Send when an example is needed
        /// </remarks>
        /// <exception cref="ApiException">Thrown when fails to make API call</exception>
        /// <param name="helloWorldPostRequest">Contains the details of the hello world webhook (optional)</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns><see cref="Task"/>&lt;<see cref="IHelloWorldPostApiResponse"/>&gt;</returns>
        Task<IHelloWorldPostApiResponse> HelloWorldPostAsync(Option<HelloWorldPostRequest> helloWorldPostRequest = default, System.Threading.CancellationToken cancellationToken = default);

        /// <summary>
        /// Example webhook
        /// </summary>
        /// <remarks>
        /// Send when an example is needed
        /// </remarks>
        /// <param name="helloWorldPostRequest">Contains the details of the hello world webhook (optional)</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns><see cref="Task"/>&lt;<see cref="IHelloWorldPostApiResponse"/>?&gt;</returns>
        Task<IHelloWorldPostApiResponse?> HelloWorldPostOrDefaultAsync(Option<HelloWorldPostRequest> helloWorldPostRequest = default, System.Threading.CancellationToken cancellationToken = default);
    }

    /// <summary>
    /// The <see cref="IHelloWorldPostApiResponse"/>
    /// </summary>
    public interface IHelloWorldPostApiResponse : Org.OpenAPITools.Client.IApiResponse
    {
        /// <summary>
        /// Returns true if the response is 204 NoContent
        /// </summary>
        /// <returns></returns>
        bool IsNoContent { get; }

        /// <summary>
        /// Returns true if the response is 500 InternalServerError
        /// </summary>
        /// <returns></returns>
        bool IsInternalServerError { get; }
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public class DefaultApiEvents
    {
        /// <summary>
        /// The event raised after the server response
        /// </summary>
        public event EventHandler<ApiResponseEventArgs>? OnHelloWorldPost;

        /// <summary>
        /// The event raised after an error querying the server
        /// </summary>
        public event EventHandler<ExceptionEventArgs>? OnErrorHelloWorldPost;

        internal void ExecuteOnHelloWorldPost(DefaultApi.HelloWorldPostApiResponse apiResponse)
        {
            OnHelloWorldPost?.Invoke(this, new ApiResponseEventArgs(apiResponse));
        }

        internal void ExecuteOnErrorHelloWorldPost(Exception exception)
        {
            OnErrorHelloWorldPost?.Invoke(this, new ExceptionEventArgs(exception));
        }
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public sealed partial class DefaultApi : IDefaultApi
    {
        private JsonSerializerOptions _jsonSerializerOptions;

        /// <summary>
        /// The logger factory
        /// </summary>
        public ILoggerFactory LoggerFactory { get; }

        /// <summary>
        /// The logger
        /// </summary>
        public ILogger<DefaultApi> Logger { get; }

        /// <summary>
        /// The HttpClient
        /// </summary>
        public HttpClient HttpClient { get; }

        /// <summary>
        /// The class containing the events
        /// </summary>
        public DefaultApiEvents Events { get; }

        /// <summary>
        /// Initializes a new instance of the <see cref="DefaultApi"/> class.
        /// </summary>
        /// <returns></returns>
        public DefaultApi(ILogger<DefaultApi> logger, ILoggerFactory loggerFactory, HttpClient httpClient, JsonSerializerOptionsProvider jsonSerializerOptionsProvider, DefaultApiEvents defaultApiEvents)
        {
            _jsonSerializerOptions = jsonSerializerOptionsProvider.Options;
            LoggerFactory = loggerFactory;
            Logger = LoggerFactory.CreateLogger<DefaultApi>();
            HttpClient = httpClient;
            Events = defaultApiEvents;
        }

        partial void FormatHelloWorldPost(Option<HelloWorldPostRequest> helloWorldPostRequest);

        /// <summary>
        /// Validates the request parameters
        /// </summary>
        /// <param name="helloWorldPostRequest"></param>
        /// <returns></returns>
        private void ValidateHelloWorldPost(Option<HelloWorldPostRequest> helloWorldPostRequest)
        {
            if (helloWorldPostRequest.IsSet && helloWorldPostRequest.Value == null)
                throw new ArgumentNullException(nameof(helloWorldPostRequest));
        }

        /// <summary>
        /// Processes the server response
        /// </summary>
        /// <param name="apiResponseLocalVar"></param>
        /// <param name="helloWorldPostRequest"></param>
        private void AfterHelloWorldPostDefaultImplementation(IHelloWorldPostApiResponse apiResponseLocalVar, Option<HelloWorldPostRequest> helloWorldPostRequest)
        {
            bool suppressDefaultLog = false;
            AfterHelloWorldPost(ref suppressDefaultLog, apiResponseLocalVar, helloWorldPostRequest);
            if (!suppressDefaultLog)
                Logger.LogInformation("{0,-9} | {1} | {2}", (apiResponseLocalVar.DownloadedAt - apiResponseLocalVar.RequestedAt).TotalSeconds, apiResponseLocalVar.StatusCode, apiResponseLocalVar.Path);
        }

        /// <summary>
        /// Processes the server response
        /// </summary>
        /// <param name="suppressDefaultLog"></param>
        /// <param name="apiResponseLocalVar"></param>
        /// <param name="helloWorldPostRequest"></param>
        partial void AfterHelloWorldPost(ref bool suppressDefaultLog, IHelloWorldPostApiResponse apiResponseLocalVar, Option<HelloWorldPostRequest> helloWorldPostRequest);

        /// <summary>
        /// Logs exceptions that occur while retrieving the server response
        /// </summary>
        /// <param name="exceptionLocalVar"></param>
        /// <param name="pathFormatLocalVar"></param>
        /// <param name="pathLocalVar"></param>
        /// <param name="helloWorldPostRequest"></param>
        private void OnErrorHelloWorldPostDefaultImplementation(Exception exceptionLocalVar, string pathFormatLocalVar, string pathLocalVar, Option<HelloWorldPostRequest> helloWorldPostRequest)
        {
            bool suppressDefaultLogLocalVar = false;
            OnErrorHelloWorldPost(ref suppressDefaultLogLocalVar, exceptionLocalVar, pathFormatLocalVar, pathLocalVar, helloWorldPostRequest);
            if (!suppressDefaultLogLocalVar)
                Logger.LogError(exceptionLocalVar, "An error occurred while sending the request to the server.");
        }

        /// <summary>
        /// A partial method that gives developers a way to provide customized exception handling
        /// </summary>
        /// <param name="suppressDefaultLogLocalVar"></param>
        /// <param name="exceptionLocalVar"></param>
        /// <param name="pathFormatLocalVar"></param>
        /// <param name="pathLocalVar"></param>
        /// <param name="helloWorldPostRequest"></param>
        partial void OnErrorHelloWorldPost(ref bool suppressDefaultLogLocalVar, Exception exceptionLocalVar, string pathFormatLocalVar, string pathLocalVar, Option<HelloWorldPostRequest> helloWorldPostRequest);

        /// <summary>
        /// Example webhook Send when an example is needed
        /// </summary>
        /// <param name="helloWorldPostRequest">Contains the details of the hello world webhook (optional)</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns><see cref="Task"/>&lt;<see cref="IHelloWorldPostApiResponse"/>&gt;</returns>
        public async Task<IHelloWorldPostApiResponse?> HelloWorldPostOrDefaultAsync(Option<HelloWorldPostRequest> helloWorldPostRequest = default, System.Threading.CancellationToken cancellationToken = default)
        {
            try
            {
                return await HelloWorldPostAsync(helloWorldPostRequest, cancellationToken).ConfigureAwait(false);
            }
            catch (Exception)
            {
                return null;
            }
        }

        /// <summary>
        /// Example webhook Send when an example is needed
        /// </summary>
        /// <exception cref="ApiException">Thrown when fails to make API call</exception>
        /// <param name="helloWorldPostRequest">Contains the details of the hello world webhook (optional)</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns><see cref="Task"/>&lt;<see cref="IHelloWorldPostApiResponse"/>&gt;</returns>
        public async Task<IHelloWorldPostApiResponse> HelloWorldPostAsync(Option<HelloWorldPostRequest> helloWorldPostRequest = default, System.Threading.CancellationToken cancellationToken = default)
        {
            UriBuilder uriBuilderLocalVar = new UriBuilder();

            try
            {
                ValidateHelloWorldPost(helloWorldPostRequest);

                FormatHelloWorldPost(helloWorldPostRequest);

                using (HttpRequestMessage httpRequestMessageLocalVar = new HttpRequestMessage())
                {
                    uriBuilderLocalVar.Host = HttpClient.BaseAddress!.Host;
                    uriBuilderLocalVar.Port = HttpClient.BaseAddress.Port;
                    uriBuilderLocalVar.Scheme = HttpClient.BaseAddress.Scheme;
                    uriBuilderLocalVar.Path = HttpClient.BaseAddress.AbsolutePath == "/"
                        ? "/helloWorld"
                        : string.Concat(HttpClient.BaseAddress.AbsolutePath, "/helloWorld");

                    if (helloWorldPostRequest.IsSet)
                        httpRequestMessageLocalVar.Content = (helloWorldPostRequest.Value as object) is System.IO.Stream stream
                            ? httpRequestMessageLocalVar.Content = new StreamContent(stream)
                            : httpRequestMessageLocalVar.Content = new StringContent(JsonSerializer.Serialize(helloWorldPostRequest.Value, _jsonSerializerOptions));

                    httpRequestMessageLocalVar.RequestUri = uriBuilderLocalVar.Uri;

                    string[] contentTypes = new string[] {
                        "application/json"
                    };

                    string? contentTypeLocalVar = ClientUtils.SelectHeaderContentType(contentTypes);

                    if (contentTypeLocalVar != null && httpRequestMessageLocalVar.Content != null)
                        httpRequestMessageLocalVar.Content.Headers.ContentType = new MediaTypeHeaderValue(contentTypeLocalVar);

                    httpRequestMessageLocalVar.Method = HttpMethod.Post;

                    DateTime requestedAtLocalVar = DateTime.UtcNow;

                    using (HttpResponseMessage httpResponseMessageLocalVar = await HttpClient.SendAsync(httpRequestMessageLocalVar, cancellationToken).ConfigureAwait(false))
                    {
                        ILogger<HelloWorldPostApiResponse> apiResponseLoggerLocalVar = LoggerFactory.CreateLogger<HelloWorldPostApiResponse>();
                        HelloWorldPostApiResponse apiResponseLocalVar;

                        switch ((int)httpResponseMessageLocalVar.StatusCode) {
                            default: {
                                string responseContentLocalVar = await httpResponseMessageLocalVar.Content.ReadAsStringAsync(cancellationToken).ConfigureAwait(false);
                                apiResponseLocalVar = new(apiResponseLoggerLocalVar, httpRequestMessageLocalVar, httpResponseMessageLocalVar, responseContentLocalVar, "/helloWorld", requestedAtLocalVar, _jsonSerializerOptions);

                                break;
                            }
                        }

                        AfterHelloWorldPostDefaultImplementation(apiResponseLocalVar, helloWorldPostRequest);

                        Events.ExecuteOnHelloWorldPost(apiResponseLocalVar);

                        return apiResponseLocalVar;
                    }
                }
            }
            catch(Exception e)
            {
                OnErrorHelloWorldPostDefaultImplementation(e, "/helloWorld", uriBuilderLocalVar.Path, helloWorldPostRequest);
                Events.ExecuteOnErrorHelloWorldPost(e);
                throw;
            }
        }

        /// <summary>
        /// The <see cref="HelloWorldPostApiResponse"/>
        /// </summary>
        public partial class HelloWorldPostApiResponse : Org.OpenAPITools.Client.ApiResponse, IHelloWorldPostApiResponse
        {
            /// <summary>
            /// The logger
            /// </summary>
            public ILogger<HelloWorldPostApiResponse> Logger { get; }

            /// <summary>
            /// The <see cref="HelloWorldPostApiResponse"/>
            /// </summary>
            /// <param name="logger"></param>
            /// <param name="httpRequestMessage"></param>
            /// <param name="httpResponseMessage"></param>
            /// <param name="rawContent"></param>
            /// <param name="path"></param>
            /// <param name="requestedAt"></param>
            /// <param name="jsonSerializerOptions"></param>
            public HelloWorldPostApiResponse(ILogger<HelloWorldPostApiResponse> logger, System.Net.Http.HttpRequestMessage httpRequestMessage, System.Net.Http.HttpResponseMessage httpResponseMessage, string rawContent, string path, DateTime requestedAt, System.Text.Json.JsonSerializerOptions jsonSerializerOptions) : base(httpRequestMessage, httpResponseMessage, rawContent, path, requestedAt, jsonSerializerOptions)
            {
                Logger = logger;
                OnCreated(httpRequestMessage, httpResponseMessage);
            }

            /// <summary>
            /// The <see cref="HelloWorldPostApiResponse"/>
            /// </summary>
            /// <param name="logger"></param>
            /// <param name="httpRequestMessage"></param>
            /// <param name="httpResponseMessage"></param>
            /// <param name="contentStream"></param>
            /// <param name="path"></param>
            /// <param name="requestedAt"></param>
            /// <param name="jsonSerializerOptions"></param>
            public HelloWorldPostApiResponse(ILogger<HelloWorldPostApiResponse> logger, System.Net.Http.HttpRequestMessage httpRequestMessage, System.Net.Http.HttpResponseMessage httpResponseMessage, System.IO.Stream contentStream, string path, DateTime requestedAt, System.Text.Json.JsonSerializerOptions jsonSerializerOptions) : base(httpRequestMessage, httpResponseMessage, contentStream, path, requestedAt, jsonSerializerOptions)
            {
                Logger = logger;
                OnCreated(httpRequestMessage, httpResponseMessage);
            }

            partial void OnCreated(global::System.Net.Http.HttpRequestMessage httpRequestMessage, System.Net.Http.HttpResponseMessage httpResponseMessage);

            /// <summary>
            /// Returns true if the response is 204 NoContent
            /// </summary>
            /// <returns></returns>
            public bool IsNoContent => 204 == (int)StatusCode;

            /// <summary>
            /// Returns true if the response is 500 InternalServerError
            /// </summary>
            /// <returns></returns>
            public bool IsInternalServerError => 500 == (int)StatusCode;

            private void OnDeserializationErrorDefaultImplementation(Exception exception, HttpStatusCode httpStatusCode)
            {
                bool suppressDefaultLog = false;
                OnDeserializationError(ref suppressDefaultLog, exception, httpStatusCode);
                if (!suppressDefaultLog)
                    Logger.LogError(exception, "An error occurred while deserializing the {code} response.", httpStatusCode);
            }

            partial void OnDeserializationError(ref bool suppressDefaultLog, Exception exception, HttpStatusCode httpStatusCode);
        }
    }
}
