/*
 * OpenAPI Petstore
 *
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Net;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Azure.WebJobs;
using Microsoft.Azure.WebJobs.Extensions.Http;

namespace Org.OpenAPITools.Apis
{ 
    public partial class StoreApi
    { 
        [FunctionName("StoreApi_DeleteOrder")]
        public async Task<IActionResult> _DeleteOrder([HttpTrigger(AuthorizationLevel.Anonymous, "DELETE", Route = "/store/order/{orderId}")]HttpRequest req, ExecutionContext context, string orderId)
        {
            var method = this.GetType().GetMethod("DeleteOrder");

            return method != null 
                ? (await ((Task<IActionResult>)method.Invoke(this, new object[] { req, context,  })).ConfigureAwait(false))
                : new StatusCodeResult((int)HttpStatusCode.NotImplemented);
        }

        [FunctionName("StoreApi_GetInventory")]
        public async Task<IActionResult> _GetInventory([HttpTrigger(AuthorizationLevel.Anonymous, "GET", Route = "/store/inventory")]HttpRequest req, ExecutionContext context)
        {
            var method = this.GetType().GetMethod("GetInventory");

            return method != null 
                ? (await ((Task<IActionResult>)method.Invoke(this, new object[] { req, context })).ConfigureAwait(false))
                : new StatusCodeResult((int)HttpStatusCode.NotImplemented);
        }

        [FunctionName("StoreApi_GetOrderById")]
        public async Task<IActionResult> _GetOrderById([HttpTrigger(AuthorizationLevel.Anonymous, "GET", Route = "/store/order/{orderId}")]HttpRequest req, ExecutionContext context, [Range(1, 5)]long orderId)
        {
            var method = this.GetType().GetMethod("GetOrderById");

            return method != null 
                ? (await ((Task<IActionResult>)method.Invoke(this, new object[] { req, context,  })).ConfigureAwait(false))
                : new StatusCodeResult((int)HttpStatusCode.NotImplemented);
        }

        [FunctionName("StoreApi_PlaceOrder")]
        public async Task<IActionResult> _PlaceOrder([HttpTrigger(AuthorizationLevel.Anonymous, "POST", Route = "/store/order")]HttpRequest req, ExecutionContext context)
        {
            var method = this.GetType().GetMethod("PlaceOrder");

            return method != null 
                ? (await ((Task<IActionResult>)method.Invoke(this, new object[] { req, context })).ConfigureAwait(false))
                : new StatusCodeResult((int)HttpStatusCode.NotImplemented);
        }
    }
}

