/*
 * OpenAPI Petstore
 *
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Net;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Azure.WebJobs;
using Microsoft.Azure.WebJobs.Extensions.Http;

namespace Org.OpenAPITools.Apis
{ 
    public partial class PetApi
    { 
        [FunctionName("PetApi_AddPet")]
        public async Task<IActionResult> _AddPet([HttpTrigger(AuthorizationLevel.Anonymous, "POST", Route = "/pet")]HttpRequest req, ExecutionContext context)
        {
            var method = this.GetType().GetMethod("AddPet");

            return method != null 
                ? (await ((Task<IActionResult>)method.Invoke(this, new object[] { req, context })).ConfigureAwait(false))
                : new StatusCodeResult((int)HttpStatusCode.NotImplemented);
        }

        [FunctionName("PetApi_DeletePet")]
        public async Task<IActionResult> _DeletePet([HttpTrigger(AuthorizationLevel.Anonymous, "DELETE", Route = "/pet/{petId}")]HttpRequest req, ExecutionContext context, long petId)
        {
            var method = this.GetType().GetMethod("DeletePet");

            return method != null 
                ? (await ((Task<IActionResult>)method.Invoke(this, new object[] { req, context,  })).ConfigureAwait(false))
                : new StatusCodeResult((int)HttpStatusCode.NotImplemented);
        }

        [FunctionName("PetApi_FindPetsByStatus")]
        public async Task<IActionResult> _FindPetsByStatus([HttpTrigger(AuthorizationLevel.Anonymous, "GET", Route = "/pet/findByStatus")]HttpRequest req, ExecutionContext context)
        {
            var method = this.GetType().GetMethod("FindPetsByStatus");

            return method != null 
                ? (await ((Task<IActionResult>)method.Invoke(this, new object[] { req, context })).ConfigureAwait(false))
                : new StatusCodeResult((int)HttpStatusCode.NotImplemented);
        }

        [FunctionName("PetApi_FindPetsByTags")]
        public async Task<IActionResult> _FindPetsByTags([HttpTrigger(AuthorizationLevel.Anonymous, "GET", Route = "/pet/findByTags")]HttpRequest req, ExecutionContext context)
        {
            var method = this.GetType().GetMethod("FindPetsByTags");

            return method != null 
                ? (await ((Task<IActionResult>)method.Invoke(this, new object[] { req, context })).ConfigureAwait(false))
                : new StatusCodeResult((int)HttpStatusCode.NotImplemented);
        }

        [FunctionName("PetApi_GetPetById")]
        public async Task<IActionResult> _GetPetById([HttpTrigger(AuthorizationLevel.Anonymous, "GET", Route = "/pet/{petId}")]HttpRequest req, ExecutionContext context, long petId)
        {
            var method = this.GetType().GetMethod("GetPetById");

            return method != null 
                ? (await ((Task<IActionResult>)method.Invoke(this, new object[] { req, context,  })).ConfigureAwait(false))
                : new StatusCodeResult((int)HttpStatusCode.NotImplemented);
        }

        [FunctionName("PetApi_UpdatePet")]
        public async Task<IActionResult> _UpdatePet([HttpTrigger(AuthorizationLevel.Anonymous, "PUT", Route = "/pet")]HttpRequest req, ExecutionContext context)
        {
            var method = this.GetType().GetMethod("UpdatePet");

            return method != null 
                ? (await ((Task<IActionResult>)method.Invoke(this, new object[] { req, context })).ConfigureAwait(false))
                : new StatusCodeResult((int)HttpStatusCode.NotImplemented);
        }

        [FunctionName("PetApi_UpdatePetWithForm")]
        public async Task<IActionResult> _UpdatePetWithForm([HttpTrigger(AuthorizationLevel.Anonymous, "POST", Route = "/pet/{petId}")]HttpRequest req, ExecutionContext context, long petId)
        {
            var method = this.GetType().GetMethod("UpdatePetWithForm");

            return method != null 
                ? (await ((Task<IActionResult>)method.Invoke(this, new object[] { req, context,  })).ConfigureAwait(false))
                : new StatusCodeResult((int)HttpStatusCode.NotImplemented);
        }

        [FunctionName("PetApi_UploadFile")]
        public async Task<IActionResult> _UploadFile([HttpTrigger(AuthorizationLevel.Anonymous, "POST", Route = "/pet/{petId}/uploadImage")]HttpRequest req, ExecutionContext context, long petId)
        {
            var method = this.GetType().GetMethod("UploadFile");

            return method != null 
                ? (await ((Task<IActionResult>)method.Invoke(this, new object[] { req, context,  })).ConfigureAwait(false))
                : new StatusCodeResult((int)HttpStatusCode.NotImplemented);
        }
    }
}

