module Petstore
  # Define possible value types for our own AnyHash class (RecursiveHash)
  alias ValuesType = Nil |
                     Bool |
                     String |
                     Time |
                     Int32 |
                     Int64 |
                     Float32 |
                     Float64 |
                     Array(ValuesType)

  # Define our own AnyHash class (RecursiveHash)
  # RecursiveHash
  AnyHash.define_new klass: :RecursiveHash,
    key: String,
    value: ValuesType
end
