# #OpenAPI Petstore
#
##This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
#
#The version of the OpenAPI document: 1.0.0
#
#Generated by: https://openapi-generator.tech
#Generator version: 7.20.0-SNAPSHOT
#

module Petstore
  # A pet for sale in the pet store
  class Pet
    include JSON::Serializable
    include YAML::Serializable

    # Required properties
    @[JSON::Field(key: "name", type: String, nillable: false, emit_null: false)]
    property name : String

    @[JSON::Field(key: "photoUrls", type: Array(String), nillable: false, emit_null: false)]
    property photo_urls : Array(String)

    # Optional properties
    @[JSON::Field(key: "id", type: Int64?, nillable: true, emit_null: false)]
    property id : Int64?

    @[JSON::Field(key: "category", type: Category?, nillable: true, emit_null: false)]
    property category : Category?

    @[JSON::Field(key: "tags", type: Array(Tag)?, nillable: true, emit_null: false)]
    property tags : Array(Tag)?

    # pet status in the store
    @[JSON::Field(key: "status", type: String?, nillable: true, emit_null: false)]
    property status : String?

    abstract class EnumAttributeValidator
      def valid?(value)
        !value || @allowable_values.includes?(value)
      end

      def message
        "invalid value for \"#{@attribute}\", must be one of #{@allowable_values}."
      end

      def to(_type, value)
        case _type
        when Int32
          value.to_i32
        when Int64
          value.to_i64
        when Float32
          value.to_f32
        when Float64
          value.to_f64
        else
          value.to_s
        end
      end
    end

    class EnumAttributeValidatorForStatus < EnumAttributeValidator
      @attribute : String
      @allowable_values : Array(Int32 | Int64 | Float32 | Float64 | String)

      def initialize
        @attribute = "status"
        @allowable_values = ["available", "pending", "sold"].map { |value| to(String, value)}
      end
    end


    # Initializes the object
    # @param [Hash] attributes Model attributes in the form of hash
    def initialize(@name : String, @photo_urls : Array(String), @id : Int64? = nil, @category : Category? = nil, @tags : Array(Tag)? = nil, @status : String? = nil)
    end

    # Show invalid properties with the reasons. Usually used together with valid?
    # @return Array for valid properties with the reasons
    def list_invalid_properties
      invalid_properties = Array(String).new
      status_validator = EnumAttributeValidatorForStatus.new
      if !status_validator.valid?(@status)
        message = status_validator.message
        invalid_properties.push(message)
      end

      invalid_properties
    end

    # Check to see if the all the properties in the model are valid
    # @return true if the model is valid
    def valid?
      status_validator = EnumAttributeValidatorForStatus.new
      return false unless status_validator.valid?(@status)
      true
    end

    # Custom attribute writer method checking allowed values (enum).
    # @param [Object] status Object to be assigned
    def status=(status)
      validator = EnumAttributeValidatorForStatus.new
      unless validator.valid?(status)
        raise ArgumentError.new(validator.message)
      end
      @status = status
    end

    # Checks equality by comparing each attribute.
    # @param [Object] Object to be compared
    def ==(other)
      return true if self.same?(other)
      self.class == other.class &&
          id == other.id &&
          category == other.category &&
          name == other.name &&
          photo_urls == other.photo_urls &&
          tags == other.tags &&
          status == other.status
    end

    # @see the `==` method
    # @param [Object] Object to be compared
    def eql?(other)
      self == other
    end

    # Calculates hash code according to all attributes.
    # @return [Integer] Hash code
    def hash
      [id, category, name, photo_urls, tags, status].hash
    end

    # Returns the string representation of the object
    # @return [String] String presentation of the object
    def to_s
      to_h.to_s
    end

    # to_body is an alias to to_h (backward compatibility)
    # @return [Hash] Returns the object in the form of hash
    def to_body
      to_h
    end

    # Returns the object in the form of hash
    # @return [Hash] Returns the object in the form of hash
    def to_h
      hash = NetboxClient::RecursiveHash.new
      hash["id"] = _to_h(id)
      hash["category"] = _to_h(category)
      hash["name"] = _to_h(name)
      hash["photoUrls"] = _to_h(photo_urls)
      hash["tags"] = _to_h(tags)
      hash["status"] = _to_h(status)
      hash.to_h
    end

    # Outputs non-array value in the form of hash
    # For object, use to_h. Otherwise, just return the value
    # @param [Object] value Any valid value
    # @return [Hash] Returns the value in the form of hash
    private def _to_h(value)
      return nil if value.nil?

      if value.is_a?(Hash)
        hash = NetboxClient::RecursiveHash.new
        value.each { |k, v| hash[k] = _to_h(v) }
        hash
      elsif value.is_a?(Array)
        value.compact.map { |v| _to_h(v) }
      elsif value.responds_to?(:to_h)
        value.to_h
      else
        value
      end
    end

  end

end
