/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator
 * https://github.com/OpenAPITools/openapi-generator
 * Do not edit the class manually.
 */

#pragma once

#include "CoreMinimal.h"
#include "OpenAPIBaseModel.h"

namespace OpenAPI
{

class OPENAPI_API OpenAPIStoreApi
{
public:
	OpenAPIStoreApi();
	~OpenAPIStoreApi();

	/* Sets the URL Endpoint.
	* Note: several fallback endpoints can be configured in request retry policies, see Request::SetShouldRetry */
	void SetURL(const FString& Url);

	/* Adds global header params to all requests */
	void AddHeaderParam(const FString& Key, const FString& Value);
	void ClearHeaderParams();

	/* Sets the retry manager to the user-defined retry manager. User must manage the lifetime of the retry manager.
	* If no retry manager is specified and a request needs retries, a default retry manager will be used.
	* See also: Request::SetShouldRetry */
	void SetHttpRetryManager(FHttpRetrySystem::FManager& RetryManager);
	FHttpRetrySystem::FManager& GetHttpRetryManager();

	class DeleteOrderRequest;
	class DeleteOrderResponse;
	class GetInventoryRequest;
	class GetInventoryResponse;
	class GetOrderByIdRequest;
	class GetOrderByIdResponse;
	class PlaceOrderRequest;
	class PlaceOrderResponse;
	
    DECLARE_DELEGATE_OneParam(FDeleteOrderDelegate, const DeleteOrderResponse&);
    DECLARE_DELEGATE_OneParam(FGetInventoryDelegate, const GetInventoryResponse&);
    DECLARE_DELEGATE_OneParam(FGetOrderByIdDelegate, const GetOrderByIdResponse&);
    DECLARE_DELEGATE_OneParam(FPlaceOrderDelegate, const PlaceOrderResponse&);
    
    FHttpRequestPtr DeleteOrder(const DeleteOrderRequest& Request, const FDeleteOrderDelegate& Delegate = FDeleteOrderDelegate()) const;
    FHttpRequestPtr GetInventory(const GetInventoryRequest& Request, const FGetInventoryDelegate& Delegate = FGetInventoryDelegate()) const;
    FHttpRequestPtr GetOrderById(const GetOrderByIdRequest& Request, const FGetOrderByIdDelegate& Delegate = FGetOrderByIdDelegate()) const;
    FHttpRequestPtr PlaceOrder(const PlaceOrderRequest& Request, const FPlaceOrderDelegate& Delegate = FPlaceOrderDelegate()) const;
    
private:
    void OnDeleteOrderResponse(FHttpRequestPtr HttpRequest, FHttpResponsePtr HttpResponse, bool bSucceeded, FDeleteOrderDelegate Delegate) const;
    void OnGetInventoryResponse(FHttpRequestPtr HttpRequest, FHttpResponsePtr HttpResponse, bool bSucceeded, FGetInventoryDelegate Delegate) const;
    void OnGetOrderByIdResponse(FHttpRequestPtr HttpRequest, FHttpResponsePtr HttpResponse, bool bSucceeded, FGetOrderByIdDelegate Delegate) const;
    void OnPlaceOrderResponse(FHttpRequestPtr HttpRequest, FHttpResponsePtr HttpResponse, bool bSucceeded, FPlaceOrderDelegate Delegate) const;
    
	FHttpRequestRef CreateHttpRequest(const Request& Request) const;
	bool IsValid() const;
	void HandleResponse(FHttpResponsePtr HttpResponse, bool bSucceeded, Response& InOutResponse) const;

	FString Url;
	TMap<FString,FString> AdditionalHeaderParams;
	mutable FHttpRetrySystem::FManager* RetryManager = nullptr;
	mutable TUniquePtr<HttpRetryManager> DefaultRetryManager;
};

}
