/**
* OpenAPI Petstore
* This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
*
* The version of the OpenAPI document: 1.0.0
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
/*
 * UserApi.h
 *
 * 
 */

#ifndef UserApi_H_
#define UserApi_H_



#include "oatpp/web/client/ApiClient.hpp"
#include "oatpp/web/protocol/http/outgoing/MultipartBody.hpp"
#include "oatpp/core/macro/codegen.hpp"

#include "User.hpp"

#include OATPP_CODEGEN_BEGIN(ApiClient) ///< Begin code-gen section

namespace org::openapitools::client::api
{

class UserApi : public oatpp::web::client::ApiClient {
public:

  API_CLIENT_INIT(UserApi)

  /// <summary>
  /// Create user
  /// </summary>
  /// <remarks>
  /// This can only be done by the logged in user.
  /// </remarks>
  /// <param name="user">Created user object</param>
  API_CALL("POST", "/user", create_user, BODY_DTO(oatpp::Object<org::openapitools::client::model::User>, user))
  /// <summary>
  /// Creates list of users with given input array
  /// </summary>
  /// <remarks>
  /// 
  /// </remarks>
  /// <param name="user">List of user object</param>
  API_CALL("POST", "/user/createWithArray", create_users_with_array_input, BODY_DTO(oatpp::Vector<oatpp::Object<org::openapitools::client::model::User>>, user))
  /// <summary>
  /// Creates list of users with given input array
  /// </summary>
  /// <remarks>
  /// 
  /// </remarks>
  /// <param name="user">List of user object</param>
  API_CALL("POST", "/user/createWithList", create_users_with_list_input, BODY_DTO(oatpp::Vector<oatpp::Object<org::openapitools::client::model::User>>, user))
  /// <summary>
  /// Delete user
  /// </summary>
  /// <remarks>
  /// This can only be done by the logged in user.
  /// </remarks>
  /// <param name="username">The name that needs to be deleted</param>
  API_CALL("DELETE", "/user/{username}", delete_user, PATH(oatpp::String, username))
  /// <summary>
  /// Get user by user name
  /// </summary>
  /// <remarks>
  /// 
  /// </remarks>
  /// <param name="username">The name that needs to be fetched. Use user1 for testing.</param>
  API_CALL("GET", "/user/{username}", get_user_by_name, PATH(oatpp::String, username))
  /// <summary>
  /// Logs user into the system
  /// </summary>
  /// <remarks>
  /// 
  /// </remarks>
  /// <param name="username">The user name for login</param>
  /// <param name="password">The password for login in clear text</param>
  API_CALL("GET", "/user/login", login_user, QUERY(oatpp::String, username), QUERY(oatpp::String, password))
  /// <summary>
  /// Logs out current logged in user session
  /// </summary>
  /// <remarks>
  /// 
  /// </remarks>
  API_CALL("GET", "/user/logout", logout_user)
  /// <summary>
  /// Updated user
  /// </summary>
  /// <remarks>
  /// This can only be done by the logged in user.
  /// </remarks>
  /// <param name="username">name that need to be deleted</param>
  /// <param name="user">Updated user object</param>
  API_CALL("PUT", "/user/{username}", update_user, PATH(oatpp::String, username), BODY_DTO(oatpp::Object<org::openapitools::client::model::User>, user))
};

#include OATPP_CODEGEN_END(ApiClient) ///< End code-gen section

} // namespace org::openapitools::client::api

#endif /* UserApi_H_ */

