/**
* OpenAPI Petstore
* This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
*
* The version of the OpenAPI document: 1.0.0
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
/*
 * StoreApi.h
 *
 * 
 */

#ifndef StoreApi_H_
#define StoreApi_H_



#include "oatpp/web/client/ApiClient.hpp"
#include "oatpp/web/protocol/http/outgoing/MultipartBody.hpp"
#include "oatpp/core/macro/codegen.hpp"

#include "Order.hpp"

#include OATPP_CODEGEN_BEGIN(ApiClient) ///< Begin code-gen section

namespace org::openapitools::client::api
{

class StoreApi : public oatpp::web::client::ApiClient {
public:

  API_CLIENT_INIT(StoreApi)

  /// <summary>
  /// Delete purchase order by ID
  /// </summary>
  /// <remarks>
  /// For valid response try integer IDs with value &lt; 1000. Anything above 1000 or nonintegers will generate API errors
  /// </remarks>
  /// <param name="orderId">ID of the order that needs to be deleted</param>
  API_CALL("DELETE", "/store/order/{orderId}", delete_order, PATH(oatpp::String, orderId))
  /// <summary>
  /// Returns pet inventories by status
  /// </summary>
  /// <remarks>
  /// Returns a map of status codes to quantities
  /// </remarks>
  API_CALL("GET", "/store/inventory", get_inventory)
  /// <summary>
  /// Find purchase order by ID
  /// </summary>
  /// <remarks>
  /// For valid response try integer IDs with value &lt;&#x3D; 5 or &gt; 10. Other values will generate exceptions
  /// </remarks>
  /// <param name="orderId">ID of pet that needs to be fetched</param>
  API_CALL("GET", "/store/order/{orderId}", get_order_by_id, PATH(oatpp::Int64, orderId))
  /// <summary>
  /// Place an order for a pet
  /// </summary>
  /// <remarks>
  /// 
  /// </remarks>
  /// <param name="order">order placed for purchasing the pet</param>
  API_CALL("POST", "/store/order", place_order, BODY_DTO(oatpp::Object<org::openapitools::client::model::Order>, order))
};

#include OATPP_CODEGEN_END(ApiClient) ///< End code-gen section

} // namespace org::openapitools::client::api

#endif /* StoreApi_H_ */

