/**
* OpenAPI Petstore
* This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
*
* The version of the OpenAPI document: 1.0.0
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
/*
 * PetApi.h
 *
 * 
 */

#ifndef PetApi_H_
#define PetApi_H_



#include "oatpp/web/client/ApiClient.hpp"
#include "oatpp/web/protocol/http/outgoing/MultipartBody.hpp"
#include "oatpp/core/macro/codegen.hpp"

#include "ApiResponse.hpp"
#include "Pet.hpp"

#include OATPP_CODEGEN_BEGIN(ApiClient) ///< Begin code-gen section

namespace org::openapitools::client::api
{

class PetApi : public oatpp::web::client::ApiClient {
public:

  API_CLIENT_INIT(PetApi)

  /// <summary>
  /// Add a new pet to the store
  /// </summary>
  /// <remarks>
  /// 
  /// </remarks>
  /// <param name="pet">Pet object that needs to be added to the store</param>
  API_CALL("POST", "/pet", add_pet, BODY_DTO(oatpp::Object<org::openapitools::client::model::Pet>, pet))
  /// <summary>
  /// Deletes a pet
  /// </summary>
  /// <remarks>
  /// 
  /// </remarks>
  /// <param name="petId">Pet id to delete</param>
  /// <param name="apiKey"> (optional, default to &quot;&quot;)</param>
  API_CALL("DELETE", "/pet/{petId}", delete_pet, PATH(oatpp::Int64, petId), HEADER(oatpp::String, apiKey, "apiKey"))
  /// <summary>
  /// Finds Pets by status
  /// </summary>
  /// <remarks>
  /// Multiple status values can be provided with comma separated strings
  /// </remarks>
  /// <param name="status">Status values that need to be considered for filter</param>
  API_CALL("GET", "/pet/findByStatus", find_pets_by_status, QUERY(oatpp::Vector<oatpp::String>, status))
  /// <summary>
  /// Finds Pets by tags
  /// </summary>
  /// <remarks>
  /// Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
  /// </remarks>
  /// <param name="tags">Tags to filter by</param>
  API_CALL("GET", "/pet/findByTags", find_pets_by_tags, QUERY(oatpp::Vector<oatpp::String>, tags))
  /// <summary>
  /// Find pet by ID
  /// </summary>
  /// <remarks>
  /// Returns a single pet
  /// </remarks>
  /// <param name="petId">ID of pet to return</param>
  API_CALL("GET", "/pet/{petId}", get_pet_by_id, PATH(oatpp::Int64, petId))
  /// <summary>
  /// Update an existing pet
  /// </summary>
  /// <remarks>
  /// 
  /// </remarks>
  /// <param name="pet">Pet object that needs to be added to the store</param>
  API_CALL("PUT", "/pet", update_pet, BODY_DTO(oatpp::Object<org::openapitools::client::model::Pet>, pet))
  /// <summary>
  /// Updates a pet in the store with form data
  /// </summary>
  /// <remarks>
  /// 
  /// </remarks>
  /// <param name="petId">ID of pet that needs to be updated</param>
  /// <param name="name">Updated name of the pet (optional, default to &quot;&quot;)</param>
  /// <param name="status">Updated status of the pet (optional, default to &quot;&quot;)</param>
  API_CALL("POST", "/pet/{petId}", update_pet_with_form, PATH(oatpp::Int64, petId), BODY(std::shared_ptr<oatpp::web::protocol::http::outgoing::MultipartBody>, formData))
  /// <summary>
  /// uploads an image
  /// </summary>
  /// <remarks>
  /// 
  /// </remarks>
  /// <param name="petId">ID of pet to update</param>
  /// <param name="additionalMetadata">Additional data to pass to server (optional, default to &quot;&quot;)</param>
  /// <param name="file">file to upload (optional, default to &quot;&quot;)</param>
  API_CALL("POST", "/pet/{petId}/uploadImage", upload_file, PATH(oatpp::Int64, petId), BODY(std::shared_ptr<oatpp::web::protocol::http::outgoing::MultipartBody>, formData))
};

#include OATPP_CODEGEN_END(ApiClient) ///< End code-gen section

} // namespace org::openapitools::client::api

#endif /* PetApi_H_ */

