# C API client for openapi_petstore

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project. By using the [OpenAPI spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 1.0.0
- Package version: 
- Generator version: 7.20.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.CLibcurlClientCodegen

## Installation
You'll need the `curl 7.61.1` package in order to build the API. To have code formatted nicely, you also need to have uncrustify version 0.67 or later.

# Prerequisites

## Install the `curl 7.61.1` package with the following command on Linux.
```bash
sudo apt remove curl
wget http://curl.haxx.se/download/curl-7.61.1.tar.gz
tar -xvf curl-7.61.1.tar.gz
cd curl-7.61.1/
./configure
make
sudo make install
```
## Install the `uncrustify 0.67` package with the following command on Linux.
```bash
git clone https://github.com/uncrustify/uncrustify.git
cd uncrustify
mkdir build
cd build
cmake ..
make
sudo make install
```

## Compile the sample:
This will compile the generated code and create a library in the build folder which has to be linked to the codes where API will be used.
```bash
mkdir build
cd build
// To install library to specific location, use following commands
cmake -DCMAKE_INSTALL_PREFIX=/pathtolocation ..
// for normal install use following command
cmake ..
make
sudo make install
```
## How to use compiled library
Considering the test/source code which uses the API is written in main.c(respective api include is written and all objects necessary are defined and created)

To compile main.c(considering the file is present in build folder) use following command
-L - location of the library(not required if cmake with normal installation is performed)
-l library name
```bash
gcc main.c -L. -lopenapi_petstore -o main
```
Once compiled, you can run it with ``` ./main ```

Note: You don't need to specify includes for models and include folder separately as they are path linked. You just have to import the api.h file in your code, the include linking will work.

## Documentation for API Endpoints

All URIs are relative to *http://petstore.swagger.io/v2*

Category | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*PetAPI* | [**PetAPI_addPet**](docs/PetAPI.md#PetAPI_addPet) | **POST** /pet | Add a new pet to the store
*PetAPI* | [**PetAPI_deletePet**](docs/PetAPI.md#PetAPI_deletePet) | **DELETE** /pet/{petId} | Deletes a pet
*PetAPI* | [**PetAPI_findPetsByStatus**](docs/PetAPI.md#PetAPI_findPetsByStatus) | **GET** /pet/findByStatus | Finds Pets by status
*PetAPI* | [**PetAPI_findPetsByTags**](docs/PetAPI.md#PetAPI_findPetsByTags) | **GET** /pet/findByTags | Finds Pets by tags
*PetAPI* | [**PetAPI_getDaysWithoutIncident**](docs/PetAPI.md#PetAPI_getDaysWithoutIncident) | **GET** /store/daysWithoutIncident | Number of days since the last time a pet maimed someone at the store
*PetAPI* | [**PetAPI_getPetById**](docs/PetAPI.md#PetAPI_getPetById) | **GET** /pet/{petId} | Find pet by ID
*PetAPI* | [**PetAPI_getPetByUuid**](docs/PetAPI.md#PetAPI_getPetByUuid) | **GET** /pet/byUuid/{uuid} | Find pet by UUID
*PetAPI* | [**PetAPI_getPicture**](docs/PetAPI.md#PetAPI_getPicture) | **GET** /pet/picture | Get a random picture of someone else's pet
*PetAPI* | [**PetAPI_isPetAvailable**](docs/PetAPI.md#PetAPI_isPetAvailable) | **POST** /pet/{petId}/isAvailable | Is this pet still available?
*PetAPI* | [**PetAPI_sharePicture**](docs/PetAPI.md#PetAPI_sharePicture) | **POST** /pet/picture | Send a picture of your happy pet
*PetAPI* | [**PetAPI_specialtyPet**](docs/PetAPI.md#PetAPI_specialtyPet) | **GET** /pet/specialty | Specialty of the shop
*PetAPI* | [**PetAPI_updatePet**](docs/PetAPI.md#PetAPI_updatePet) | **PUT** /pet | Update an existing pet
*PetAPI* | [**PetAPI_updatePetWithForm**](docs/PetAPI.md#PetAPI_updatePetWithForm) | **POST** /pet/{petId} | Updates a pet in the store with form data
*PetAPI* | [**PetAPI_uploadFile**](docs/PetAPI.md#PetAPI_uploadFile) | **POST** /pet/{petId}/uploadImage | uploads an image
*StoreAPI* | [**StoreAPI_deleteOrder**](docs/StoreAPI.md#StoreAPI_deleteOrder) | **DELETE** /store/order/{orderId} | Delete purchase order by ID
*StoreAPI* | [**StoreAPI_getInventory**](docs/StoreAPI.md#StoreAPI_getInventory) | **GET** /store/inventory | Returns pet inventories by status
*StoreAPI* | [**StoreAPI_getOrderById**](docs/StoreAPI.md#StoreAPI_getOrderById) | **GET** /store/order/{orderId} | Find purchase order by ID
*StoreAPI* | [**StoreAPI_placeOrder**](docs/StoreAPI.md#StoreAPI_placeOrder) | **POST** /store/order | Place an order for a pet
*StoreAPI* | [**StoreAPI_sendFeedback**](docs/StoreAPI.md#StoreAPI_sendFeedback) | **POST** /store/feedback | Send us a feedback message
*StoreAPI* | [**StoreAPI_sendRating**](docs/StoreAPI.md#StoreAPI_sendRating) | **POST** /store/rating/{rating} | How would you rate our service?
*StoreAPI* | [**StoreAPI_sendRecommend**](docs/StoreAPI.md#StoreAPI_sendRecommend) | **POST** /store/recommend | Would you recommend our service to a friend?
*UserAPI* | [**UserAPI_createUser**](docs/UserAPI.md#UserAPI_createUser) | **POST** /user | Create user
*UserAPI* | [**UserAPI_createUsersWithArrayInput**](docs/UserAPI.md#UserAPI_createUsersWithArrayInput) | **POST** /user/createWithArray | Creates list of users with given input array
*UserAPI* | [**UserAPI_createUsersWithListInput**](docs/UserAPI.md#UserAPI_createUsersWithListInput) | **POST** /user/createWithList | Creates list of users with given input array
*UserAPI* | [**UserAPI_deleteUser**](docs/UserAPI.md#UserAPI_deleteUser) | **DELETE** /user/{username} | Delete user
*UserAPI* | [**UserAPI_getUserByName**](docs/UserAPI.md#UserAPI_getUserByName) | **GET** /user/{username} | Get user by user name
*UserAPI* | [**UserAPI_loginUser**](docs/UserAPI.md#UserAPI_loginUser) | **GET** /user/login | Logs user into the system
*UserAPI* | [**UserAPI_logoutUser**](docs/UserAPI.md#UserAPI_logoutUser) | **GET** /user/logout | Logs out current logged in user session
*UserAPI* | [**UserAPI_testInt32Int64FloatDouble**](docs/UserAPI.md#UserAPI_testInt32Int64FloatDouble) | **GET** /user/test_int32_int64_float_double | test int32, int64 float and double query parameters in API
*UserAPI* | [**UserAPI_testIntAndBool**](docs/UserAPI.md#UserAPI_testIntAndBool) | **GET** /user/testIntAndBool | test integer and boolean query parameters in API
*UserAPI* | [**UserAPI_updateUser**](docs/UserAPI.md#UserAPI_updateUser) | **PUT** /user/{username} | Updated user


## Documentation for Models

 - [MappedModel_t](docs/MappedModel.md)
 - [api_response_t](docs/api_response.md)
 - [bit_t](docs/bit.md)
 - [category_t](docs/category.md)
 - [model_with_set_propertes_t](docs/model_with_set_propertes.md)
 - [order_t](docs/order.md)
 - [pet_t](docs/pet.md)
 - [preference_t](docs/preference.md)
 - [tag_t](docs/tag.md)
 - [user_t](docs/user.md)


## Documentation for Authorization


Authentication schemes defined for the API:
### petstore_auth


- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: http://petstore.swagger.io/api/oauth/dialog
- **Scopes**: 
  - write:pets: modify pets in your account
  - read:pets: read your pets

### api_key

- **Type**: API key

- **API key parameter name**: api_key
- **Location**: HTTP header


## Author



