/*
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the OAS code generator program.
 * https://github.com/OpenAPITools/openapi-generator
 * Do not edit the class manually.
 */

public class OASStoreApi {
    OASClient client;

    public OASStoreApi(OASClient client) {
        this.client = client;
    }

    public OASStoreApi() {
        this.client = new OASClient();
    }

    public OASClient getClient() {
        return this.client;
    }

    /**
     * Delete purchase order by ID
     * For valid response try integer IDs with value &lt; 1000. Anything above 1000 or nonintegers will generate API errors
     * @param orderId ID of the order that needs to be deleted (required)
     * @throws OAS.ApiException if fails to make API call
     */
    public void deleteOrder(Map<String, Object> params) {
        client.assertNotNull(params.get('orderId'), 'orderId');
        List<OAS.Param> query = new List<OAS.Param>();
        List<OAS.Param> form = new List<OAS.Param>();

        client.invoke(
            'DELETE', '/store/order/{orderId}', '',
            query, form,
            new Map<String, Object>{
                'orderId' => (String) params.get('orderId')
            },
            new Map<String, Object>(),
            new List<String>(),
            new List<String>(),
            new List<String>(),
            null
        );
    }
    /**
     * Returns pet inventories by status
     * Returns a map of status codes to quantities
     * @return Map<String, Integer>
     * @throws OAS.ApiException if fails to make API call
     */
    public Map<String, Integer> getInventory() {
        List<OAS.Param> query = new List<OAS.Param>();
        List<OAS.Param> form = new List<OAS.Param>();

        return (Map<String, Integer>) client.invoke(
            'GET', '/store/inventory', '',
            query, form,
            new Map<String, Object>(),
            new Map<String, Object>(),
            new List<String>{ 'application/json' },
            new List<String>(),
            new List<String> { 'api_key' },
            Map<String, Integer>.class
        );
    }
    /**
     * Find purchase order by ID
     * For valid response try integer IDs with value &lt;&#x3D; 5 or &gt; 10. Other values will generate exceptions
     * @param orderId ID of pet that needs to be fetched (required)
     * @return OASOrder
     * @throws OAS.ApiException if fails to make API call
     */
    public OASOrder getOrderById(Map<String, Object> params) {
        client.assertNotNull(params.get('orderId'), 'orderId');
        List<OAS.Param> query = new List<OAS.Param>();
        List<OAS.Param> form = new List<OAS.Param>();

        return (OASOrder) client.invoke(
            'GET', '/store/order/{orderId}', '',
            query, form,
            new Map<String, Object>{
                'orderId' => (Long) params.get('orderId')
            },
            new Map<String, Object>(),
            new List<String>{ 'application/xml', 'application/json' },
            new List<String>(),
            new List<String>(),
            OASOrder.class
        );
    }
    /**
     * Place an order for a pet
     * 
     * @param oaSOrder order placed for purchasing the pet (required)
     * @return OASOrder
     * @throws OAS.ApiException if fails to make API call
     */
    public OASOrder placeOrder(Map<String, Object> params) {
        client.assertNotNull(params.get('oaSOrder'), 'oaSOrder');
        List<OAS.Param> query = new List<OAS.Param>();
        List<OAS.Param> form = new List<OAS.Param>();

        return (OASOrder) client.invoke(
            'POST', '/store/order',
            (OASOrder) params.get('oaSOrder'),
            query, form,
            new Map<String, Object>(),
            new Map<String, Object>(),
            new List<String>{ 'application/xml', 'application/json' },
            new List<String>{ 'application/json' },
            new List<String>(),
            OASOrder.class
        );
    }
}
