# R API client for petstore

This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project. By using the [OpenAPI spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 1.0.0
- Package version: 1.0.0
- Generator version: 7.20.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.RClientCodegen

## Installation

### Prerequisites

Install the dependencies

```R
install.packages("jsonlite")
install.packages("httr")
install.packages("base64enc")
```

### Build the package

```sh
git clone https://github.com/GIT_USER_ID/GIT_REPO_ID
cd GIT_REPO_ID
R CMD build .
R CMD check petstore_1.0.0.tar.gz --no-manual
R CMD INSTALL --preclean petstore_1.0.0.tar.gz
```

### Install the package

```R
install.packages("petstore")
```

To install directly from Github, use `devtools`:
```R
install.packages("devtools")
library(devtools)
install_github("GIT_USER_ID/GIT_REPO_ID")
```

To install the package from a local file:
```R
install.packages("petstore_1.0.0.tar.gz", repos = NULL, type = "source")
```

### Usage

```R
library(petstore)
```

### Reformat code

To reformat code using [styler](https://styler.r-lib.org/index.html), please run the following in the R console:

```R
install.packages("remotes")
remotes::install_github("r-lib/styler@v1.7.0.9003")
library("styler")
style_dir()
```

## Documentation for API Endpoints

All URIs are relative to *http://petstore.swagger.io/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*FakeApi* | [**AddPetOptional**](docs/FakeApi.md#AddPetOptional) | **POST** /fake/test_optional_body_parameter | Add a new pet to the store (optional body)
*FakeApi* | [**FakeDataFile**](docs/FakeApi.md#FakeDataFile) | **GET** /fake/data_file | test data_file to ensure it's escaped correctly
*FakeApi* | [**FakePathArray**](docs/FakeApi.md#FakePathArray) | **GET** /fake/path_array/{path_array}/testing | test array parameter in path
*FakeApi* | [**FakeRegularExpression**](docs/FakeApi.md#FakeRegularExpression) | **GET** /fake/regular_expression | test regular expression to ensure no exception
*FakeApi* | [**FakeSetQuery**](docs/FakeApi.md#FakeSetQuery) | **GET** /fake/set_query_parameter | test set query parameter
*PetApi* | [**AddPet**](docs/PetApi.md#AddPet) | **POST** /pet | Add a new pet to the store
*PetApi* | [**DeletePet**](docs/PetApi.md#DeletePet) | **DELETE** /pet/{petId} | Deletes a pet
*PetApi* | [**FindPetsByStatus**](docs/PetApi.md#FindPetsByStatus) | **GET** /pet/findByStatus | Finds Pets by status
*PetApi* | [**FindPetsByTags**](docs/PetApi.md#FindPetsByTags) | **GET** /pet/findByTags | Finds Pets by tags
*PetApi* | [**GetPetById**](docs/PetApi.md#GetPetById) | **GET** /pet/{petId} | Find pet by ID
*PetApi* | [**GetPetByIdStreaming**](docs/PetApi.md#GetPetByIdStreaming) | **GET** /pet/{petId}?streaming | Find pet by ID (streaming)
*PetApi* | [**TestHeader**](docs/PetApi.md#TestHeader) | **GET** /pet_header_test | Header test
*PetApi* | [**UpdatePet**](docs/PetApi.md#UpdatePet) | **PUT** /pet | Update an existing pet
*PetApi* | [**UpdatePetWithForm**](docs/PetApi.md#UpdatePetWithForm) | **POST** /pet/{petId} | Updates a pet in the store with form data
*PetApi* | [**UploadFile**](docs/PetApi.md#UploadFile) | **POST** /pet/{petId}/uploadImage | uploads an image
*StoreApi* | [**DeleteOrder**](docs/StoreApi.md#DeleteOrder) | **DELETE** /store/order/{orderId} | Delete purchase order by ID
*StoreApi* | [**GetInventory**](docs/StoreApi.md#GetInventory) | **GET** /store/inventory | Returns pet inventories by status
*StoreApi* | [**GetOrderById**](docs/StoreApi.md#GetOrderById) | **GET** /store/order/{orderId} | Find purchase order by ID
*StoreApi* | [**PlaceOrder**](docs/StoreApi.md#PlaceOrder) | **POST** /store/order | Place an order for a pet
*UserApi* | [**CreateUser**](docs/UserApi.md#CreateUser) | **POST** /user | Create user
*UserApi* | [**CreateUsersWithArrayInput**](docs/UserApi.md#CreateUsersWithArrayInput) | **POST** /user/createWithArray | Creates list of users with given input array
*UserApi* | [**CreateUsersWithListInput**](docs/UserApi.md#CreateUsersWithListInput) | **POST** /user/createWithList | Creates list of users with given input array
*UserApi* | [**DeleteUser**](docs/UserApi.md#DeleteUser) | **DELETE** /user/{username} | Delete user
*UserApi* | [**GetUserByName**](docs/UserApi.md#GetUserByName) | **GET** /user/{username} | Get user by user name
*UserApi* | [**LoginUser**](docs/UserApi.md#LoginUser) | **GET** /user/login | Logs user into the system
*UserApi* | [**LogoutUser**](docs/UserApi.md#LogoutUser) | **GET** /user/logout | Logs out current logged in user session
*UserApi* | [**UpdateUser**](docs/UserApi.md#UpdateUser) | **PUT** /user/{username} | Updated user


## Documentation for Models

 - [AllofTagApiResponse](docs/AllofTagApiResponse.md)
 - [Animal](docs/Animal.md)
 - [AnyOfPig](docs/AnyOfPig.md)
 - [AnyOfPrimitiveTypeTest](docs/AnyOfPrimitiveTypeTest.md)
 - [BasquePig](docs/BasquePig.md)
 - [Cat](docs/Cat.md)
 - [Category](docs/Category.md)
 - [DanishPig](docs/DanishPig.md)
 - [Date](docs/Date.md)
 - [Dog](docs/Dog.md)
 - [DummyModel](docs/DummyModel.md)
 - [FormatTest](docs/FormatTest.md)
 - [Mammal](docs/Mammal.md)
 - [ModelApiResponse](docs/ModelApiResponse.md)
 - [NestedOneOf](docs/NestedOneOf.md)
 - [OneOfPrimitiveTypeTest](docs/OneOfPrimitiveTypeTest.md)
 - [Order](docs/Order.md)
 - [Pet](docs/Pet.md)
 - [PetMap](docs/PetMap.md)
 - [Pig](docs/Pig.md)
 - [Special](docs/Special.md)
 - [Tag](docs/Tag.md)
 - [UpdatePetRequest](docs/UpdatePetRequest.md)
 - [User](docs/User.md)
 - [Whale](docs/Whale.md)
 - [Zebra](docs/Zebra.md)


## Documentation for Authorization


Authentication schemes defined for the API:
### http_auth

- **Type**: HTTP basic authentication

### BearerToken

- **Type**: Bearer authentication

### petstore_auth

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: http://petstore.swagger.io/api/oauth/dialog
- **Scopes**: 
  - `write:pets`: modify pets in your account
  - `read:pets`: read your pets

### api_key

- **Type**: API key
- **API key parameter name**: api_key
- **Location**: HTTP header


