% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store_api.R
\docType{class}
\name{StoreApi}
\alias{StoreApi}
\title{Store operations}
\format{
An \code{R6Class} generator object
}
\description{
petstore.Store
}
\details{
OpenAPI Petstore

This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.

The version of the OpenAPI document: 1.0.0
Generated by: https://openapi-generator.tech
}
\section{Methods}{

\describe{
\strong{ DeleteOrder } \emph{ Delete purchase order by ID }
For valid response try integer IDs with value &lt; 1000. Anything above 1000 or nonintegers will generate API errors

\itemize{
\item \emph{ @param } order_id character

\item On encountering errors, an error of subclass ApiException will be thrown.

\item status code : 400 | Invalid ID supplied


\item response headers :

\tabular{ll}{
}
\item status code : 404 | Order not found


\item response headers :

\tabular{ll}{
}
}

\strong{ GetInventory } \emph{ Returns pet inventories by status }
Returns a map of status codes to quantities

\itemize{

\item On encountering errors, an error of subclass ApiException will be thrown.

\item status code : 200 | successful operation

\item return type : map(integer) 
\item response headers :

\tabular{ll}{
}
}

\strong{ GetOrderById } \emph{ Find purchase order by ID }
For valid response try integer IDs with value &lt;&#x3D; 5 or &gt; 10. Other values will generate exceptions

\itemize{
\item \emph{ @param } order_id integer
\item \emph{ @returnType } \link{Order} \cr

\item On encountering errors, an error of subclass ApiException will be thrown.

\item status code : 200 | successful operation

\item return type : Order 
\item response headers :

\tabular{ll}{
}
\item status code : 400 | Invalid ID supplied


\item response headers :

\tabular{ll}{
}
\item status code : 404 | Order not found


\item response headers :

\tabular{ll}{
}
}

\strong{ PlaceOrder } \emph{ Place an order for a pet }


\itemize{
\item \emph{ @param } order \link{Order}
\item \emph{ @returnType } \link{Order} \cr

\item On encountering errors, an error of subclass ApiException will be thrown.

\item status code : 200 | successful operation

\item return type : Order 
\item response headers :

\tabular{ll}{
}
\item status code : 400 | Invalid Order


\item response headers :

\tabular{ll}{
}
}

}
}

\examples{
\dontrun{
####################  DeleteOrder  ####################

library(petstore)
var.order_id <- 'order_id_example' # character | ID of the order that needs to be deleted

#Delete purchase order by ID
api.instance <- StoreApi$new()

result <- tryCatch(
            api.instance$DeleteOrder(var.order_id),
            ApiException = function(ex) ex
         )
# In case of error, print the error object
if(!is.null(result$ApiException)) {
  cat(result$ApiException$toString())
} else {
# response headers
response.headers <- result$response$headers
# response status code
response.status.code <- result$response$status_code
}


####################  GetInventory  ####################

library(petstore)

#Returns pet inventories by status
api.instance <- StoreApi$new()

#Configure API key authorization: api_key
api.instance$api_client$api_keys['api_key'] <- 'TODO_YOUR_API_KEY';

result <- tryCatch(
            api.instance$GetInventory(),
            ApiException = function(ex) ex
         )
# In case of error, print the error object
if(!is.null(result$ApiException)) {
  cat(result$ApiException$toString())
} else {
# deserialized response object
response.object <- result$content
# response headers
response.headers <- result$response$headers
# response status code
response.status.code <- result$response$status_code
}


####################  GetOrderById  ####################

library(petstore)
var.order_id <- 56 # integer | ID of pet that needs to be fetched

#Find purchase order by ID
api.instance <- StoreApi$new()

result <- tryCatch(
            api.instance$GetOrderById(var.order_id),
            ApiException = function(ex) ex
         )
# In case of error, print the error object
if(!is.null(result$ApiException)) {
  cat(result$ApiException$toString())
} else {
# deserialized response object
response.object <- result$content
# response headers
response.headers <- result$response$headers
# response status code
response.status.code <- result$response$status_code
}


####################  PlaceOrder  ####################

library(petstore)
var.order <- Order$new() # Order | order placed for purchasing the pet

#Place an order for a pet
api.instance <- StoreApi$new()

result <- tryCatch(
            api.instance$PlaceOrder(var.order),
            ApiException = function(ex) ex
         )
# In case of error, print the error object
if(!is.null(result$ApiException)) {
  cat(result$ApiException$toString())
} else {
# deserialized response object
response.object <- result$content
# response headers
response.headers <- result$response$headers
# response status code
response.status.code <- result$response$status_code
}


}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{api_client}}{Handles the client-server communication.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-StoreApi-new}{\code{StoreApi$new()}}
\item \href{#method-StoreApi-DeleteOrder}{\code{StoreApi$DeleteOrder()}}
\item \href{#method-StoreApi-DeleteOrderWithHttpInfo}{\code{StoreApi$DeleteOrderWithHttpInfo()}}
\item \href{#method-StoreApi-GetInventory}{\code{StoreApi$GetInventory()}}
\item \href{#method-StoreApi-GetInventoryWithHttpInfo}{\code{StoreApi$GetInventoryWithHttpInfo()}}
\item \href{#method-StoreApi-GetOrderById}{\code{StoreApi$GetOrderById()}}
\item \href{#method-StoreApi-GetOrderByIdWithHttpInfo}{\code{StoreApi$GetOrderByIdWithHttpInfo()}}
\item \href{#method-StoreApi-PlaceOrder}{\code{StoreApi$PlaceOrder()}}
\item \href{#method-StoreApi-PlaceOrderWithHttpInfo}{\code{StoreApi$PlaceOrderWithHttpInfo()}}
\item \href{#method-StoreApi-clone}{\code{StoreApi$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoreApi-new"></a>}}
\if{latex}{\out{\hypertarget{method-StoreApi-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new StoreApi.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoreApi$new(api_client)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api_client}}{An instance of API client.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoreApi-DeleteOrder"></a>}}
\if{latex}{\out{\hypertarget{method-StoreApi-DeleteOrder}{}}}
\subsection{Method \code{DeleteOrder()}}{
Delete purchase order by ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoreApi$DeleteOrder(order_id, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{order_id}}{ID of the order that needs to be deleted}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
void
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoreApi-DeleteOrderWithHttpInfo"></a>}}
\if{latex}{\out{\hypertarget{method-StoreApi-DeleteOrderWithHttpInfo}{}}}
\subsection{Method \code{DeleteOrderWithHttpInfo()}}{
Delete purchase order by ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoreApi$DeleteOrderWithHttpInfo(order_id, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{order_id}}{ID of the order that needs to be deleted}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
API response (void) with additional information such as HTTP status code, headers
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoreApi-GetInventory"></a>}}
\if{latex}{\out{\hypertarget{method-StoreApi-GetInventory}{}}}
\subsection{Method \code{GetInventory()}}{
Returns pet inventories by status
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoreApi$GetInventory(data_file = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_file}}{(optional) name of the data file to save the result}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
map(integer)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoreApi-GetInventoryWithHttpInfo"></a>}}
\if{latex}{\out{\hypertarget{method-StoreApi-GetInventoryWithHttpInfo}{}}}
\subsection{Method \code{GetInventoryWithHttpInfo()}}{
Returns pet inventories by status
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoreApi$GetInventoryWithHttpInfo(data_file = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_file}}{(optional) name of the data file to save the result}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
API response (map(integer)) with additional information such as HTTP status code, headers
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoreApi-GetOrderById"></a>}}
\if{latex}{\out{\hypertarget{method-StoreApi-GetOrderById}{}}}
\subsection{Method \code{GetOrderById()}}{
Find purchase order by ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoreApi$GetOrderById(order_id, data_file = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{order_id}}{ID of pet that needs to be fetched}

\item{\code{data_file}}{(optional) name of the data file to save the result}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Order
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoreApi-GetOrderByIdWithHttpInfo"></a>}}
\if{latex}{\out{\hypertarget{method-StoreApi-GetOrderByIdWithHttpInfo}{}}}
\subsection{Method \code{GetOrderByIdWithHttpInfo()}}{
Find purchase order by ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoreApi$GetOrderByIdWithHttpInfo(order_id, data_file = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{order_id}}{ID of pet that needs to be fetched}

\item{\code{data_file}}{(optional) name of the data file to save the result}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
API response (Order) with additional information such as HTTP status code, headers
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoreApi-PlaceOrder"></a>}}
\if{latex}{\out{\hypertarget{method-StoreApi-PlaceOrder}{}}}
\subsection{Method \code{PlaceOrder()}}{
Place an order for a pet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoreApi$PlaceOrder(order, data_file = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{order}}{order placed for purchasing the pet}

\item{\code{data_file}}{(optional) name of the data file to save the result}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Order
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoreApi-PlaceOrderWithHttpInfo"></a>}}
\if{latex}{\out{\hypertarget{method-StoreApi-PlaceOrderWithHttpInfo}{}}}
\subsection{Method \code{PlaceOrderWithHttpInfo()}}{
Place an order for a pet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoreApi$PlaceOrderWithHttpInfo(order, data_file = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{order}}{order placed for purchasing the pet}

\item{\code{data_file}}{(optional) name of the data file to save the result}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
API response (Order) with additional information such as HTTP status code, headers
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoreApi-clone"></a>}}
\if{latex}{\out{\hypertarget{method-StoreApi-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoreApi$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
