# R API client for petstore

This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project. By using the [OpenAPI spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 1.0.0
- Package version: 1.0.0
- Generator version: 7.20.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.RClientCodegen

## Installation

### Prerequisites

Install the dependencies

```R
install.packages("jsonlite")
install.packages("httr")
install.packages("base64enc")
```

### Build the package

```sh
git clone https://github.com/GIT_USER_ID/GIT_REPO_ID
cd GIT_REPO_ID
R CMD build .
R CMD check petstore_1.0.0.tar.gz --no-manual
R CMD INSTALL --preclean petstore_1.0.0.tar.gz
```

### Install the package

```R
install.packages("petstore")
```

To install directly from Github, use `devtools`:
```R
install.packages("devtools")
library(devtools)
install_github("GIT_USER_ID/GIT_REPO_ID")
```

To install the package from a local file:
```R
install.packages("petstore_1.0.0.tar.gz", repos = NULL, type = "source")
```

### Usage

```R
library(petstore)
```

### Reformat code

To reformat code using [styler](https://styler.r-lib.org/index.html), please run the following in the R console:

```R
install.packages("remotes")
remotes::install_github("r-lib/styler@v1.7.0.9003")
library("styler")
style_dir()
```

## Documentation for API Endpoints

All URIs are relative to *http://petstore.swagger.io/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*FakeApi* | [**add_pet_optional**](docs/FakeApi.md#add_pet_optional) | **POST** /fake/test_optional_body_parameter | Add a new pet to the store (optional body)
*FakeApi* | [**fake_data_file**](docs/FakeApi.md#fake_data_file) | **GET** /fake/data_file | test data_file to ensure it's escaped correctly
*FakeApi* | [**fake_path_array**](docs/FakeApi.md#fake_path_array) | **GET** /fake/path_array/{path_array}/testing | test array parameter in path
*FakeApi* | [**fake_regular_expression**](docs/FakeApi.md#fake_regular_expression) | **GET** /fake/regular_expression | test regular expression to ensure no exception
*FakeApi* | [**fake_set_query**](docs/FakeApi.md#fake_set_query) | **GET** /fake/set_query_parameter | test set query parameter
*PetApi* | [**add_pet**](docs/PetApi.md#add_pet) | **POST** /pet | Add a new pet to the store
*PetApi* | [**delete_pet**](docs/PetApi.md#delete_pet) | **DELETE** /pet/{petId} | Deletes a pet
*PetApi* | [**find_pets_by_status**](docs/PetApi.md#find_pets_by_status) | **GET** /pet/findByStatus | Finds Pets by status
*PetApi* | [**find_pets_by_tags**](docs/PetApi.md#find_pets_by_tags) | **GET** /pet/findByTags | Finds Pets by tags
*PetApi* | [**get_pet_by_id**](docs/PetApi.md#get_pet_by_id) | **GET** /pet/{petId} | Find pet by ID
*PetApi* | [**get_pet_by_id_streaming**](docs/PetApi.md#get_pet_by_id_streaming) | **GET** /pet/{petId}?streaming | Find pet by ID (streaming)
*PetApi* | [**test_header**](docs/PetApi.md#test_header) | **GET** /pet_header_test | Header test
*PetApi* | [**update_pet**](docs/PetApi.md#update_pet) | **PUT** /pet | Update an existing pet
*PetApi* | [**update_pet_with_form**](docs/PetApi.md#update_pet_with_form) | **POST** /pet/{petId} | Updates a pet in the store with form data
*PetApi* | [**upload_file**](docs/PetApi.md#upload_file) | **POST** /pet/{petId}/uploadImage | uploads an image
*StoreApi* | [**delete_order**](docs/StoreApi.md#delete_order) | **DELETE** /store/order/{orderId} | Delete purchase order by ID
*StoreApi* | [**get_inventory**](docs/StoreApi.md#get_inventory) | **GET** /store/inventory | Returns pet inventories by status
*StoreApi* | [**get_order_by_id**](docs/StoreApi.md#get_order_by_id) | **GET** /store/order/{orderId} | Find purchase order by ID
*StoreApi* | [**place_order**](docs/StoreApi.md#place_order) | **POST** /store/order | Place an order for a pet
*UserApi* | [**create_user**](docs/UserApi.md#create_user) | **POST** /user | Create user
*UserApi* | [**create_users_with_array_input**](docs/UserApi.md#create_users_with_array_input) | **POST** /user/createWithArray | Creates list of users with given input array
*UserApi* | [**create_users_with_list_input**](docs/UserApi.md#create_users_with_list_input) | **POST** /user/createWithList | Creates list of users with given input array
*UserApi* | [**delete_user**](docs/UserApi.md#delete_user) | **DELETE** /user/{username} | Delete user
*UserApi* | [**get_user_by_name**](docs/UserApi.md#get_user_by_name) | **GET** /user/{username} | Get user by user name
*UserApi* | [**login_user**](docs/UserApi.md#login_user) | **GET** /user/login | Logs user into the system
*UserApi* | [**logout_user**](docs/UserApi.md#logout_user) | **GET** /user/logout | Logs out current logged in user session
*UserApi* | [**update_user**](docs/UserApi.md#update_user) | **PUT** /user/{username} | Updated user


## Documentation for Models

 - [AllofTagApiResponse](docs/AllofTagApiResponse.md)
 - [Animal](docs/Animal.md)
 - [AnyOfPig](docs/AnyOfPig.md)
 - [AnyOfPrimitiveTypeTest](docs/AnyOfPrimitiveTypeTest.md)
 - [BasquePig](docs/BasquePig.md)
 - [Cat](docs/Cat.md)
 - [Category](docs/Category.md)
 - [DanishPig](docs/DanishPig.md)
 - [Date](docs/Date.md)
 - [Dog](docs/Dog.md)
 - [FormatTest](docs/FormatTest.md)
 - [JustModel](docs/JustModel.md)
 - [Mammal](docs/Mammal.md)
 - [ModelApiResponse](docs/ModelApiResponse.md)
 - [NestedOneOf](docs/NestedOneOf.md)
 - [OneOfPrimitiveTypeTest](docs/OneOfPrimitiveTypeTest.md)
 - [Order](docs/Order.md)
 - [Pet](docs/Pet.md)
 - [PetMap](docs/PetMap.md)
 - [Pig](docs/Pig.md)
 - [Special](docs/Special.md)
 - [Tag](docs/Tag.md)
 - [UpdatePetRequest](docs/UpdatePetRequest.md)
 - [User](docs/User.md)
 - [Whale](docs/Whale.md)
 - [Zebra](docs/Zebra.md)


## Documentation for Authorization


Authentication schemes defined for the API:
### http_auth

- **Type**: HTTP basic authentication

### BearerToken

- **Type**: Bearer authentication

### petstore_auth

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: http://petstore.swagger.io/api/oauth/dialog
- **Scopes**: 
  - `write:pets`: modify pets in your account
  - `read:pets`: read your pets

### api_key

- **Type**: API key
- **API key parameter name**: api_key
- **Location**: HTTP header


