#' OpenAPI Petstore
#'
#' This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
#'
#' The version of the OpenAPI document: 1.0.0
#' Generated by: https://openapi-generator.tech
#'
#' @docType class
#' @title Store operations
#' @description StoreApi
#' @format An \code{R6Class} generator object
#' @field api_client Handles the client-server communication.
#'
#' @examples
#' \dontrun{
#' ####################  delete_order  ####################
#'
#' library(petstore)
#' var_order_id <- "order_id_example" # character | ID of the order that needs to be deleted
#'
#' #Delete purchase order by ID
#' api_instance <- petstore_api$new()
#'
#' result <- tryCatch(
#'              
#'              api_instance$store_api$delete_order(var_order_id),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `delete_order`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' }#'
#' # This endpoint doesn't return data
#'
#'
#' ####################  get_inventory  ####################
#'
#' library(petstore)
#'
#' #Returns pet inventories by status
#' api_instance <- petstore_api$new()
#'
#' # Configure API key authorization: api_key
#' api_instance$api_client$api_keys["api_key"] <- Sys.getenv("API_KEY")
#'
#' result <- tryCatch(
#'              
#'              # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#'              # api_instance$store_api$get_inventory(data_file = "result.txt"),
#'              
#'              
#'              api_instance$store_api$get_inventory(),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `get_inventory`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' } else {
#'   # deserialized response object
#'   print("The response is ...")
#'   dput(result$toString())
#' }
#'
#'
#'
#' ####################  get_order_by_id  ####################
#'
#' library(petstore)
#' var_order_id <- 56 # integer | ID of pet that needs to be fetched
#'
#' #Find purchase order by ID
#' api_instance <- petstore_api$new()
#'
#' result <- tryCatch(
#'              
#'              # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#'              # api_instance$store_api$get_order_by_id(var_order_id, data_file = "result.txt"),
#'              
#'              
#'              api_instance$store_api$get_order_by_id(var_order_id),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `get_order_by_id`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' } else {
#'   # deserialized response object
#'   print("The response is ...")
#'   dput(result$toString())
#' }
#'
#'
#'
#' ####################  place_order  ####################
#'
#' library(petstore)
#' var_order <- Order$new(123, 123, 123, "shipDate_example", "placed", "complete_example") # Order | order placed for purchasing the pet
#'
#' #Place an order for a pet
#' api_instance <- petstore_api$new()
#'
#' result <- tryCatch(
#'              
#'              # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#'              # api_instance$store_api$place_order(var_order, data_file = "result.txt"),
#'              
#'              
#'              api_instance$store_api$place_order(var_order),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `place_order`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' } else {
#'   # deserialized response object
#'   print("The response is ...")
#'   dput(result$toString())
#' }
#'
#'
#'
#' }
#' @importFrom R6 R6Class
#' @importFrom base64enc base64encode
#' @importFrom rlang abort
#' @export
StoreApi <- R6::R6Class(
  "StoreApi",
  public = list(
    api_client = NULL,

    #' @description
    #' Initialize a new StoreApi.
    #'
    #' @param api_client An instance of API client.
    initialize = function(api_client) {
      if (!missing(api_client)) {
        self$api_client <- api_client
      } else {
        self$api_client <- ApiClient$new()
      }
    },

    #' @description
    #' Delete purchase order by ID
    #'
    #' @param order_id ID of the order that needs to be deleted
    #' @param ... Other optional arguments
    #'
    #' @return void
    delete_order = function(order_id, ...) {
      local_var_response <- self$delete_order_with_http_info(order_id, ...)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Delete purchase order by ID
    #'
    #' @param order_id ID of the order that needs to be deleted
    #' @param ... Other optional arguments
    #'
    #' @return API response (void) with additional information such as HTTP status code, headers
    delete_order_with_http_info = function(order_id, ...) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`order_id`)) {
        rlang::abort(message = "Missing required parameter `order_id`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `order_id`."))
      }

      if (!missing(`order_id`) && is.null(`order_id`)) {
        rlang::abort(message = "Invalid value for `order_id` when calling StoreApi$delete_order, `order_id` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `order_id` when calling StoreApi$delete_order, `order_id` is not nullable"))
      }

      local_var_url_path <- "/store/order/{orderId}"
      if (!missing(`order_id`)) {
        local_var_url_path <- gsub("\\{orderId\\}", URLencode(as.character(`order_id`), reserved = TRUE), local_var_url_path)
      }


      # The Accept request HTTP header
      local_var_accepts <- list()

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "DELETE",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        local_var_resp$content <- NULL
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' Returns pet inventories by status
    #'
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return map(integer)
    get_inventory = function(data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$get_inventory_with_http_info(data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Returns pet inventories by status
    #'
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (map(integer)) with additional information such as HTTP status code, headers
    get_inventory_with_http_info = function(data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      local_var_url_path <- "/store/inventory"
      # API key authentication
      if ("api_key" %in% names(self$api_client$api_keys) && nchar(self$api_client$api_keys["api_key"]) > 0) {
        header_params["api_key"] <- paste(unlist(self$api_client$api_keys["api_key"]), collapse = "")
      }

      # The Accept request HTTP header
      local_var_accepts <- list("application/json")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "map(integer)"),
          error = function(e) {
            rlang::abort(message = "Failed to deserialize response",
                         .subclass = "ApiException",
                         ApiException = ApiException$new(http_response = local_var_resp))
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' Find purchase order by ID
    #'
    #' @param order_id ID of pet that needs to be fetched
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return Order
    get_order_by_id = function(order_id, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$get_order_by_id_with_http_info(order_id, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Find purchase order by ID
    #'
    #' @param order_id ID of pet that needs to be fetched
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (Order) with additional information such as HTTP status code, headers
    get_order_by_id_with_http_info = function(order_id, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`order_id`)) {
        rlang::abort(message = "Missing required parameter `order_id`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `order_id`."))
      }

      if (!missing(`order_id`) && is.null(`order_id`)) {
        rlang::abort(message = "Invalid value for `order_id` when calling StoreApi$get_order_by_id, `order_id` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `order_id` when calling StoreApi$get_order_by_id, `order_id` is not nullable"))
      }
      if (!is.null(`order_id`) && `order_id` >  5) {
        rlang::abort(message = "Invalid value for `order_id` when calling StoreApi$get_order_by_id, must be smaller than or equal to 5.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Invalid value for `order_id` when calling StoreApi$get_order_by_id, must be smaller than or equal to 5."))
      }
      if (!is.null(`order_id`) && `order_id` <  1) {
        rlang::abort(message = "Invalid value for `order_id` when calling StoreApi$get_order_by_id, must be bigger than or equal to 1.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Invalid value for `order_id` when calling StoreApi$get_order_by_id, must be bigger than or equal to 1."))
      }

      local_var_url_path <- "/store/order/{orderId}"
      if (!missing(`order_id`)) {
        local_var_url_path <- gsub("\\{orderId\\}", URLencode(as.character(`order_id`), reserved = TRUE), local_var_url_path)
      }


      # The Accept request HTTP header
      local_var_accepts <- list("application/xml", "application/json")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "Order"),
          error = function(e) {
            rlang::abort(message = "Failed to deserialize response",
                         .subclass = "ApiException",
                         ApiException = ApiException$new(http_response = local_var_resp))
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' Place an order for a pet
    #'
    #' @param order order placed for purchasing the pet
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return Order
    place_order = function(order, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$place_order_with_http_info(order, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Place an order for a pet
    #'
    #' @param order order placed for purchasing the pet
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (Order) with additional information such as HTTP status code, headers
    place_order_with_http_info = function(order, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`order`)) {
        rlang::abort(message = "Missing required parameter `order`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `order`."))
      }

      if (!missing(`order`) && is.null(`order`)) {
        rlang::abort(message = "Invalid value for `order` when calling StoreApi$place_order, `order` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `order` when calling StoreApi$place_order, `order` is not nullable"))
      }

      if (!is.null(`order`)) {
        local_var_body <- `order`$toJSONString()
      } else {
        local_var_body <- NULL
      }

      local_var_url_path <- "/store/order"

      # The Accept request HTTP header
      local_var_accepts <- list("application/xml", "application/json")

      # The Content-Type representation header
      local_var_content_types <- list("application/json")

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "POST",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "Order"),
          error = function(e) {
            rlang::abort(message = "Failed to deserialize response",
                         .subclass = "ApiException",
                         ApiException = ApiException$new(http_response = local_var_resp))
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    }
  )
)
