#' OpenAPI Petstore
#'
#' This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
#'
#' The version of the OpenAPI document: 1.0.0
#' Generated by: https://openapi-generator.tech
#'
#' @docType class
#' @title Pet operations
#' @description PetApi
#' @format An \code{R6Class} generator object
#' @field api_client Handles the client-server communication.
#'
#' @examples
#' \dontrun{
#' ####################  add_pet  ####################
#'
#' library(petstore)
#' var_pet <- Pet$new("name_example", c("photoUrls_example"), 123, Category$new(123, "name_example"), c(Tag$new(123, "name_example")), "available") # Pet | Pet object that needs to be added to the store
#'
#' #Add a new pet to the store
#' api_instance <- petstore_api$new()
#'
#' # Configure HTTP basic authorization: http_auth
#' api_instance$api_client$username <- Sys.getenv("USERNAME")
#' api_instance$api_client$password <- Sys.getenv("PASSWORD")
#'
#' result <- tryCatch(
#'              
#'              # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#'              # api_instance$pet_api$add_pet(var_pet, data_file = "result.txt"),
#'              
#'              
#'              api_instance$pet_api$add_pet(var_pet),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `add_pet`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' } else {
#'   # deserialized response object
#'   print("The response is ...")
#'   dput(result$toString())
#' }
#'
#'
#'
#' ####################  delete_pet  ####################
#'
#' library(petstore)
#' var_pet_id <- 56 # integer | Pet id to delete
#' var_api_key <- "api_key_example" # character |  (Optional)
#'
#' #Deletes a pet
#' api_instance <- petstore_api$new()
#'
#' # Configure OAuth2 access token for authorization: petstore_auth
#' api_instance$api_client$access_token <- Sys.getenv("ACCESS_TOKEN")
#'
#' result <- tryCatch(
#'              
#'              api_instance$pet_api$delete_pet(var_pet_id, api_key = var_api_key),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `delete_pet`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' }#'
#' # This endpoint doesn't return data
#'
#'
#' ####################  find_pets_by_status  ####################
#'
#' library(petstore)
#' var_status <- c("available") # array[character] | Status values that need to be considered for filter
#'
#' #Finds Pets by status
#' api_instance <- petstore_api$new()
#'
#' # Configure OAuth2 access token for authorization: petstore_auth
#' api_instance$api_client$access_token <- Sys.getenv("ACCESS_TOKEN")
#'
#' result <- tryCatch(
#'              
#'              # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#'              # api_instance$pet_api$find_pets_by_status(var_status, data_file = "result.txt"),
#'              
#'              
#'              api_instance$pet_api$find_pets_by_status(var_status),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `find_pets_by_status`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' } else {
#'   # deserialized response object
#'   print("The response is ...")
#'   dput(result$toString())
#' }
#'
#'
#'
#' ####################  find_pets_by_tags  ####################
#'
#' library(petstore)
#' var_tags <- c("inner_example") # array[character] | Tags to filter by
#'
#' #Finds Pets by tags
#' api_instance <- petstore_api$new()
#'
#' result <- tryCatch(
#'              
#'              # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#'              # api_instance$pet_api$find_pets_by_tags(var_tags, data_file = "result.txt"),
#'              
#'              
#'              api_instance$pet_api$find_pets_by_tags(var_tags),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `find_pets_by_tags`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' } else {
#'   # deserialized response object
#'   print("The response is ...")
#'   dput(result$toString())
#' }
#'
#'
#'
#' ####################  get_pet_by_id  ####################
#'
#' library(petstore)
#' var_pet_id <- 56 # integer | ID of pet to return
#'
#' #Find pet by ID
#' api_instance <- petstore_api$new()
#'
#' # Configure HTTP bearer authorization: BearerToken
#' api_instance$api_client$bearer_token <- Sys.getenv("BEARER_TOKEN")
#'
#' result <- tryCatch(
#'              
#'              # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#'              # api_instance$pet_api$get_pet_by_id(var_pet_id, data_file = "result.txt"),
#'              
#'              
#'              api_instance$pet_api$get_pet_by_id(var_pet_id),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `get_pet_by_id`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' } else {
#'   # deserialized response object
#'   print("The response is ...")
#'   dput(result$toString())
#' }
#'
#'
#'
#' ####################  get_pet_by_id_streaming  ####################
#'
#' library(petstore)
#' var_pet_id <- 56 # integer | ID of pet to return
#'
#' #Find pet by ID (streaming)
#' api_instance <- petstore_api$new()
#'
#' # Configure API key authorization: api_key
#' api_instance$api_client$api_keys["api_key"] <- Sys.getenv("API_KEY")
#'
#' result <- tryCatch(
#'              
#'              # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#'              # api_instance$pet_api$get_pet_by_id_streaming(var_pet_id, data_file = "result.txt"),
#'              
#'              # this endpoint supports data streaming via a callback function using the optional `stream_callback` parameter, e.g.
#'              # api_instance$pet_api$get_pet_by_id_streaming(var_pet_id, stream_callback = function(x){ print(length(x)) }),
#'              
#'              
#'              api_instance$pet_api$get_pet_by_id_streaming(var_pet_id),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `get_pet_by_id_streaming`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' } else {
#'   # deserialized response object
#'   print("The response is ...")
#'   dput(result$toString())
#' }
#'
#'
#'
#' ####################  test_header  ####################
#'
#' library(petstore)
#' var_header_test_int <- 56 # integer | header test int
#'
#' #Header test
#' api_instance <- petstore_api$new()
#'
#' # Configure API key authorization: api_key
#' api_instance$api_client$api_keys["api_key"] <- Sys.getenv("API_KEY")
#'
#' result <- tryCatch(
#'              
#'              # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#'              # api_instance$pet_api$test_header(var_header_test_int, data_file = "result.txt"),
#'              
#'              # this endpoint supports data streaming via a callback function using the optional `stream_callback` parameter, e.g.
#'              # api_instance$pet_api$test_header(var_header_test_int, stream_callback = function(x){ print(length(x)) }),
#'              
#'              
#'              api_instance$pet_api$test_header(var_header_test_int),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `test_header`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' } else {
#'   # deserialized response object
#'   print("The response is ...")
#'   dput(result$toString())
#' }
#'
#'
#'
#' ####################  update_pet  ####################
#'
#' library(petstore)
#' var_pet <- Pet$new("name_example", c("photoUrls_example"), 123, Category$new(123, "name_example"), c(Tag$new(123, "name_example")), "available") # Pet | Pet object that needs to be added to the store
#'
#' #Update an existing pet
#' api_instance <- petstore_api$new()
#'
#' # Configure OAuth2 access token for authorization: petstore_auth
#' api_instance$api_client$access_token <- Sys.getenv("ACCESS_TOKEN")
#'
#' result <- tryCatch(
#'              
#'              # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#'              # api_instance$pet_api$update_pet(var_pet, data_file = "result.txt"),
#'              
#'              
#'              api_instance$pet_api$update_pet(var_pet),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `update_pet`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' } else {
#'   # deserialized response object
#'   print("The response is ...")
#'   dput(result$toString())
#' }
#'
#'
#'
#' ####################  update_pet_with_form  ####################
#'
#' library(petstore)
#' var_pet_id <- 56 # integer | ID of pet that needs to be updated
#' var_name <- "name_example" # character | Updated name of the pet (Optional)
#' var_status <- "status_example" # character | Updated status of the pet (Optional)
#'
#' #Updates a pet in the store with form data
#' api_instance <- petstore_api$new()
#'
#' result <- tryCatch(
#'              
#'              api_instance$pet_api$update_pet_with_form(var_pet_id, name = var_name, status = var_status),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `update_pet_with_form`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' }#'
#' # This endpoint doesn't return data
#'
#'
#' ####################  upload_file  ####################
#'
#' library(petstore)
#' var_pet_id <- 56 # integer | ID of pet to update
#' var_additional_metadata <- "additional_metadata_example" # character | Additional data to pass to server (Optional)
#' var_file <- File.new('/path/to/file') # data.frame | file to upload (Optional)
#'
#' #uploads an image
#' api_instance <- petstore_api$new()
#'
#' # Configure OAuth2 access token for authorization: petstore_auth
#' api_instance$api_client$access_token <- Sys.getenv("ACCESS_TOKEN")
#'
#' result <- tryCatch(
#'              
#'              # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#'              # api_instance$pet_api$upload_file(var_pet_id, additional_metadata = var_additional_metadata, file = var_file, data_file = "result.txt"),
#'              
#'              
#'              api_instance$pet_api$upload_file(var_pet_id, additional_metadata = var_additional_metadata, file = var_file),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `upload_file`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' } else {
#'   # deserialized response object
#'   print("The response is ...")
#'   dput(result$toString())
#' }
#'
#'
#'
#' }
#' @importFrom R6 R6Class
#' @importFrom base64enc base64encode
#' @importFrom rlang abort
#' @export
PetApi <- R6::R6Class(
  "PetApi",
  public = list(
    api_client = NULL,

    #' @description
    #' Initialize a new PetApi.
    #'
    #' @param api_client An instance of API client.
    initialize = function(api_client) {
      if (!missing(api_client)) {
        self$api_client <- api_client
      } else {
        self$api_client <- ApiClient$new()
      }
    },

    #' @description
    #' Add a new pet to the store
    #'
    #' @param pet Pet object that needs to be added to the store
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return Pet
    add_pet = function(pet, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$add_pet_with_http_info(pet, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Add a new pet to the store
    #'
    #' @param pet Pet object that needs to be added to the store
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (Pet) with additional information such as HTTP status code, headers
    add_pet_with_http_info = function(pet, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`pet`)) {
        rlang::abort(message = "Missing required parameter `pet`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `pet`."))
      }

      if (!missing(`pet`) && is.null(`pet`)) {
        rlang::abort(message = "Invalid value for `pet` when calling PetApi$add_pet, `pet` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `pet` when calling PetApi$add_pet, `pet` is not nullable"))
      }

      if (!is.null(`pet`)) {
        local_var_body <- `pet`$toJSONString()
      } else {
        local_var_body <- NULL
      }

      local_var_url_path <- "/pet"
      # HTTP basic auth
      if (!is.null(self$api_client$username) || !is.null(self$api_client$password)) {
        header_params["Authorization"] <- paste("Basic", base64enc::base64encode(charToRaw(paste(self$api_client$username, self$api_client$password, sep = ":"))))
      }

      # The Accept request HTTP header
      local_var_accepts <- list("application/xml", "application/json")

      # The Content-Type representation header
      local_var_content_types <- list("application/json", "application/xml", "multipart/related")

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "POST",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "Pet"),
          error = function(e) {
            rlang::abort(message = "Failed to deserialize response",
                         .subclass = "ApiException",
                         ApiException = ApiException$new(http_response = local_var_resp))
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' Deletes a pet
    #'
    #' @param pet_id Pet id to delete
    #' @param api_key (optional) No description
    #' @param ... Other optional arguments
    #'
    #' @return void
    delete_pet = function(pet_id, api_key = NULL, ...) {
      local_var_response <- self$delete_pet_with_http_info(pet_id, api_key, ...)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Deletes a pet
    #'
    #' @param pet_id Pet id to delete
    #' @param api_key (optional) No description
    #' @param ... Other optional arguments
    #'
    #' @return API response (void) with additional information such as HTTP status code, headers
    delete_pet_with_http_info = function(pet_id, api_key = NULL, ...) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`pet_id`)) {
        rlang::abort(message = "Missing required parameter `pet_id`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `pet_id`."))
      }

      if (!missing(`pet_id`) && is.null(`pet_id`)) {
        rlang::abort(message = "Invalid value for `pet_id` when calling PetApi$delete_pet, `pet_id` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `pet_id` when calling PetApi$delete_pet, `pet_id` is not nullable"))
      }

      if (!missing(`api_key`) && is.null(`api_key`)) {
        rlang::abort(message = "Invalid value for `api_key` when calling PetApi$delete_pet, `api_key` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `api_key` when calling PetApi$delete_pet, `api_key` is not nullable"))
      }

      header_params["api_key"] <- `api_key`

      local_var_url_path <- "/pet/{petId}"
      if (!missing(`pet_id`)) {
        local_var_url_path <- gsub("\\{petId\\}", URLencode(as.character(`pet_id`), reserved = TRUE), local_var_url_path)
      }

      # OAuth-related settings
      is_oauth <- TRUE
      oauth_scopes <- "write:pets read:pets"

      # The Accept request HTTP header
      local_var_accepts <- list()

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "DELETE",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        local_var_resp$content <- NULL
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' Finds Pets by status
    #'
    #' @param status Status values that need to be considered for filter
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return array[Pet]
    find_pets_by_status = function(status, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$find_pets_by_status_with_http_info(status, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Finds Pets by status
    #'
    #' @param status Status values that need to be considered for filter
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (array[Pet]) with additional information such as HTTP status code, headers
    find_pets_by_status_with_http_info = function(status, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`status`)) {
        rlang::abort(message = "Missing required parameter `status`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `status`."))
      }

      if (!missing(`status`) && is.null(`status`)) {
        rlang::abort(message = "Invalid value for `status` when calling PetApi$find_pets_by_status, `status` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `status` when calling PetApi$find_pets_by_status, `status` is not nullable"))
      }

      # explore
      for (query_item in `status`) {
        # validate enum values
        if (!is.null(query_item) && !(query_item %in% c("available", "pending", "sold"))) {
          rlang::abort(message = "Invalid value for `status` when calling PetApi$find_pets_by_status. Must be [available, pending, sold].",
                       .subclass = "ApiException",
                       ApiException = ApiException$new(status = 0,
                                                       reason = "Invalid value for `status` when calling PetApi$find_pets_by_status. Must be [available, pending, sold]."))
        }
        query_params[["status"]] <- c(query_params[["status"]], list(`status` = query_item))
      }

      local_var_url_path <- "/pet/findByStatus"
      # OAuth-related settings
      is_oauth <- TRUE
      oauth_scopes <- "read:pets"

      # The Accept request HTTP header
      local_var_accepts <- list("application/xml", "application/json")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "array[Pet]"),
          error = function(e) {
            rlang::abort(message = "Failed to deserialize response",
                         .subclass = "ApiException",
                         ApiException = ApiException$new(http_response = local_var_resp))
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' Finds Pets by tags
    #'
    #' @param tags Tags to filter by
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return array[Pet]
    find_pets_by_tags = function(tags, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$find_pets_by_tags_with_http_info(tags, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Finds Pets by tags
    #'
    #' @param tags Tags to filter by
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (array[Pet]) with additional information such as HTTP status code, headers
    find_pets_by_tags_with_http_info = function(tags, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`tags`)) {
        rlang::abort(message = "Missing required parameter `tags`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `tags`."))
      }

      if (!missing(`tags`) && is.null(`tags`)) {
        rlang::abort(message = "Invalid value for `tags` when calling PetApi$find_pets_by_tags, `tags` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `tags` when calling PetApi$find_pets_by_tags, `tags` is not nullable"))
      }

      # no explore
      query_params[["tags"]] <- I(paste(lapply(`tags`, URLencode, reserved = TRUE), collapse = ","))

      local_var_url_path <- "/pet/findByTags"

      # The Accept request HTTP header
      local_var_accepts <- list("application/xml", "application/json")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "array[Pet]"),
          error = function(e) {
            rlang::abort(message = "Failed to deserialize response",
                         .subclass = "ApiException",
                         ApiException = ApiException$new(http_response = local_var_resp))
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' Find pet by ID
    #'
    #' @param pet_id ID of pet to return
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return Pet
    get_pet_by_id = function(pet_id, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$get_pet_by_id_with_http_info(pet_id, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Find pet by ID
    #'
    #' @param pet_id ID of pet to return
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (Pet) with additional information such as HTTP status code, headers
    get_pet_by_id_with_http_info = function(pet_id, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`pet_id`)) {
        rlang::abort(message = "Missing required parameter `pet_id`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `pet_id`."))
      }

      if (!missing(`pet_id`) && is.null(`pet_id`)) {
        rlang::abort(message = "Invalid value for `pet_id` when calling PetApi$get_pet_by_id, `pet_id` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `pet_id` when calling PetApi$get_pet_by_id, `pet_id` is not nullable"))
      }

      local_var_url_path <- "/pet/{petId}"
      if (!missing(`pet_id`)) {
        local_var_url_path <- gsub("\\{petId\\}", URLencode(as.character(`pet_id`), reserved = TRUE), local_var_url_path)
      }

      # Bearer token
      if (!is.null(self$api_client$bearer_token)) {
        header_params["Authorization"] <- paste("Bearer", self$api_client$bearer_token, sep = " ")
      }

      # The Accept request HTTP header
      local_var_accepts <- list("application/xml", "application/json")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "Pet"),
          error = function(e) {
            rlang::abort(message = "Failed to deserialize response",
                         .subclass = "ApiException",
                         ApiException = ApiException$new(http_response = local_var_resp))
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' Find pet by ID (streaming)
    #'
    #' @param pet_id ID of pet to return
    #' @param stream_callback (optional) callback function to process the data stream
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return Pet
    get_pet_by_id_streaming = function(pet_id, stream_callback = NULL, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$get_pet_by_id_streaming_with_http_info(pet_id, stream_callback = stream_callback, data_file = data_file, ..., .parse = .parse)
      if (typeof(stream_callback) == "closure") { # return void if streaming is enabled
        return(invisible(NULL))
      }
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Find pet by ID (streaming)
    #'
    #' @param pet_id ID of pet to return
    #' @param stream_callback (optional) callback function to process the data stream
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (Pet) with additional information such as HTTP status code, headers
    get_pet_by_id_streaming_with_http_info = function(pet_id, stream_callback = NULL, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`pet_id`)) {
        rlang::abort(message = "Missing required parameter `pet_id`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `pet_id`."))
      }

      if (!missing(`pet_id`) && is.null(`pet_id`)) {
        rlang::abort(message = "Invalid value for `pet_id` when calling PetApi$get_pet_by_id_streaming, `pet_id` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `pet_id` when calling PetApi$get_pet_by_id_streaming, `pet_id` is not nullable"))
      }

      local_var_url_path <- "/pet/{petId}?streaming"
      if (!missing(`pet_id`)) {
        local_var_url_path <- gsub("\\{petId\\}", URLencode(as.character(`pet_id`), reserved = TRUE), local_var_url_path)
      }

      # API key authentication
      if ("api_key" %in% names(self$api_client$api_keys) && nchar(self$api_client$api_keys["api_key"]) > 0) {
        header_params["api_key"] <- paste(unlist(self$api_client$api_keys["api_key"]), collapse = "")
      }

      # The Accept request HTTP header
      local_var_accepts <- list("application/xml", "application/json")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 stream_callback = stream_callback,
                                 ...)

      if (typeof(stream_callback) == "closure") { # return void if streaming is enabled
        return(invisible(NULL))
      }

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "Pet"),
          error = function(e) {
            rlang::abort(message = "Failed to deserialize response",
                         .subclass = "ApiException",
                         ApiException = ApiException$new(http_response = local_var_resp))
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' Header test
    #'
    #' @param header_test_int header test int
    #' @param stream_callback (optional) callback function to process the data stream
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return Pet
    test_header = function(header_test_int, stream_callback = NULL, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$test_header_with_http_info(header_test_int, stream_callback = stream_callback, data_file = data_file, ..., .parse = .parse)
      if (typeof(stream_callback) == "closure") { # return void if streaming is enabled
        return(invisible(NULL))
      }
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Header test
    #'
    #' @param header_test_int header test int
    #' @param stream_callback (optional) callback function to process the data stream
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (Pet) with additional information such as HTTP status code, headers
    test_header_with_http_info = function(header_test_int, stream_callback = NULL, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`header_test_int`)) {
        rlang::abort(message = "Missing required parameter `header_test_int`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `header_test_int`."))
      }

      if (!missing(`header_test_int`) && is.null(`header_test_int`)) {
        rlang::abort(message = "Invalid value for `header_test_int` when calling PetApi$test_header, `header_test_int` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `header_test_int` when calling PetApi$test_header, `header_test_int` is not nullable"))
      }

      header_params["header_test_int"] <- `header_test_int`

      local_var_url_path <- "/pet_header_test"
      # API key authentication
      if ("api_key" %in% names(self$api_client$api_keys) && nchar(self$api_client$api_keys["api_key"]) > 0) {
        header_params["api_key"] <- paste(unlist(self$api_client$api_keys["api_key"]), collapse = "")
      }

      # The Accept request HTTP header
      local_var_accepts <- list("application/xml", "application/json")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 stream_callback = stream_callback,
                                 ...)

      if (typeof(stream_callback) == "closure") { # return void if streaming is enabled
        return(invisible(NULL))
      }

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "Pet"),
          error = function(e) {
            rlang::abort(message = "Failed to deserialize response",
                         .subclass = "ApiException",
                         ApiException = ApiException$new(http_response = local_var_resp))
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' Update an existing pet
    #'
    #' @param pet Pet object that needs to be added to the store
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return Pet
    update_pet = function(pet, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$update_pet_with_http_info(pet, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Update an existing pet
    #'
    #' @param pet Pet object that needs to be added to the store
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (Pet) with additional information such as HTTP status code, headers
    update_pet_with_http_info = function(pet, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`pet`)) {
        rlang::abort(message = "Missing required parameter `pet`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `pet`."))
      }

      if (!missing(`pet`) && is.null(`pet`)) {
        rlang::abort(message = "Invalid value for `pet` when calling PetApi$update_pet, `pet` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `pet` when calling PetApi$update_pet, `pet` is not nullable"))
      }

      if (!is.null(`pet`)) {
        local_var_body <- `pet`$toJSONString()
      } else {
        local_var_body <- NULL
      }

      local_var_url_path <- "/pet"
      # OAuth-related settings
      is_oauth <- TRUE
      oauth_scopes <- "write:pets read:pets"

      # The Accept request HTTP header
      local_var_accepts <- list("application/xml", "application/json")

      # The Content-Type representation header
      local_var_content_types <- list("application/json", "application/xml", "multipart/related")

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "PUT",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "Pet"),
          error = function(e) {
            rlang::abort(message = "Failed to deserialize response",
                         .subclass = "ApiException",
                         ApiException = ApiException$new(http_response = local_var_resp))
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' Updates a pet in the store with form data
    #'
    #' @param pet_id ID of pet that needs to be updated
    #' @param name (optional) Updated name of the pet
    #' @param status (optional) Updated status of the pet
    #' @param ... Other optional arguments
    #'
    #' @return void
    update_pet_with_form = function(pet_id, name = NULL, status = NULL, ...) {
      local_var_response <- self$update_pet_with_form_with_http_info(pet_id, name, status, ...)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Updates a pet in the store with form data
    #'
    #' @param pet_id ID of pet that needs to be updated
    #' @param name (optional) Updated name of the pet
    #' @param status (optional) Updated status of the pet
    #' @param ... Other optional arguments
    #'
    #' @return API response (void) with additional information such as HTTP status code, headers
    update_pet_with_form_with_http_info = function(pet_id, name = NULL, status = NULL, ...) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`pet_id`)) {
        rlang::abort(message = "Missing required parameter `pet_id`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `pet_id`."))
      }

      if (!missing(`pet_id`) && is.null(`pet_id`)) {
        rlang::abort(message = "Invalid value for `pet_id` when calling PetApi$update_pet_with_form, `pet_id` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `pet_id` when calling PetApi$update_pet_with_form, `pet_id` is not nullable"))
      }

      if (!missing(`name`) && is.null(`name`)) {
        rlang::abort(message = "Invalid value for `name` when calling PetApi$update_pet_with_form, `name` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `name` when calling PetApi$update_pet_with_form, `name` is not nullable"))
      }

      if (!missing(`status`) && is.null(`status`)) {
        rlang::abort(message = "Invalid value for `status` when calling PetApi$update_pet_with_form, `status` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `status` when calling PetApi$update_pet_with_form, `status` is not nullable"))
      }

      form_params["name"] <- `name`
      form_params["status"] <- `status`
      local_var_url_path <- "/pet/{petId}"
      if (!missing(`pet_id`)) {
        local_var_url_path <- gsub("\\{petId\\}", URLencode(as.character(`pet_id`), reserved = TRUE), local_var_url_path)
      }


      # The Accept request HTTP header
      local_var_accepts <- list()

      # The Content-Type representation header
      local_var_content_types <- list("application/x-www-form-urlencoded")

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "POST",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        local_var_resp$content <- NULL
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' uploads an image
    #'
    #' @param pet_id ID of pet to update
    #' @param additional_metadata (optional) Additional data to pass to server
    #' @param file (optional) file to upload
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return ModelApiResponse
    upload_file = function(pet_id, additional_metadata = NULL, file = NULL, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$upload_file_with_http_info(pet_id, additional_metadata, file, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' uploads an image
    #'
    #' @param pet_id ID of pet to update
    #' @param additional_metadata (optional) Additional data to pass to server
    #' @param file (optional) file to upload
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (ModelApiResponse) with additional information such as HTTP status code, headers
    upload_file_with_http_info = function(pet_id, additional_metadata = NULL, file = NULL, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`pet_id`)) {
        rlang::abort(message = "Missing required parameter `pet_id`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `pet_id`."))
      }

      if (!missing(`pet_id`) && is.null(`pet_id`)) {
        rlang::abort(message = "Invalid value for `pet_id` when calling PetApi$upload_file, `pet_id` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `pet_id` when calling PetApi$upload_file, `pet_id` is not nullable"))
      }

      if (!missing(`additional_metadata`) && is.null(`additional_metadata`)) {
        rlang::abort(message = "Invalid value for `additional_metadata` when calling PetApi$upload_file, `additional_metadata` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `additional_metadata` when calling PetApi$upload_file, `additional_metadata` is not nullable"))
      }

      if (!missing(`file`) && is.null(`file`)) {
        rlang::abort(message = "Invalid value for `file` when calling PetApi$upload_file, `file` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `file` when calling PetApi$upload_file, `file` is not nullable"))
      }

      form_params["additionalMetadata"] <- `additional_metadata`
      file_params[["file"]] <- curl::form_file(`file`)
      local_var_url_path <- "/pet/{petId}/uploadImage"
      if (!missing(`pet_id`)) {
        local_var_url_path <- gsub("\\{petId\\}", URLencode(as.character(`pet_id`), reserved = TRUE), local_var_url_path)
      }

      # OAuth-related settings
      is_oauth <- TRUE
      oauth_scopes <- "write:pets read:pets"

      # The Accept request HTTP header
      local_var_accepts <- list("application/json")

      # The Content-Type representation header
      local_var_content_types <- list("multipart/form-data")

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "POST",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "ModelApiResponse"),
          error = function(e) {
            rlang::abort(message = "Failed to deserialize response",
                         .subclass = "ApiException",
                         ApiException = ApiException$new(http_response = local_var_resp))
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    }
  )
)
