#' OpenAPI Petstore
#'
#' This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
#'
#' The version of the OpenAPI document: 1.0.0
#' Generated by: https://openapi-generator.tech
#'
#' @docType class
#' @title Fake operations
#' @description FakeApi
#' @format An \code{R6Class} generator object
#' @field api_client Handles the client-server communication.
#'
#' @examples
#' \dontrun{
#' ####################  add_pet_optional  ####################
#'
#' library(petstore)
#' var_pet <- Pet$new("name_example", c("photoUrls_example"), 123, Category$new(123, "name_example"), c(Tag$new(123, "name_example")), "available") # Pet | Pet object that needs to be added to the store (Optional)
#'
#' #Add a new pet to the store (optional body)
#' api_instance <- petstore_api$new()
#'
#' # Configure HTTP basic authorization: http_auth
#' api_instance$api_client$username <- Sys.getenv("USERNAME")
#' api_instance$api_client$password <- Sys.getenv("PASSWORD")
#'
#' result <- tryCatch(
#'              
#'              # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#'              # api_instance$fake_api$add_pet_optional(pet = var_pet, data_file = "result.txt"),
#'              
#'              
#'              api_instance$fake_api$add_pet_optional(pet = var_pet),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `add_pet_optional`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' } else {
#'   # deserialized response object
#'   print("The response is ...")
#'   dput(result$toString())
#' }
#'
#'
#'
#' ####################  fake_data_file  ####################
#'
#' library(petstore)
#' var_dummy <- "dummy_example" # character | dummy required parameter
#' var_var_data_file <- "var_data_file_example" # character | header data file (Optional)
#'
#' #test data_file to ensure it's escaped correctly
#' api_instance <- petstore_api$new()
#'
#' result <- tryCatch(
#'              
#'              # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#'              # api_instance$fake_api$fake_data_file(var_dummy, var_data_file = var_var_data_file, data_file = "result.txt"),
#'              
#'              
#'              api_instance$fake_api$fake_data_file(var_dummy, var_data_file = var_var_data_file),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `fake_data_file`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' } else {
#'   # deserialized response object
#'   print("The response is ...")
#'   dput(result$toString())
#' }
#'
#'
#'
#' ####################  fake_path_array  ####################
#'
#' library(petstore)
#' var_path_array <- c("inner_example") # array[character] | dummy path parameter
#'
#' #test array parameter in path
#' api_instance <- petstore_api$new()
#'
#' result <- tryCatch(
#'              
#'              api_instance$fake_api$fake_path_array(var_path_array),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `fake_path_array`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' }#'
#' # This endpoint doesn't return data
#'
#'
#' ####################  fake_regular_expression  ####################
#'
#' library(petstore)
#' var_reg_exp_test <- "reg_exp_test_example" # character | dummy required parameter
#'
#' #test regular expression to ensure no exception
#' api_instance <- petstore_api$new()
#'
#' result <- tryCatch(
#'              
#'              api_instance$fake_api$fake_regular_expression(var_reg_exp_test),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `fake_regular_expression`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' }#'
#' # This endpoint doesn't return data
#'
#'
#' ####################  fake_set_query  ####################
#'
#' library(petstore)
#' var_set_dummy <- c("inner_example") # set[character] | set query
#' var_array_dummy <- c("inner_example") # array[character] | array query
#'
#' #test set query parameter
#' api_instance <- petstore_api$new()
#'
#' result <- tryCatch(
#'              
#'              api_instance$fake_api$fake_set_query(var_set_dummy, var_array_dummy),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `fake_set_query`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' }#'
#' # This endpoint doesn't return data
#'
#'
#' }
#' @importFrom R6 R6Class
#' @importFrom base64enc base64encode
#' @importFrom rlang abort
#' @export
FakeApi <- R6::R6Class(
  "FakeApi",
  public = list(
    api_client = NULL,

    #' @description
    #' Initialize a new FakeApi.
    #'
    #' @param api_client An instance of API client.
    initialize = function(api_client) {
      if (!missing(api_client)) {
        self$api_client <- api_client
      } else {
        self$api_client <- ApiClient$new()
      }
    },

    #' @description
    #' Add a new pet to the store (optional body)
    #'
    #' @param pet (optional) Pet object that needs to be added to the store
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return Pet
    add_pet_optional = function(pet = NULL, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$add_pet_optional_with_http_info(pet, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Add a new pet to the store (optional body)
    #'
    #' @param pet (optional) Pet object that needs to be added to the store
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (Pet) with additional information such as HTTP status code, headers
    add_pet_optional_with_http_info = function(pet = NULL, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (!missing(`pet`) && is.null(`pet`)) {
        rlang::abort(message = "Invalid value for `pet` when calling FakeApi$add_pet_optional, `pet` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `pet` when calling FakeApi$add_pet_optional, `pet` is not nullable"))
      }

      if (!is.null(`pet`)) {
        local_var_body <- `pet`$toJSONString()
      } else {
        local_var_body <- NULL
      }

      local_var_url_path <- "/fake/test_optional_body_parameter"
      # HTTP basic auth
      if (!is.null(self$api_client$username) || !is.null(self$api_client$password)) {
        header_params["Authorization"] <- paste("Basic", base64enc::base64encode(charToRaw(paste(self$api_client$username, self$api_client$password, sep = ":"))))
      }

      # The Accept request HTTP header
      local_var_accepts <- list("application/xml", "application/json")

      # The Content-Type representation header
      local_var_content_types <- list("application/json", "application/xml", "multipart/related")

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "POST",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "Pet"),
          error = function(e) {
            rlang::abort(message = "Failed to deserialize response",
                         .subclass = "ApiException",
                         ApiException = ApiException$new(http_response = local_var_resp))
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' test data_file to ensure it's escaped correctly
    #'
    #' @param dummy dummy required parameter
    #' @param var_data_file (optional) header data file
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return User
    fake_data_file = function(dummy, var_data_file = NULL, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$fake_data_file_with_http_info(dummy, var_data_file, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' test data_file to ensure it's escaped correctly
    #'
    #' @param dummy dummy required parameter
    #' @param var_data_file (optional) header data file
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (User) with additional information such as HTTP status code, headers
    fake_data_file_with_http_info = function(dummy, var_data_file = NULL, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`dummy`)) {
        rlang::abort(message = "Missing required parameter `dummy`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `dummy`."))
      }

      if (!missing(`dummy`) && is.null(`dummy`)) {
        rlang::abort(message = "Invalid value for `dummy` when calling FakeApi$fake_data_file, `dummy` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `dummy` when calling FakeApi$fake_data_file, `dummy` is not nullable"))
      }

      if (!missing(`var_data_file`) && is.null(`var_data_file`)) {
        rlang::abort(message = "Invalid value for `var_data_file` when calling FakeApi$fake_data_file, `var_data_file` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `var_data_file` when calling FakeApi$fake_data_file, `var_data_file` is not nullable"))
      }

      header_params["dummy"] <- `dummy`

      header_params["data_file"] <- `var_data_file`

      local_var_url_path <- "/fake/data_file"

      # The Accept request HTTP header
      local_var_accepts <- list("application/xml", "application/json")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "User"),
          error = function(e) {
            rlang::abort(message = "Failed to deserialize response",
                         .subclass = "ApiException",
                         ApiException = ApiException$new(http_response = local_var_resp))
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' test array parameter in path
    #'
    #' @param path_array dummy path parameter
    #' @param ... Other optional arguments
    #'
    #' @return void
    fake_path_array = function(path_array, ...) {
      local_var_response <- self$fake_path_array_with_http_info(path_array, ...)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' test array parameter in path
    #'
    #' @param path_array dummy path parameter
    #' @param ... Other optional arguments
    #'
    #' @return API response (void) with additional information such as HTTP status code, headers
    fake_path_array_with_http_info = function(path_array, ...) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`path_array`)) {
        rlang::abort(message = "Missing required parameter `path_array`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `path_array`."))
      }

      if (!missing(`path_array`) && is.null(`path_array`)) {
        rlang::abort(message = "Invalid value for `path_array` when calling FakeApi$fake_path_array, `path_array` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `path_array` when calling FakeApi$fake_path_array, `path_array` is not nullable"))
      }

      local_var_url_path <- "/fake/path_array/{path_array}/testing"
      if (!missing(`path_array`)) {
        local_var_url_path <- gsub("\\{path_array\\}", paste(URLencode(as.character(`path_array`), reserved = TRUE), collapse= ",", sep=""), local_var_url_path)
      }


      # The Accept request HTTP header
      local_var_accepts <- list()

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        local_var_resp$content <- NULL
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' test regular expression to ensure no exception
    #'
    #' @param reg_exp_test dummy required parameter
    #' @param ... Other optional arguments
    #'
    #' @return void
    fake_regular_expression = function(reg_exp_test, ...) {
      local_var_response <- self$fake_regular_expression_with_http_info(reg_exp_test, ...)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' test regular expression to ensure no exception
    #'
    #' @param reg_exp_test dummy required parameter
    #' @param ... Other optional arguments
    #'
    #' @return API response (void) with additional information such as HTTP status code, headers
    fake_regular_expression_with_http_info = function(reg_exp_test, ...) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`reg_exp_test`)) {
        rlang::abort(message = "Missing required parameter `reg_exp_test`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `reg_exp_test`."))
      }

      if (!missing(`reg_exp_test`) && is.null(`reg_exp_test`)) {
        rlang::abort(message = "Invalid value for `reg_exp_test` when calling FakeApi$fake_regular_expression, `reg_exp_test` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `reg_exp_test` when calling FakeApi$fake_regular_expression, `reg_exp_test` is not nullable"))
      }
      if (!is.null(`reg_exp_test`) && !stringr::str_detect(`reg_exp_test`, "^[A-Za-z0-9_]{1,15}$")) {
        rlang::abort(message = "Invalid value for `reg_exp_test` when calling FakeApi$fake_regular_expression, must conform to the pattern ^[A-Za-z0-9_]{1,15}$.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Invalid value for `reg_exp_test` when calling FakeApi$fake_regular_expression, must conform to the pattern ^[A-Za-z0-9_]{1,15}$."))
      }

      header_params["reg_exp_test"] <- `reg_exp_test`

      local_var_url_path <- "/fake/regular_expression"

      # The Accept request HTTP header
      local_var_accepts <- list()

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        local_var_resp$content <- NULL
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' test set query parameter
    #'
    #' @param set_dummy set query
    #' @param array_dummy array query
    #' @param ... Other optional arguments
    #'
    #' @return void
    fake_set_query = function(set_dummy, array_dummy, ...) {
      local_var_response <- self$fake_set_query_with_http_info(set_dummy, array_dummy, ...)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' test set query parameter
    #'
    #' @param set_dummy set query
    #' @param array_dummy array query
    #' @param ... Other optional arguments
    #'
    #' @return API response (void) with additional information such as HTTP status code, headers
    fake_set_query_with_http_info = function(set_dummy, array_dummy, ...) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`set_dummy`)) {
        rlang::abort(message = "Missing required parameter `set_dummy`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `set_dummy`."))
      }

      if (missing(`array_dummy`)) {
        rlang::abort(message = "Missing required parameter `array_dummy`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `array_dummy`."))
      }

      if (!missing(`set_dummy`) && is.null(`set_dummy`)) {
        rlang::abort(message = "Invalid value for `set_dummy` when calling FakeApi$fake_set_query, `set_dummy` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `set_dummy` when calling FakeApi$fake_set_query, `set_dummy` is not nullable"))
      }

      if (!missing(`array_dummy`) && is.null(`array_dummy`)) {
        rlang::abort(message = "Invalid value for `array_dummy` when calling FakeApi$fake_set_query, `array_dummy` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `array_dummy` when calling FakeApi$fake_set_query, `array_dummy` is not nullable"))
      }

      # check if items are unique
      if (!is.null(`set_dummy`) && !identical(`set_dummy`, unique(`set_dummy`))) {
        rlang::abort(message = "Invalid value for `set_dummy` when calling FakeApi$fake_set_query. Items must be unique.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Invalid value for `set_dummy` when calling FakeApi$fake_set_query. Items must be unique."))
      }
      # explore
      for (query_item in `set_dummy`) {
        query_params[["set_dummy"]] <- c(query_params[["set_dummy"]], list(`set_dummy` = query_item))
      }

      # explore
      for (query_item in `array_dummy`) {
        query_params[["array_dummy"]] <- c(query_params[["array_dummy"]], list(`array_dummy` = query_item))
      }

      local_var_url_path <- "/fake/set_query_parameter"

      # The Accept request HTTP header
      local_var_accepts <- list()

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        local_var_resp$content <- NULL
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    }
  )
)
