#' OpenAPI Petstore
#'
#' This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
#'
#' The version of the OpenAPI document: 1.0.0
#' Generated by: https://openapi-generator.tech
#'
#' @docType class
#' @title ApiException
#' @description ApiException Class
#' @format An \code{R6Class} generator object
#' @field status Status of the ApiException
#' @field reason Reason of the ApiException
#' @field body Body of the http response
#' @field headers Headers of the http response
#' @field error_object error object type
#' @export
ApiException <- R6::R6Class(
  "ApiException",
  public = list(
    status = NULL,
    reason = NULL,
    body = NULL,
    headers = NULL,
    error_object = NULL,

    #' @description
    #' Initialize a new ApiException class.
    #'
    #' @param status HTTP status.
    #' @param reason Reason of the ApiException.
    #' @param http_response HTTP response object.
    initialize = function(status = NULL, reason = NULL, http_response = NULL) {
      if (!is.null(http_response)) {
        self$status <- http_response$status_code
        errorMsg <- http_response$response_as_text()
        if (is.null(errorMsg) || errorMsg == "") {
          errorMsg <- "Api exception encountered. No details given."
        }
        self$body <- errorMsg
        self$headers <- http_response$headers
        self$reason <- http_response$http_status_desc
        self$error_object <- ModelApiResponse$new()$fromJSONString(http_response$response_as_text())
      } else {
        self$status <- status
        self$reason <- reason
        self$body <- NULL
        self$headers <- NULL
        self$error_object <- NULL
      }
    },

    #' @description
    #' Returns the string format of ApiException.
    #'
    #' @return the string format of ApiException.
    toString = function() {
      errorMsg <- ""
      errorMsg <- paste("status : ", self$status, "\n", sep = "")
      errorMsg <- paste(errorMsg, "Reason : ", self$reason, "\n", sep = "")
      if (!is.null(self$headers)) {
        errorMsg <- paste(errorMsg, "Headers : ", "\n", sep = "")
        for (name in names(self$headers)) {
          errorMsg <- paste(errorMsg, name, " : ", self$headers[[name]], "\n", sep = " ")
        }
      }
      if (!is.null(self$body)) {
        errorMsg <- paste(errorMsg, "Body : ", "\n", sep = "")
        errorMsg <- paste(errorMsg, self$body, "\n")
      }
      if (!is.null(self$error_object)) {
        errorMsg <- paste(errorMsg, "Error object : ", "\n", sep = "")
        errorMsg <- paste(errorMsg, self$error_object$toJSONString(), "\n")
      }
      errorMsg
    }
  )
)
