/*
 * Multipart File Upload Test
 *
 * Regression test for async multipart file uploads with tokio::fs
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct UploadResponse {
    /// Whether the upload was successful
    #[serde(rename = "success")]
    pub success: bool,
    /// Number of files uploaded
    #[serde(rename = "fileCount")]
    pub file_count: i32,
    /// Optional message about the upload
    #[serde(rename = "message", skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
}

impl UploadResponse {
    pub fn new(success: bool, file_count: i32) -> UploadResponse {
        UploadResponse {
            success,
            file_count,
            message: None,
        }
    }
}

