/*
 * Enum Query Parameter Test
 *
 * Test spec for enum and non-primitive query parameters
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 * Generated by: https://openapi-generator.tech
 */


use reqwest;
use serde::{Deserialize, Serialize, de::Error as _};
use crate::{apis::ResponseContent, models};
use super::{Error, configuration, ContentType};


/// struct for typed errors of method [`get_aggregate_data`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetAggregateDataError {
    Status400(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_items`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetItemsError {
    UnknownValue(serde_json::Value),
}


/// Test endpoint with enum query parameters referenced via $ref
pub async fn get_aggregate_data(configuration: &configuration::Configuration, status: models::Status, time_bucket: Option<models::TimeBucket>, sort_direction: Option<models::SortDirection>) -> Result<models::AggregateResponse, Error<GetAggregateDataError>> {
    // add a prefix to parameters to efficiently prevent name collisions
    let p_query_status = status;
    let p_query_time_bucket = time_bucket;
    let p_query_sort_direction = sort_direction;

    let uri_str = format!("{}/aggregate", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref param_value) = p_query_time_bucket {
        req_builder = req_builder.query(&[("timeBucket", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_sort_direction {
        req_builder = req_builder.query(&[("sortDirection", &param_value.to_string())]);
    }
    req_builder = req_builder.query(&[("status", &p_query_status.to_string())]);
    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();
    let content_type = resp
        .headers()
        .get("content-type")
        .and_then(|v| v.to_str().ok())
        .unwrap_or("application/octet-stream");
    let content_type = super::ContentType::from(content_type);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        match content_type {
            ContentType::Json => serde_json::from_str(&content).map_err(Error::from),
            ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::AggregateResponse`"))),
            ContentType::Unsupported(unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{unknown_type}` content type response that cannot be converted to `models::AggregateResponse`")))),
        }
    } else {
        let content = resp.text().await?;
        let entity: Option<GetAggregateDataError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { status, content, entity }))
    }
}

pub async fn get_items(configuration: &configuration::Configuration, category: Option<&str>, priority: Option<models::Priority>) -> Result<Vec<models::Item>, Error<GetItemsError>> {
    // add a prefix to parameters to efficiently prevent name collisions
    let p_query_category = category;
    let p_query_priority = priority;

    let uri_str = format!("{}/items", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref param_value) = p_query_category {
        req_builder = req_builder.query(&[("category", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_priority {
        req_builder = req_builder.query(&[("priority", &param_value.to_string())]);
    }
    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();
    let content_type = resp
        .headers()
        .get("content-type")
        .and_then(|v| v.to_str().ok())
        .unwrap_or("application/octet-stream");
    let content_type = super::ContentType::from(content_type);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        match content_type {
            ContentType::Json => serde_json::from_str(&content).map_err(Error::from),
            ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `Vec&lt;models::Item&gt;`"))),
            ContentType::Unsupported(unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{unknown_type}` content type response that cannot be converted to `Vec&lt;models::Item&gt;`")))),
        }
    } else {
        let content = resp.text().await?;
        let entity: Option<GetItemsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { status, content, entity }))
    }
}

