/*
 * ByRefOrValue
 *
 * This tests for a oneOf interface representation 
 *
 * The version of the OpenAPI document: 0.0.1
 * 
 * Generated by: https://openapi-generator.tech
 */

use std::sync::Arc;
use std::borrow::Borrow;
use std::pin::Pin;
#[allow(unused_imports)]
use std::option::Option;

use hyper;
use hyper_util::client::legacy::connect::Connect;
use futures::Future;

use crate::models;
use super::{Error, configuration};
use super::request as __internal_request;

pub struct FooApiClient<C: Connect>
    where C: Clone + std::marker::Send + Sync + 'static {
    configuration: Arc<configuration::Configuration<C>>,
}

impl<C: Connect> FooApiClient<C>
    where C: Clone + std::marker::Send + Sync {
    pub fn new(configuration: Arc<configuration::Configuration<C>>) -> FooApiClient<C> {
        FooApiClient {
            configuration,
        }
    }
}

pub trait FooApi: Send + Sync {
    fn create_foo(&self, foo: Option<models::Foo>) -> Pin<Box<dyn Future<Output = Result<models::FooRefOrValue, Error>> + Send>>;
    fn get_all_foos(&self, ) -> Pin<Box<dyn Future<Output = Result<Vec<models::FooRefOrValue>, Error>> + Send>>;
}

impl<C: Connect>FooApi for FooApiClient<C>
    where C: Clone + std::marker::Send + Sync {
    #[allow(unused_mut)]
    fn create_foo(&self, foo: Option<models::Foo>) -> Pin<Box<dyn Future<Output = Result<models::FooRefOrValue, Error>> + Send>> {
        let mut req = __internal_request::Request::new(hyper::Method::POST, "/foo".to_string())
        ;
        req = req.with_body_param(foo);

        req.execute(self.configuration.borrow())
    }

    #[allow(unused_mut)]
    fn get_all_foos(&self, ) -> Pin<Box<dyn Future<Output = Result<Vec<models::FooRefOrValue>, Error>> + Send>> {
        let mut req = __internal_request::Request::new(hyper::Method::GET, "/foo".to_string())
        ;

        req.execute(self.configuration.borrow())
    }

}
