# openapi-java-client

API

- API version: 1.0.0

- Generator version: 7.20.0-SNAPSHOT

API


*Automatically generated by the [OpenAPI Generator](https://openapi-generator.tech)*

## Requirements

Building the API client library requires:

1. Java 17+
2. Maven/Gradle

## Installation

To install the API client library to your local Maven repository, simply execute:

```shell
mvn clean install
```

To deploy it to a remote Maven repository instead, configure the settings of the repository and execute:

```shell
mvn clean deploy
```

Refer to the [OSSRH Guide](http://central.sonatype.org/pages/ossrh-guide.html) for more information.

### Maven users

Add this dependency to your project's POM:

```xml
<dependency>
  <groupId>org.openapitools</groupId>
  <artifactId>openapi-java-client</artifactId>
  <version>1.0.0</version>
  <scope>compile</scope>
</dependency>
```

### Gradle users

Add this dependency to your project's build file:

```groovy
  repositories {
    mavenCentral()     // Needed if the 'openapi-java-client' jar has been published to maven central.
    mavenLocal()       // Needed if the 'openapi-java-client' jar has been published to the local maven repo.
  }

  dependencies {
     implementation "org.openapitools:openapi-java-client:1.0.0"
  }
```

### Others

At first generate the JAR by executing:

```shell
mvn clean package
```

Then manually install the following JARs:

- `target/openapi-java-client-1.0.0.jar`
- `target/lib/*.jar`

## Getting Started

Please follow the [installation](#installation) instruction and execute the following Java code:

```java

import org.openapitools.client.*;
import org.openapitools.client.auth.*;
import org.openapitools.client.model.*;
import org.openapitools.client.api.BasApi;

public class BasApiExample {

    public static void main(String[] args) {
        ApiClient defaultClient = new ApiClient();
        defaultClient.setBasePath("http://localhost:8080");
        
        // Configure HTTP basic authorization: basicAuth
        HttpBasicAuth basicAuth = (HttpBasicAuth) defaultClient.getAuthentication("basicAuth");
        basicAuth.setUsername("YOUR USERNAME");
        basicAuth.setPassword("YOUR PASSWORD");

        BasApi apiInstance = new BasApi(defaultClient);
        File fileContent = new File("/path/to/file"); // File | The message payload
        String idempotencyKey = "idempotencyKey_example"; // String | 
        DataDirection dataDirection = DataDirection.fromValue("INGOING"); // DataDirection | 
        DataChannel dataChannel = DataChannel.fromValue("BIKE"); // DataChannel | 
        try {
            InlineObject result = apiInstance.createMessage(fileContent, idempotencyKey, dataDirection, dataChannel);
            System.out.println(result);
        } catch (HttpStatusCodeException e) {
            System.err.println("Exception when calling BasApi#createMessage");
            System.err.println("Status code: " + e.getStatusCode().value());
            System.err.println("Reason: " + e.getResponseBodyAsString());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8080*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BasApi* | [**createMessage**](docs/BasApi.md#createMessage) | **POST** /messages | Creates a new message


## Documentation for Models

 - [DataChannel](docs/DataChannel.md)
 - [DataDirection](docs/DataDirection.md)
 - [InlineObject](docs/InlineObject.md)


<a id="documentation-for-authorization"></a>
## Documentation for Authorization


Authentication schemes defined for the API:
<a id="basicAuth"></a>
### basicAuth


- **Type**: HTTP basic authentication


## Recommendation

It's recommended to create an instance of `ApiClient` per thread in a multithreaded environment to avoid any potential issues.

## Author



