# petstore-okhttp-gson

ping some object
- API version: 1.0
  - Generator version: 7.20.0-SNAPSHOT

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)


*Automatically generated by the [OpenAPI Generator](https://openapi-generator.tech)*


## Requirements

Building the API client library requires:
1. Java 1.8+
2. Maven (3.8.3+)/Gradle (7.2+)

## Installation

To install the API client library to your local Maven repository, simply execute:

```shell
mvn clean install
```

To deploy it to a remote Maven repository instead, configure the settings of the repository and execute:

```shell
mvn clean deploy
```

Refer to the [OSSRH Guide](http://central.sonatype.org/pages/ossrh-guide.html) for more information.

### Maven users

Add this dependency to your project's POM:

```xml
<dependency>
  <groupId>org.openapitools</groupId>
  <artifactId>petstore-okhttp-gson</artifactId>
  <version>1.0</version>
  <scope>compile</scope>
</dependency>
```

### Gradle users

Add this dependency to your project's build file:

```groovy
  repositories {
    mavenCentral()     // Needed if the 'petstore-okhttp-gson' jar has been published to maven central.
    mavenLocal()       // Needed if the 'petstore-okhttp-gson' jar has been published to the local maven repo.
  }

  dependencies {
     implementation "org.openapitools:petstore-okhttp-gson:1.0"
  }
```

### Others

At first generate the JAR by executing:

```shell
mvn clean package
```

Then manually install the following JARs:

* `target/petstore-okhttp-gson-1.0.jar`
* `target/lib/*.jar`

## Getting Started

Please follow the [installation](#installation) instruction and execute the following Java code:

```java

// Import classes:
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.model.*;
import org.openapitools.client.api.PingApi;

public class Example {
  public static void main(String[] args) {
    ApiClient defaultClient = Configuration.getDefaultApiClient();
    defaultClient.setBasePath("http://localhost:8082");

    PingApi apiInstance = new PingApi(defaultClient);
    Long petId = 56L; // Long | ID of pet that needs to be updated
    String name = "name_example"; // String | Updated name of the pet
    String status = "status_example"; // String | Updated status of the pet
    try {
      SomeObj result = apiInstance.getPing(petId)
            .name(name)
            .status(status)
            .execute();
      System.out.println(result);
    } catch (ApiException e) {
      System.err.println("Exception when calling PingApi#getPing");
      System.err.println("Status code: " + e.getCode());
      System.err.println("Reason: " + e.getResponseBody());
      System.err.println("Response headers: " + e.getResponseHeaders());
      e.printStackTrace();
    }
  }
}

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8082*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*PingApi* | [**getPing**](docs/PingApi.md#getPing) | **GET** /ping | 
*PingApi* | [**postPing**](docs/PingApi.md#postPing) | **POST** /ping | 


## Documentation for Models

 - [SimpleOneOf](docs/SimpleOneOf.md)
 - [SomeObj](docs/SomeObj.md)


<a id="documentation-for-authorization"></a>
## Documentation for Authorization

Endpoints do not require authorization.


## Recommendation

It's recommended to create an instance of `ApiClient` per thread in a multithreaded environment to avoid any potential issues.

## Author



