/* tslint:disable */
/* eslint-disable */
/**
 * Echo Server API
 * Echo Server API
 *
 * The version of the OpenAPI document: 0.1.0
 * Contact: team@openapitools.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from './configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction, replaceWithSerializableTypeIfNeeded } from './common';
import type { RequestArgs } from './base';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, BaseAPI, RequiredError, operationServerMap } from './base';

export interface Bird {
    'size'?: string;
    'color'?: string;
}
export interface Category {
    'id'?: number;
    'name'?: string;
}
export interface DataQuery extends Query {
    /**
     * test suffix
     */
    'suffix'?: string;
    /**
     * Some text containing white spaces
     */
    'text'?: string;
    /**
     * A date
     */
    'date'?: string;
}


/**
 * to test the default value of properties
 */
export interface DefaultValue {
    'array_string_enum_ref_default'?: Array<StringEnumRef>;
    'array_string_enum_default'?: Array<DefaultValueArrayStringEnumDefaultEnum>;
    'array_string_default'?: Array<string>;
    'array_integer_default'?: Array<number>;
    'array_string'?: Array<string>;
    'array_string_nullable'?: Array<string> | null;
    'array_string_extension_nullable'?: Array<string> | null;
    'string_nullable'?: string | null;
}

export const DefaultValueArrayStringEnumDefaultEnum = {
    Success: 'success',
    Failure: 'failure',
    Unclassified: 'unclassified'
} as const;

export type DefaultValueArrayStringEnumDefaultEnum = typeof DefaultValueArrayStringEnumDefaultEnum[keyof typeof DefaultValueArrayStringEnumDefaultEnum];

export interface NumberPropertiesOnly {
    'number'?: number;
    'float'?: number;
    'double'?: number;
}
export interface Pet {
    'id'?: number;
    'name': string;
    'category'?: Category;
    'photoUrls': Array<string>;
    'tags'?: Array<Tag>;
    /**
     * pet status in the store
     */
    'status'?: PetStatusEnum;
}

export const PetStatusEnum = {
    Available: 'available',
    Pending: 'pending',
    Sold: 'sold'
} as const;

export type PetStatusEnum = typeof PetStatusEnum[keyof typeof PetStatusEnum];

export interface Query {
    /**
     * Query
     */
    'id'?: number;
    'outcomes'?: Array<QueryOutcomesEnum>;
}

export const QueryOutcomesEnum = {
    Success: 'SUCCESS',
    Failure: 'FAILURE',
    Skipped: 'SKIPPED'
} as const;

export type QueryOutcomesEnum = typeof QueryOutcomesEnum[keyof typeof QueryOutcomesEnum];


export const StringEnumRef = {
    Success: 'success',
    Failure: 'failure',
    Unclassified: 'unclassified'
} as const;

export type StringEnumRef = typeof StringEnumRef[keyof typeof StringEnumRef];


export interface Tag {
    'id'?: number;
    'name'?: string;
}
export interface TestFormObjectMultipartRequestMarker {
    'name'?: string;
}
export interface TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter {
    'size'?: string;
    'color'?: string;
    'id'?: number;
    'name'?: string;
}
export interface TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter {
    'values'?: Array<string>;
}

/**
 * AuthApi - axios parameter creator
 */
export const AuthApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * To test HTTP basic authentication
         * @summary To test HTTP basic authentication
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testAuthHttpBasic: async (options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/auth/http/basic`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication http_auth required
            // http basic authentication required
            setBasicAuthToObject(localVarRequestOptions, configuration)

            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * To test HTTP bearer authentication
         * @summary To test HTTP bearer authentication
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testAuthHttpBearer: async (options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/auth/http/bearer`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            // authentication http_bearer_auth required
            // http bearer authentication required
            await setBearerAuthToObject(localVarHeaderParameter, configuration)

            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * AuthApi - functional programming interface
 */
export const AuthApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = AuthApiAxiosParamCreator(configuration)
    return {
        /**
         * To test HTTP basic authentication
         * @summary To test HTTP basic authentication
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testAuthHttpBasic(options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testAuthHttpBasic(options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['AuthApi.testAuthHttpBasic']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * To test HTTP bearer authentication
         * @summary To test HTTP bearer authentication
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testAuthHttpBearer(options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testAuthHttpBearer(options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['AuthApi.testAuthHttpBearer']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * AuthApi - factory interface
 */
export const AuthApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = AuthApiFp(configuration)
    return {
        /**
         * To test HTTP basic authentication
         * @summary To test HTTP basic authentication
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testAuthHttpBasic(options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testAuthHttpBasic(options).then((request) => request(axios, basePath));
        },
        /**
         * To test HTTP bearer authentication
         * @summary To test HTTP bearer authentication
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testAuthHttpBearer(options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testAuthHttpBearer(options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * AuthApi - object-oriented interface
 */
export class AuthApi extends BaseAPI {
    /**
     * To test HTTP basic authentication
     * @summary To test HTTP basic authentication
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testAuthHttpBasic(options?: RawAxiosRequestConfig) {
        return AuthApiFp(this.configuration).testAuthHttpBasic(options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * To test HTTP bearer authentication
     * @summary To test HTTP bearer authentication
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testAuthHttpBearer(options?: RawAxiosRequestConfig) {
        return AuthApiFp(this.configuration).testAuthHttpBearer(options).then((request) => request(this.axios, this.basePath));
    }
}



/**
 * BodyApi - axios parameter creator
 */
export const BodyApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Test binary (gif) response body
         * @summary Test binary (gif) response body
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testBinaryGif: async (options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/binary/gif`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            localVarHeaderParameter['Accept'] = 'image/gif';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Test body parameter(s)
         * @summary Test body parameter(s)
         * @param {File} [body] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testBodyApplicationOctetstreamBinary: async (body?: File, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/body/application/octetstream/binary`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            localVarHeaderParameter['Content-Type'] = 'application/octet-stream';
            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(body, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Test array of binary in multipart mime
         * @summary Test array of binary in multipart mime
         * @param {Array<File>} files 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testBodyMultipartFormdataArrayOfBinary: async (files: Array<File>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'files' is not null or undefined
            assertParamExists('testBodyMultipartFormdataArrayOfBinary', 'files', files)
            const localVarPath = `/body/application/octetstream/array_of_binary`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;
            const localVarFormParams = new ((configuration && configuration.formDataCtor) || FormData)();

            if (files) {
                files.forEach((element) => {
                    localVarFormParams.append('files', element as any);
                })
            }

            localVarHeaderParameter['Content-Type'] = 'multipart/form-data';
            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = localVarFormParams;

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Test single binary in multipart mime
         * @summary Test single binary in multipart mime
         * @param {File} [myFile] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testBodyMultipartFormdataSingleBinary: async (myFile?: File, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/body/application/octetstream/single_binary`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;
            const localVarFormParams = new ((configuration && configuration.formDataCtor) || FormData)();


            if (myFile !== undefined) { 
                localVarFormParams.append('my-file', myFile as any);
            }
            localVarHeaderParameter['Content-Type'] = 'multipart/form-data';
            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = localVarFormParams;

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Test body parameter(s)
         * @summary Test body parameter(s)
         * @param {Pet} [pet] Pet object that needs to be added to the store
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testEchoBodyAllOfPet: async (pet?: Pet, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/echo/body/allOf/Pet`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            localVarHeaderParameter['Content-Type'] = 'application/json';
            localVarHeaderParameter['Accept'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(pet, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Test free form object
         * @summary Test free form object
         * @param {object} [body] Free form object
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testEchoBodyFreeFormObjectResponseString: async (body?: object, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/echo/body/FreeFormObject/response_string`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            localVarHeaderParameter['Content-Type'] = 'application/json';
            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(body, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Test body parameter(s)
         * @summary Test body parameter(s)
         * @param {Pet} [pet] Pet object that needs to be added to the store
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testEchoBodyPet: async (pet?: Pet, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/echo/body/Pet`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            localVarHeaderParameter['Content-Type'] = 'application/json';
            localVarHeaderParameter['Accept'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(pet, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Test empty response body
         * @summary Test empty response body
         * @param {Pet} [pet] Pet object that needs to be added to the store
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testEchoBodyPetResponseString: async (pet?: Pet, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/echo/body/Pet/response_string`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            localVarHeaderParameter['Content-Type'] = 'application/json';
            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(pet, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Test string enum response body
         * @summary Test string enum response body
         * @param {string} [body] String enum
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testEchoBodyStringEnum: async (body?: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/echo/body/string_enum`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            localVarHeaderParameter['Content-Type'] = 'application/json';
            localVarHeaderParameter['Accept'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(body, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Test empty json (request body)
         * @summary Test empty json (request body)
         * @param {Tag} [tag] Tag object
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testEchoBodyTagResponseString: async (tag?: Tag, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/echo/body/Tag/response_string`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            localVarHeaderParameter['Content-Type'] = 'application/json';
            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(tag, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * BodyApi - functional programming interface
 */
export const BodyApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = BodyApiAxiosParamCreator(configuration)
    return {
        /**
         * Test binary (gif) response body
         * @summary Test binary (gif) response body
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testBinaryGif(options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<File>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testBinaryGif(options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['BodyApi.testBinaryGif']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Test body parameter(s)
         * @summary Test body parameter(s)
         * @param {File} [body] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testBodyApplicationOctetstreamBinary(body?: File, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testBodyApplicationOctetstreamBinary(body, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['BodyApi.testBodyApplicationOctetstreamBinary']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Test array of binary in multipart mime
         * @summary Test array of binary in multipart mime
         * @param {Array<File>} files 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testBodyMultipartFormdataArrayOfBinary(files: Array<File>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testBodyMultipartFormdataArrayOfBinary(files, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['BodyApi.testBodyMultipartFormdataArrayOfBinary']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Test single binary in multipart mime
         * @summary Test single binary in multipart mime
         * @param {File} [myFile] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testBodyMultipartFormdataSingleBinary(myFile?: File, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testBodyMultipartFormdataSingleBinary(myFile, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['BodyApi.testBodyMultipartFormdataSingleBinary']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Test body parameter(s)
         * @summary Test body parameter(s)
         * @param {Pet} [pet] Pet object that needs to be added to the store
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testEchoBodyAllOfPet(pet?: Pet, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Pet>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testEchoBodyAllOfPet(pet, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['BodyApi.testEchoBodyAllOfPet']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Test free form object
         * @summary Test free form object
         * @param {object} [body] Free form object
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testEchoBodyFreeFormObjectResponseString(body?: object, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testEchoBodyFreeFormObjectResponseString(body, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['BodyApi.testEchoBodyFreeFormObjectResponseString']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Test body parameter(s)
         * @summary Test body parameter(s)
         * @param {Pet} [pet] Pet object that needs to be added to the store
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testEchoBodyPet(pet?: Pet, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Pet>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testEchoBodyPet(pet, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['BodyApi.testEchoBodyPet']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Test empty response body
         * @summary Test empty response body
         * @param {Pet} [pet] Pet object that needs to be added to the store
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testEchoBodyPetResponseString(pet?: Pet, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testEchoBodyPetResponseString(pet, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['BodyApi.testEchoBodyPetResponseString']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Test string enum response body
         * @summary Test string enum response body
         * @param {string} [body] String enum
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testEchoBodyStringEnum(body?: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<StringEnumRef>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testEchoBodyStringEnum(body, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['BodyApi.testEchoBodyStringEnum']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Test empty json (request body)
         * @summary Test empty json (request body)
         * @param {Tag} [tag] Tag object
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testEchoBodyTagResponseString(tag?: Tag, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testEchoBodyTagResponseString(tag, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['BodyApi.testEchoBodyTagResponseString']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * BodyApi - factory interface
 */
export const BodyApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = BodyApiFp(configuration)
    return {
        /**
         * Test binary (gif) response body
         * @summary Test binary (gif) response body
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testBinaryGif(options?: RawAxiosRequestConfig): AxiosPromise<File> {
            return localVarFp.testBinaryGif(options).then((request) => request(axios, basePath));
        },
        /**
         * Test body parameter(s)
         * @summary Test body parameter(s)
         * @param {File} [body] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testBodyApplicationOctetstreamBinary(body?: File, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testBodyApplicationOctetstreamBinary(body, options).then((request) => request(axios, basePath));
        },
        /**
         * Test array of binary in multipart mime
         * @summary Test array of binary in multipart mime
         * @param {Array<File>} files 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testBodyMultipartFormdataArrayOfBinary(files: Array<File>, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testBodyMultipartFormdataArrayOfBinary(files, options).then((request) => request(axios, basePath));
        },
        /**
         * Test single binary in multipart mime
         * @summary Test single binary in multipart mime
         * @param {File} [myFile] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testBodyMultipartFormdataSingleBinary(myFile?: File, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testBodyMultipartFormdataSingleBinary(myFile, options).then((request) => request(axios, basePath));
        },
        /**
         * Test body parameter(s)
         * @summary Test body parameter(s)
         * @param {Pet} [pet] Pet object that needs to be added to the store
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testEchoBodyAllOfPet(pet?: Pet, options?: RawAxiosRequestConfig): AxiosPromise<Pet> {
            return localVarFp.testEchoBodyAllOfPet(pet, options).then((request) => request(axios, basePath));
        },
        /**
         * Test free form object
         * @summary Test free form object
         * @param {object} [body] Free form object
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testEchoBodyFreeFormObjectResponseString(body?: object, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testEchoBodyFreeFormObjectResponseString(body, options).then((request) => request(axios, basePath));
        },
        /**
         * Test body parameter(s)
         * @summary Test body parameter(s)
         * @param {Pet} [pet] Pet object that needs to be added to the store
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testEchoBodyPet(pet?: Pet, options?: RawAxiosRequestConfig): AxiosPromise<Pet> {
            return localVarFp.testEchoBodyPet(pet, options).then((request) => request(axios, basePath));
        },
        /**
         * Test empty response body
         * @summary Test empty response body
         * @param {Pet} [pet] Pet object that needs to be added to the store
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testEchoBodyPetResponseString(pet?: Pet, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testEchoBodyPetResponseString(pet, options).then((request) => request(axios, basePath));
        },
        /**
         * Test string enum response body
         * @summary Test string enum response body
         * @param {string} [body] String enum
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testEchoBodyStringEnum(body?: string, options?: RawAxiosRequestConfig): AxiosPromise<StringEnumRef> {
            return localVarFp.testEchoBodyStringEnum(body, options).then((request) => request(axios, basePath));
        },
        /**
         * Test empty json (request body)
         * @summary Test empty json (request body)
         * @param {Tag} [tag] Tag object
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testEchoBodyTagResponseString(tag?: Tag, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testEchoBodyTagResponseString(tag, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * BodyApi - object-oriented interface
 */
export class BodyApi extends BaseAPI {
    /**
     * Test binary (gif) response body
     * @summary Test binary (gif) response body
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testBinaryGif(options?: RawAxiosRequestConfig) {
        return BodyApiFp(this.configuration).testBinaryGif(options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Test body parameter(s)
     * @summary Test body parameter(s)
     * @param {File} [body] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testBodyApplicationOctetstreamBinary(body?: File, options?: RawAxiosRequestConfig) {
        return BodyApiFp(this.configuration).testBodyApplicationOctetstreamBinary(body, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Test array of binary in multipart mime
     * @summary Test array of binary in multipart mime
     * @param {Array<File>} files 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testBodyMultipartFormdataArrayOfBinary(files: Array<File>, options?: RawAxiosRequestConfig) {
        return BodyApiFp(this.configuration).testBodyMultipartFormdataArrayOfBinary(files, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Test single binary in multipart mime
     * @summary Test single binary in multipart mime
     * @param {File} [myFile] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testBodyMultipartFormdataSingleBinary(myFile?: File, options?: RawAxiosRequestConfig) {
        return BodyApiFp(this.configuration).testBodyMultipartFormdataSingleBinary(myFile, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Test body parameter(s)
     * @summary Test body parameter(s)
     * @param {Pet} [pet] Pet object that needs to be added to the store
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testEchoBodyAllOfPet(pet?: Pet, options?: RawAxiosRequestConfig) {
        return BodyApiFp(this.configuration).testEchoBodyAllOfPet(pet, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Test free form object
     * @summary Test free form object
     * @param {object} [body] Free form object
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testEchoBodyFreeFormObjectResponseString(body?: object, options?: RawAxiosRequestConfig) {
        return BodyApiFp(this.configuration).testEchoBodyFreeFormObjectResponseString(body, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Test body parameter(s)
     * @summary Test body parameter(s)
     * @param {Pet} [pet] Pet object that needs to be added to the store
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testEchoBodyPet(pet?: Pet, options?: RawAxiosRequestConfig) {
        return BodyApiFp(this.configuration).testEchoBodyPet(pet, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Test empty response body
     * @summary Test empty response body
     * @param {Pet} [pet] Pet object that needs to be added to the store
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testEchoBodyPetResponseString(pet?: Pet, options?: RawAxiosRequestConfig) {
        return BodyApiFp(this.configuration).testEchoBodyPetResponseString(pet, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Test string enum response body
     * @summary Test string enum response body
     * @param {string} [body] String enum
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testEchoBodyStringEnum(body?: string, options?: RawAxiosRequestConfig) {
        return BodyApiFp(this.configuration).testEchoBodyStringEnum(body, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Test empty json (request body)
     * @summary Test empty json (request body)
     * @param {Tag} [tag] Tag object
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testEchoBodyTagResponseString(tag?: Tag, options?: RawAxiosRequestConfig) {
        return BodyApiFp(this.configuration).testEchoBodyTagResponseString(tag, options).then((request) => request(this.axios, this.basePath));
    }
}



/**
 * FormApi - axios parameter creator
 */
export const FormApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Test form parameter(s)
         * @summary Test form parameter(s)
         * @param {number} [integerForm] 
         * @param {boolean} [booleanForm] 
         * @param {string} [stringForm] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testFormIntegerBooleanString: async (integerForm?: number, booleanForm?: boolean, stringForm?: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/form/integer/boolean/string`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;
            const localVarFormParams = new URLSearchParams();


            if (integerForm !== undefined) { 
                localVarFormParams.set('integer_form', integerForm as any);
            }

            if (booleanForm !== undefined) { 
                localVarFormParams.set('boolean_form', booleanForm as any);
            }

            if (stringForm !== undefined) { 
                localVarFormParams.set('string_form', stringForm as any);
            }
            localVarHeaderParameter['Content-Type'] = 'application/x-www-form-urlencoded';
            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = localVarFormParams.toString();

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Test form parameter(s) for multipart schema
         * @summary Test form parameter(s) for multipart schema
         * @param {TestFormObjectMultipartRequestMarker} marker 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testFormObjectMultipart: async (marker: TestFormObjectMultipartRequestMarker, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'marker' is not null or undefined
            assertParamExists('testFormObjectMultipart', 'marker', marker)
            const localVarPath = `/form/object/multipart`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;
            const localVarFormParams = new ((configuration && configuration.formDataCtor) || FormData)();


            if (marker !== undefined) { 
                localVarFormParams.append('marker', new Blob([JSON.stringify(marker, replaceWithSerializableTypeIfNeeded)], { type: "application/json", }));
            }
            localVarHeaderParameter['Content-Type'] = 'multipart/form-data';
            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = localVarFormParams;

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Test form parameter(s) for oneOf schema
         * @summary Test form parameter(s) for oneOf schema
         * @param {string} [form1] 
         * @param {number} [form2] 
         * @param {string} [form3] 
         * @param {boolean} [form4] 
         * @param {number} [id] 
         * @param {string} [name] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testFormOneof: async (form1?: string, form2?: number, form3?: string, form4?: boolean, id?: number, name?: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/form/oneof`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;
            const localVarFormParams = new URLSearchParams();


            if (form1 !== undefined) { 
                localVarFormParams.set('form1', form1 as any);
            }

            if (form2 !== undefined) { 
                localVarFormParams.set('form2', form2 as any);
            }

            if (form3 !== undefined) { 
                localVarFormParams.set('form3', form3 as any);
            }

            if (form4 !== undefined) { 
                localVarFormParams.set('form4', form4 as any);
            }

            if (id !== undefined) { 
                localVarFormParams.set('id', id as any);
            }

            if (name !== undefined) { 
                localVarFormParams.set('name', name as any);
            }
            localVarHeaderParameter['Content-Type'] = 'application/x-www-form-urlencoded';
            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = localVarFormParams.toString();

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * FormApi - functional programming interface
 */
export const FormApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = FormApiAxiosParamCreator(configuration)
    return {
        /**
         * Test form parameter(s)
         * @summary Test form parameter(s)
         * @param {number} [integerForm] 
         * @param {boolean} [booleanForm] 
         * @param {string} [stringForm] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testFormIntegerBooleanString(integerForm?: number, booleanForm?: boolean, stringForm?: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testFormIntegerBooleanString(integerForm, booleanForm, stringForm, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['FormApi.testFormIntegerBooleanString']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Test form parameter(s) for multipart schema
         * @summary Test form parameter(s) for multipart schema
         * @param {TestFormObjectMultipartRequestMarker} marker 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testFormObjectMultipart(marker: TestFormObjectMultipartRequestMarker, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testFormObjectMultipart(marker, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['FormApi.testFormObjectMultipart']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Test form parameter(s) for oneOf schema
         * @summary Test form parameter(s) for oneOf schema
         * @param {string} [form1] 
         * @param {number} [form2] 
         * @param {string} [form3] 
         * @param {boolean} [form4] 
         * @param {number} [id] 
         * @param {string} [name] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testFormOneof(form1?: string, form2?: number, form3?: string, form4?: boolean, id?: number, name?: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testFormOneof(form1, form2, form3, form4, id, name, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['FormApi.testFormOneof']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * FormApi - factory interface
 */
export const FormApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = FormApiFp(configuration)
    return {
        /**
         * Test form parameter(s)
         * @summary Test form parameter(s)
         * @param {number} [integerForm] 
         * @param {boolean} [booleanForm] 
         * @param {string} [stringForm] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testFormIntegerBooleanString(integerForm?: number, booleanForm?: boolean, stringForm?: string, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testFormIntegerBooleanString(integerForm, booleanForm, stringForm, options).then((request) => request(axios, basePath));
        },
        /**
         * Test form parameter(s) for multipart schema
         * @summary Test form parameter(s) for multipart schema
         * @param {TestFormObjectMultipartRequestMarker} marker 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testFormObjectMultipart(marker: TestFormObjectMultipartRequestMarker, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testFormObjectMultipart(marker, options).then((request) => request(axios, basePath));
        },
        /**
         * Test form parameter(s) for oneOf schema
         * @summary Test form parameter(s) for oneOf schema
         * @param {string} [form1] 
         * @param {number} [form2] 
         * @param {string} [form3] 
         * @param {boolean} [form4] 
         * @param {number} [id] 
         * @param {string} [name] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testFormOneof(form1?: string, form2?: number, form3?: string, form4?: boolean, id?: number, name?: string, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testFormOneof(form1, form2, form3, form4, id, name, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * FormApi - object-oriented interface
 */
export class FormApi extends BaseAPI {
    /**
     * Test form parameter(s)
     * @summary Test form parameter(s)
     * @param {number} [integerForm] 
     * @param {boolean} [booleanForm] 
     * @param {string} [stringForm] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testFormIntegerBooleanString(integerForm?: number, booleanForm?: boolean, stringForm?: string, options?: RawAxiosRequestConfig) {
        return FormApiFp(this.configuration).testFormIntegerBooleanString(integerForm, booleanForm, stringForm, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Test form parameter(s) for multipart schema
     * @summary Test form parameter(s) for multipart schema
     * @param {TestFormObjectMultipartRequestMarker} marker 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testFormObjectMultipart(marker: TestFormObjectMultipartRequestMarker, options?: RawAxiosRequestConfig) {
        return FormApiFp(this.configuration).testFormObjectMultipart(marker, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Test form parameter(s) for oneOf schema
     * @summary Test form parameter(s) for oneOf schema
     * @param {string} [form1] 
     * @param {number} [form2] 
     * @param {string} [form3] 
     * @param {boolean} [form4] 
     * @param {number} [id] 
     * @param {string} [name] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testFormOneof(form1?: string, form2?: number, form3?: string, form4?: boolean, id?: number, name?: string, options?: RawAxiosRequestConfig) {
        return FormApiFp(this.configuration).testFormOneof(form1, form2, form3, form4, id, name, options).then((request) => request(this.axios, this.basePath));
    }
}



/**
 * HeaderApi - axios parameter creator
 */
export const HeaderApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Test header parameter(s)
         * @summary Test header parameter(s)
         * @param {number} [integerHeader] 
         * @param {boolean} [booleanHeader] 
         * @param {string} [stringHeader] 
         * @param {TestHeaderIntegerBooleanStringEnumsEnumNonrefStringHeaderEnum} [enumNonrefStringHeader] 
         * @param {StringEnumRef} [enumRefStringHeader] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testHeaderIntegerBooleanStringEnums: async (integerHeader?: number, booleanHeader?: boolean, stringHeader?: string, enumNonrefStringHeader?: TestHeaderIntegerBooleanStringEnumsEnumNonrefStringHeaderEnum, enumRefStringHeader?: StringEnumRef, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/header/integer/boolean/string/enums`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            localVarHeaderParameter['Accept'] = 'text/plain';

            if (integerHeader != null) {
                localVarHeaderParameter['integer_header'] = typeof integerHeader === 'string'
                    ? integerHeader
                    : JSON.stringify(integerHeader, replaceWithSerializableTypeIfNeeded);
            }
            if (booleanHeader != null) {
                localVarHeaderParameter['boolean_header'] = typeof booleanHeader === 'string'
                    ? booleanHeader
                    : JSON.stringify(booleanHeader, replaceWithSerializableTypeIfNeeded);
            }
            if (stringHeader != null) {
                localVarHeaderParameter['string_header'] = String(stringHeader);
            }
            if (enumNonrefStringHeader != null) {
                localVarHeaderParameter['enum_nonref_string_header'] = String(enumNonrefStringHeader);
            }
            if (enumRefStringHeader != null) {
                localVarHeaderParameter['enum_ref_string_header'] = typeof enumRefStringHeader === 'string'
                    ? enumRefStringHeader
                    : JSON.stringify(enumRefStringHeader, replaceWithSerializableTypeIfNeeded);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * HeaderApi - functional programming interface
 */
export const HeaderApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = HeaderApiAxiosParamCreator(configuration)
    return {
        /**
         * Test header parameter(s)
         * @summary Test header parameter(s)
         * @param {number} [integerHeader] 
         * @param {boolean} [booleanHeader] 
         * @param {string} [stringHeader] 
         * @param {TestHeaderIntegerBooleanStringEnumsEnumNonrefStringHeaderEnum} [enumNonrefStringHeader] 
         * @param {StringEnumRef} [enumRefStringHeader] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testHeaderIntegerBooleanStringEnums(integerHeader?: number, booleanHeader?: boolean, stringHeader?: string, enumNonrefStringHeader?: TestHeaderIntegerBooleanStringEnumsEnumNonrefStringHeaderEnum, enumRefStringHeader?: StringEnumRef, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testHeaderIntegerBooleanStringEnums(integerHeader, booleanHeader, stringHeader, enumNonrefStringHeader, enumRefStringHeader, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['HeaderApi.testHeaderIntegerBooleanStringEnums']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * HeaderApi - factory interface
 */
export const HeaderApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = HeaderApiFp(configuration)
    return {
        /**
         * Test header parameter(s)
         * @summary Test header parameter(s)
         * @param {number} [integerHeader] 
         * @param {boolean} [booleanHeader] 
         * @param {string} [stringHeader] 
         * @param {TestHeaderIntegerBooleanStringEnumsEnumNonrefStringHeaderEnum} [enumNonrefStringHeader] 
         * @param {StringEnumRef} [enumRefStringHeader] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testHeaderIntegerBooleanStringEnums(integerHeader?: number, booleanHeader?: boolean, stringHeader?: string, enumNonrefStringHeader?: TestHeaderIntegerBooleanStringEnumsEnumNonrefStringHeaderEnum, enumRefStringHeader?: StringEnumRef, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testHeaderIntegerBooleanStringEnums(integerHeader, booleanHeader, stringHeader, enumNonrefStringHeader, enumRefStringHeader, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * HeaderApi - object-oriented interface
 */
export class HeaderApi extends BaseAPI {
    /**
     * Test header parameter(s)
     * @summary Test header parameter(s)
     * @param {number} [integerHeader] 
     * @param {boolean} [booleanHeader] 
     * @param {string} [stringHeader] 
     * @param {TestHeaderIntegerBooleanStringEnumsEnumNonrefStringHeaderEnum} [enumNonrefStringHeader] 
     * @param {StringEnumRef} [enumRefStringHeader] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testHeaderIntegerBooleanStringEnums(integerHeader?: number, booleanHeader?: boolean, stringHeader?: string, enumNonrefStringHeader?: TestHeaderIntegerBooleanStringEnumsEnumNonrefStringHeaderEnum, enumRefStringHeader?: StringEnumRef, options?: RawAxiosRequestConfig) {
        return HeaderApiFp(this.configuration).testHeaderIntegerBooleanStringEnums(integerHeader, booleanHeader, stringHeader, enumNonrefStringHeader, enumRefStringHeader, options).then((request) => request(this.axios, this.basePath));
    }
}

export const TestHeaderIntegerBooleanStringEnumsEnumNonrefStringHeaderEnum = {
    Success: 'success',
    Failure: 'failure',
    Unclassified: 'unclassified'
} as const;
export type TestHeaderIntegerBooleanStringEnumsEnumNonrefStringHeaderEnum = typeof TestHeaderIntegerBooleanStringEnumsEnumNonrefStringHeaderEnum[keyof typeof TestHeaderIntegerBooleanStringEnumsEnumNonrefStringHeaderEnum];


/**
 * PathApi - axios parameter creator
 */
export const PathApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Test path parameter(s)
         * @summary Test path parameter(s)
         * @param {string} pathString 
         * @param {number} pathInteger 
         * @param {TestsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPathEnumNonrefStringPathEnum} enumNonrefStringPath 
         * @param {StringEnumRef} enumRefStringPath 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPath: async (pathString: string, pathInteger: number, enumNonrefStringPath: TestsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPathEnumNonrefStringPathEnum, enumRefStringPath: StringEnumRef, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'pathString' is not null or undefined
            assertParamExists('testsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPath', 'pathString', pathString)
            // verify required parameter 'pathInteger' is not null or undefined
            assertParamExists('testsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPath', 'pathInteger', pathInteger)
            // verify required parameter 'enumNonrefStringPath' is not null or undefined
            assertParamExists('testsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPath', 'enumNonrefStringPath', enumNonrefStringPath)
            // verify required parameter 'enumRefStringPath' is not null or undefined
            assertParamExists('testsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPath', 'enumRefStringPath', enumRefStringPath)
            const localVarPath = `/path/string/{path_string}/integer/{path_integer}/{enum_nonref_string_path}/{enum_ref_string_path}`
                .replace(`{${"path_string"}}`, encodeURIComponent(String(pathString)))
                .replace(`{${"path_integer"}}`, encodeURIComponent(String(pathInteger)))
                .replace(`{${"enum_nonref_string_path"}}`, encodeURIComponent(String(enumNonrefStringPath)))
                .replace(`{${"enum_ref_string_path"}}`, encodeURIComponent(String(enumRefStringPath)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * PathApi - functional programming interface
 */
export const PathApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = PathApiAxiosParamCreator(configuration)
    return {
        /**
         * Test path parameter(s)
         * @summary Test path parameter(s)
         * @param {string} pathString 
         * @param {number} pathInteger 
         * @param {TestsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPathEnumNonrefStringPathEnum} enumNonrefStringPath 
         * @param {StringEnumRef} enumRefStringPath 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPath(pathString: string, pathInteger: number, enumNonrefStringPath: TestsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPathEnumNonrefStringPathEnum, enumRefStringPath: StringEnumRef, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPath(pathString, pathInteger, enumNonrefStringPath, enumRefStringPath, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['PathApi.testsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPath']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * PathApi - factory interface
 */
export const PathApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = PathApiFp(configuration)
    return {
        /**
         * Test path parameter(s)
         * @summary Test path parameter(s)
         * @param {string} pathString 
         * @param {number} pathInteger 
         * @param {TestsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPathEnumNonrefStringPathEnum} enumNonrefStringPath 
         * @param {StringEnumRef} enumRefStringPath 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPath(pathString: string, pathInteger: number, enumNonrefStringPath: TestsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPathEnumNonrefStringPathEnum, enumRefStringPath: StringEnumRef, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPath(pathString, pathInteger, enumNonrefStringPath, enumRefStringPath, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * PathApi - object-oriented interface
 */
export class PathApi extends BaseAPI {
    /**
     * Test path parameter(s)
     * @summary Test path parameter(s)
     * @param {string} pathString 
     * @param {number} pathInteger 
     * @param {TestsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPathEnumNonrefStringPathEnum} enumNonrefStringPath 
     * @param {StringEnumRef} enumRefStringPath 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPath(pathString: string, pathInteger: number, enumNonrefStringPath: TestsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPathEnumNonrefStringPathEnum, enumRefStringPath: StringEnumRef, options?: RawAxiosRequestConfig) {
        return PathApiFp(this.configuration).testsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPath(pathString, pathInteger, enumNonrefStringPath, enumRefStringPath, options).then((request) => request(this.axios, this.basePath));
    }
}

export const TestsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPathEnumNonrefStringPathEnum = {
    Success: 'success',
    Failure: 'failure',
    Unclassified: 'unclassified'
} as const;
export type TestsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPathEnumNonrefStringPathEnum = typeof TestsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPathEnumNonrefStringPathEnum[keyof typeof TestsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPathEnumNonrefStringPathEnum];


/**
 * QueryApi - axios parameter creator
 */
export const QueryApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {TestEnumRefStringEnumNonrefStringQueryEnum} [enumNonrefStringQuery] 
         * @param {StringEnumRef} [enumRefStringQuery] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testEnumRefString: async (enumNonrefStringQuery?: TestEnumRefStringEnumNonrefStringQueryEnum, enumRefStringQuery?: StringEnumRef, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/query/enum_ref_string`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            if (enumNonrefStringQuery !== undefined) {
                localVarQueryParameter['enum_nonref_string_query'] = enumNonrefStringQuery;
            }

            if (enumRefStringQuery !== undefined) {
                localVarQueryParameter['enum_ref_string_query'] = enumRefStringQuery;
            }

            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {string} [datetimeQuery] 
         * @param {string} [dateQuery] 
         * @param {string} [stringQuery] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testQueryDatetimeDateString: async (datetimeQuery?: string, dateQuery?: string, stringQuery?: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/query/datetime/date/string`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            if (datetimeQuery !== undefined) {
                localVarQueryParameter['datetime_query'] = (datetimeQuery as any instanceof Date) ?
                    (datetimeQuery as any).toISOString() :
                    datetimeQuery;
            }

            if (dateQuery !== undefined) {
                localVarQueryParameter['date_query'] = (dateQuery as any instanceof Date) ?
                    (dateQuery as any).toISOString().substring(0,10) :
                    dateQuery;
            }

            if (stringQuery !== undefined) {
                localVarQueryParameter['string_query'] = stringQuery;
            }

            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {number} [integerQuery] 
         * @param {boolean} [booleanQuery] 
         * @param {string} [stringQuery] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testQueryIntegerBooleanString: async (integerQuery?: number, booleanQuery?: boolean, stringQuery?: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/query/integer/boolean/string`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            if (integerQuery !== undefined) {
                localVarQueryParameter['integer_query'] = integerQuery;
            }

            if (booleanQuery !== undefined) {
                localVarQueryParameter['boolean_query'] = booleanQuery;
            }

            if (stringQuery !== undefined) {
                localVarQueryParameter['string_query'] = stringQuery;
            }

            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {Pet} [queryObject] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testQueryStyleDeepObjectExplodeTrueObject: async (queryObject?: Pet, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/query/style_deepObject/explode_true/object`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            if (queryObject !== undefined) {
                for (const [key, value] of Object.entries(queryObject)) {
                    localVarQueryParameter[key] = value;
                }
            }

            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter} [queryObject] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testQueryStyleDeepObjectExplodeTrueObjectAllOf: async (queryObject?: TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/query/style_deepObject/explode_true/object/allOf`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            if (queryObject !== undefined) {
                for (const [key, value] of Object.entries(queryObject)) {
                    localVarQueryParameter[key] = value;
                }
            }

            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {Array<number>} [queryObject] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testQueryStyleFormExplodeFalseArrayInteger: async (queryObject?: Array<number>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/query/style_form/explode_false/array_integer`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            if (queryObject) {
                localVarQueryParameter['query_object'] = queryObject.join(COLLECTION_FORMATS.csv);
            }

            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {Array<string>} [queryObject] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testQueryStyleFormExplodeFalseArrayString: async (queryObject?: Array<string>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/query/style_form/explode_false/array_string`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            if (queryObject) {
                localVarQueryParameter['query_object'] = queryObject.join(COLLECTION_FORMATS.csv);
            }

            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter} [queryObject] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testQueryStyleFormExplodeTrueArrayString: async (queryObject?: TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/query/style_form/explode_true/array_string`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            if (queryObject !== undefined) {
                for (const [key, value] of Object.entries(queryObject)) {
                    localVarQueryParameter[key] = value;
                }
            }

            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {Pet} [queryObject] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testQueryStyleFormExplodeTrueObject: async (queryObject?: Pet, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/query/style_form/explode_true/object`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            if (queryObject !== undefined) {
                for (const [key, value] of Object.entries(queryObject)) {
                    localVarQueryParameter[key] = value;
                }
            }

            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {DataQuery} [queryObject] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testQueryStyleFormExplodeTrueObjectAllOf: async (queryObject?: DataQuery, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/query/style_form/explode_true/object/allOf`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            if (queryObject !== undefined) {
                for (const [key, value] of Object.entries(queryObject)) {
                    localVarQueryParameter[key] = value;
                }
            }

            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {Pet} [jsonSerializedObjectRefStringQuery] 
         * @param {Array<Pet>} [jsonSerializedObjectArrayRefStringQuery] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testQueryStyleJsonSerializationObject: async (jsonSerializedObjectRefStringQuery?: Pet, jsonSerializedObjectArrayRefStringQuery?: Array<Pet>, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/query/style_jsonSerialization/object`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;

            if (jsonSerializedObjectRefStringQuery !== undefined) {
                localVarQueryParameter['json_serialized_object_ref_string_query'] = jsonSerializedObjectRefStringQuery;
            }

            if (jsonSerializedObjectArrayRefStringQuery) {
                localVarQueryParameter['json_serialized_object_array_ref_string_query'] = jsonSerializedObjectArrayRefStringQuery.join(COLLECTION_FORMATS.csv);
            }

            localVarHeaderParameter['Accept'] = 'text/plain';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * QueryApi - functional programming interface
 */
export const QueryApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = QueryApiAxiosParamCreator(configuration)
    return {
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {TestEnumRefStringEnumNonrefStringQueryEnum} [enumNonrefStringQuery] 
         * @param {StringEnumRef} [enumRefStringQuery] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testEnumRefString(enumNonrefStringQuery?: TestEnumRefStringEnumNonrefStringQueryEnum, enumRefStringQuery?: StringEnumRef, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testEnumRefString(enumNonrefStringQuery, enumRefStringQuery, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['QueryApi.testEnumRefString']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {string} [datetimeQuery] 
         * @param {string} [dateQuery] 
         * @param {string} [stringQuery] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testQueryDatetimeDateString(datetimeQuery?: string, dateQuery?: string, stringQuery?: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testQueryDatetimeDateString(datetimeQuery, dateQuery, stringQuery, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['QueryApi.testQueryDatetimeDateString']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {number} [integerQuery] 
         * @param {boolean} [booleanQuery] 
         * @param {string} [stringQuery] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testQueryIntegerBooleanString(integerQuery?: number, booleanQuery?: boolean, stringQuery?: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testQueryIntegerBooleanString(integerQuery, booleanQuery, stringQuery, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['QueryApi.testQueryIntegerBooleanString']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {Pet} [queryObject] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testQueryStyleDeepObjectExplodeTrueObject(queryObject?: Pet, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testQueryStyleDeepObjectExplodeTrueObject(queryObject, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['QueryApi.testQueryStyleDeepObjectExplodeTrueObject']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter} [queryObject] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testQueryStyleDeepObjectExplodeTrueObjectAllOf(queryObject?: TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testQueryStyleDeepObjectExplodeTrueObjectAllOf(queryObject, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['QueryApi.testQueryStyleDeepObjectExplodeTrueObjectAllOf']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {Array<number>} [queryObject] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testQueryStyleFormExplodeFalseArrayInteger(queryObject?: Array<number>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testQueryStyleFormExplodeFalseArrayInteger(queryObject, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['QueryApi.testQueryStyleFormExplodeFalseArrayInteger']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {Array<string>} [queryObject] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testQueryStyleFormExplodeFalseArrayString(queryObject?: Array<string>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testQueryStyleFormExplodeFalseArrayString(queryObject, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['QueryApi.testQueryStyleFormExplodeFalseArrayString']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter} [queryObject] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testQueryStyleFormExplodeTrueArrayString(queryObject?: TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testQueryStyleFormExplodeTrueArrayString(queryObject, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['QueryApi.testQueryStyleFormExplodeTrueArrayString']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {Pet} [queryObject] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testQueryStyleFormExplodeTrueObject(queryObject?: Pet, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testQueryStyleFormExplodeTrueObject(queryObject, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['QueryApi.testQueryStyleFormExplodeTrueObject']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {DataQuery} [queryObject] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testQueryStyleFormExplodeTrueObjectAllOf(queryObject?: DataQuery, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testQueryStyleFormExplodeTrueObjectAllOf(queryObject, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['QueryApi.testQueryStyleFormExplodeTrueObjectAllOf']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {Pet} [jsonSerializedObjectRefStringQuery] 
         * @param {Array<Pet>} [jsonSerializedObjectArrayRefStringQuery] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async testQueryStyleJsonSerializationObject(jsonSerializedObjectRefStringQuery?: Pet, jsonSerializedObjectArrayRefStringQuery?: Array<Pet>, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.testQueryStyleJsonSerializationObject(jsonSerializedObjectRefStringQuery, jsonSerializedObjectArrayRefStringQuery, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['QueryApi.testQueryStyleJsonSerializationObject']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * QueryApi - factory interface
 */
export const QueryApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = QueryApiFp(configuration)
    return {
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {TestEnumRefStringEnumNonrefStringQueryEnum} [enumNonrefStringQuery] 
         * @param {StringEnumRef} [enumRefStringQuery] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testEnumRefString(enumNonrefStringQuery?: TestEnumRefStringEnumNonrefStringQueryEnum, enumRefStringQuery?: StringEnumRef, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testEnumRefString(enumNonrefStringQuery, enumRefStringQuery, options).then((request) => request(axios, basePath));
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {string} [datetimeQuery] 
         * @param {string} [dateQuery] 
         * @param {string} [stringQuery] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testQueryDatetimeDateString(datetimeQuery?: string, dateQuery?: string, stringQuery?: string, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testQueryDatetimeDateString(datetimeQuery, dateQuery, stringQuery, options).then((request) => request(axios, basePath));
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {number} [integerQuery] 
         * @param {boolean} [booleanQuery] 
         * @param {string} [stringQuery] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testQueryIntegerBooleanString(integerQuery?: number, booleanQuery?: boolean, stringQuery?: string, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testQueryIntegerBooleanString(integerQuery, booleanQuery, stringQuery, options).then((request) => request(axios, basePath));
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {Pet} [queryObject] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testQueryStyleDeepObjectExplodeTrueObject(queryObject?: Pet, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testQueryStyleDeepObjectExplodeTrueObject(queryObject, options).then((request) => request(axios, basePath));
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter} [queryObject] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testQueryStyleDeepObjectExplodeTrueObjectAllOf(queryObject?: TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testQueryStyleDeepObjectExplodeTrueObjectAllOf(queryObject, options).then((request) => request(axios, basePath));
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {Array<number>} [queryObject] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testQueryStyleFormExplodeFalseArrayInteger(queryObject?: Array<number>, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testQueryStyleFormExplodeFalseArrayInteger(queryObject, options).then((request) => request(axios, basePath));
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {Array<string>} [queryObject] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testQueryStyleFormExplodeFalseArrayString(queryObject?: Array<string>, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testQueryStyleFormExplodeFalseArrayString(queryObject, options).then((request) => request(axios, basePath));
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter} [queryObject] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testQueryStyleFormExplodeTrueArrayString(queryObject?: TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testQueryStyleFormExplodeTrueArrayString(queryObject, options).then((request) => request(axios, basePath));
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {Pet} [queryObject] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testQueryStyleFormExplodeTrueObject(queryObject?: Pet, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testQueryStyleFormExplodeTrueObject(queryObject, options).then((request) => request(axios, basePath));
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {DataQuery} [queryObject] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testQueryStyleFormExplodeTrueObjectAllOf(queryObject?: DataQuery, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testQueryStyleFormExplodeTrueObjectAllOf(queryObject, options).then((request) => request(axios, basePath));
        },
        /**
         * Test query parameter(s)
         * @summary Test query parameter(s)
         * @param {Pet} [jsonSerializedObjectRefStringQuery] 
         * @param {Array<Pet>} [jsonSerializedObjectArrayRefStringQuery] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        testQueryStyleJsonSerializationObject(jsonSerializedObjectRefStringQuery?: Pet, jsonSerializedObjectArrayRefStringQuery?: Array<Pet>, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.testQueryStyleJsonSerializationObject(jsonSerializedObjectRefStringQuery, jsonSerializedObjectArrayRefStringQuery, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * QueryApi - object-oriented interface
 */
export class QueryApi extends BaseAPI {
    /**
     * Test query parameter(s)
     * @summary Test query parameter(s)
     * @param {TestEnumRefStringEnumNonrefStringQueryEnum} [enumNonrefStringQuery] 
     * @param {StringEnumRef} [enumRefStringQuery] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testEnumRefString(enumNonrefStringQuery?: TestEnumRefStringEnumNonrefStringQueryEnum, enumRefStringQuery?: StringEnumRef, options?: RawAxiosRequestConfig) {
        return QueryApiFp(this.configuration).testEnumRefString(enumNonrefStringQuery, enumRefStringQuery, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Test query parameter(s)
     * @summary Test query parameter(s)
     * @param {string} [datetimeQuery] 
     * @param {string} [dateQuery] 
     * @param {string} [stringQuery] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testQueryDatetimeDateString(datetimeQuery?: string, dateQuery?: string, stringQuery?: string, options?: RawAxiosRequestConfig) {
        return QueryApiFp(this.configuration).testQueryDatetimeDateString(datetimeQuery, dateQuery, stringQuery, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Test query parameter(s)
     * @summary Test query parameter(s)
     * @param {number} [integerQuery] 
     * @param {boolean} [booleanQuery] 
     * @param {string} [stringQuery] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testQueryIntegerBooleanString(integerQuery?: number, booleanQuery?: boolean, stringQuery?: string, options?: RawAxiosRequestConfig) {
        return QueryApiFp(this.configuration).testQueryIntegerBooleanString(integerQuery, booleanQuery, stringQuery, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Test query parameter(s)
     * @summary Test query parameter(s)
     * @param {Pet} [queryObject] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testQueryStyleDeepObjectExplodeTrueObject(queryObject?: Pet, options?: RawAxiosRequestConfig) {
        return QueryApiFp(this.configuration).testQueryStyleDeepObjectExplodeTrueObject(queryObject, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Test query parameter(s)
     * @summary Test query parameter(s)
     * @param {TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter} [queryObject] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testQueryStyleDeepObjectExplodeTrueObjectAllOf(queryObject?: TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter, options?: RawAxiosRequestConfig) {
        return QueryApiFp(this.configuration).testQueryStyleDeepObjectExplodeTrueObjectAllOf(queryObject, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Test query parameter(s)
     * @summary Test query parameter(s)
     * @param {Array<number>} [queryObject] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testQueryStyleFormExplodeFalseArrayInteger(queryObject?: Array<number>, options?: RawAxiosRequestConfig) {
        return QueryApiFp(this.configuration).testQueryStyleFormExplodeFalseArrayInteger(queryObject, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Test query parameter(s)
     * @summary Test query parameter(s)
     * @param {Array<string>} [queryObject] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testQueryStyleFormExplodeFalseArrayString(queryObject?: Array<string>, options?: RawAxiosRequestConfig) {
        return QueryApiFp(this.configuration).testQueryStyleFormExplodeFalseArrayString(queryObject, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Test query parameter(s)
     * @summary Test query parameter(s)
     * @param {TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter} [queryObject] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testQueryStyleFormExplodeTrueArrayString(queryObject?: TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter, options?: RawAxiosRequestConfig) {
        return QueryApiFp(this.configuration).testQueryStyleFormExplodeTrueArrayString(queryObject, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Test query parameter(s)
     * @summary Test query parameter(s)
     * @param {Pet} [queryObject] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testQueryStyleFormExplodeTrueObject(queryObject?: Pet, options?: RawAxiosRequestConfig) {
        return QueryApiFp(this.configuration).testQueryStyleFormExplodeTrueObject(queryObject, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Test query parameter(s)
     * @summary Test query parameter(s)
     * @param {DataQuery} [queryObject] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testQueryStyleFormExplodeTrueObjectAllOf(queryObject?: DataQuery, options?: RawAxiosRequestConfig) {
        return QueryApiFp(this.configuration).testQueryStyleFormExplodeTrueObjectAllOf(queryObject, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Test query parameter(s)
     * @summary Test query parameter(s)
     * @param {Pet} [jsonSerializedObjectRefStringQuery] 
     * @param {Array<Pet>} [jsonSerializedObjectArrayRefStringQuery] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public testQueryStyleJsonSerializationObject(jsonSerializedObjectRefStringQuery?: Pet, jsonSerializedObjectArrayRefStringQuery?: Array<Pet>, options?: RawAxiosRequestConfig) {
        return QueryApiFp(this.configuration).testQueryStyleJsonSerializationObject(jsonSerializedObjectRefStringQuery, jsonSerializedObjectArrayRefStringQuery, options).then((request) => request(this.axios, this.basePath));
    }
}

export const TestEnumRefStringEnumNonrefStringQueryEnum = {
    Success: 'success',
    Failure: 'failure',
    Unclassified: 'unclassified'
} as const;
export type TestEnumRefStringEnumNonrefStringQueryEnum = typeof TestEnumRefStringEnumNonrefStringQueryEnum[keyof typeof TestEnumRefStringEnumNonrefStringQueryEnum];


