# openapi_client

OpenapiClient - the Ruby gem for the Echo Server API

Echo Server API

This SDK is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 1.0.0
- Generator version: 7.20.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.RubyClientCodegen

## Installation

### Build a gem

To build the Ruby code into a gem:

```shell
gem build openapi_client.gemspec
```

Then either install the gem locally:

```shell
gem install ./openapi_client-1.0.0.gem
```

(for development, run `gem install --dev ./openapi_client-1.0.0.gem` to install the development dependencies)

or publish the gem to a gem hosting service, e.g. [RubyGems](https://rubygems.org/).

Finally add this to the Gemfile:

    gem 'openapi_client', '~> 1.0.0'

### Install from Git

If the Ruby gem is hosted at a git repository: https://github.com/GIT_USER_ID/GIT_REPO_ID, then add the following in the Gemfile:

    gem 'openapi_client', :git => 'https://github.com/GIT_USER_ID/GIT_REPO_ID.git'

### Include the Ruby code directly

Include the Ruby code directly using `-I` as follows:

```shell
ruby -Ilib script.rb
```

## Getting Started

Please follow the [installation](#installation) procedure and then run the following code:

```ruby
# Load the gem
require 'openapi_client'

# Setup authorization
OpenapiClient.configure do |config|
  # Configure HTTP basic authorization: http_auth
  config.username = 'YOUR_USERNAME'
  config.password = 'YOUR_PASSWORD'
  # Configure httpx session
  config.configure_session { |session| 'YOUR CONNECTION CONFIG PROC' }
end

api_instance = OpenapiClient::AuthApi.new

begin
  #To test HTTP basic authentication
  result = api_instance.test_auth_http_basic
  p result
rescue OpenapiClient::ApiError => e
  puts "Exception when calling AuthApi->test_auth_http_basic: #{e}"
end

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:3000*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*OpenapiClient::AuthApi* | [**test_auth_http_basic**](docs/AuthApi.md#test_auth_http_basic) | **POST** /auth/http/basic | To test HTTP basic authentication
*OpenapiClient::AuthApi* | [**test_auth_http_bearer**](docs/AuthApi.md#test_auth_http_bearer) | **POST** /auth/http/bearer | To test HTTP bearer authentication
*OpenapiClient::BodyApi* | [**test_binary_gif**](docs/BodyApi.md#test_binary_gif) | **POST** /binary/gif | Test binary (gif) response body
*OpenapiClient::BodyApi* | [**test_body_application_octetstream_binary**](docs/BodyApi.md#test_body_application_octetstream_binary) | **POST** /body/application/octetstream/binary | Test body parameter(s)
*OpenapiClient::BodyApi* | [**test_body_multipart_formdata_array_of_binary**](docs/BodyApi.md#test_body_multipart_formdata_array_of_binary) | **POST** /body/application/octetstream/array_of_binary | Test array of binary in multipart mime
*OpenapiClient::BodyApi* | [**test_body_multipart_formdata_single_binary**](docs/BodyApi.md#test_body_multipart_formdata_single_binary) | **POST** /body/application/octetstream/single_binary | Test single binary in multipart mime
*OpenapiClient::BodyApi* | [**test_echo_body_all_of_pet**](docs/BodyApi.md#test_echo_body_all_of_pet) | **POST** /echo/body/allOf/Pet | Test body parameter(s)
*OpenapiClient::BodyApi* | [**test_echo_body_free_form_object_response_string**](docs/BodyApi.md#test_echo_body_free_form_object_response_string) | **POST** /echo/body/FreeFormObject/response_string | Test free form object
*OpenapiClient::BodyApi* | [**test_echo_body_pet**](docs/BodyApi.md#test_echo_body_pet) | **POST** /echo/body/Pet | Test body parameter(s)
*OpenapiClient::BodyApi* | [**test_echo_body_pet_response_string**](docs/BodyApi.md#test_echo_body_pet_response_string) | **POST** /echo/body/Pet/response_string | Test empty response body
*OpenapiClient::BodyApi* | [**test_echo_body_string_enum**](docs/BodyApi.md#test_echo_body_string_enum) | **POST** /echo/body/string_enum | Test string enum response body
*OpenapiClient::BodyApi* | [**test_echo_body_tag_response_string**](docs/BodyApi.md#test_echo_body_tag_response_string) | **POST** /echo/body/Tag/response_string | Test empty json (request body)
*OpenapiClient::FormApi* | [**test_form_integer_boolean_string**](docs/FormApi.md#test_form_integer_boolean_string) | **POST** /form/integer/boolean/string | Test form parameter(s)
*OpenapiClient::FormApi* | [**test_form_object_multipart**](docs/FormApi.md#test_form_object_multipart) | **POST** /form/object/multipart | Test form parameter(s) for multipart schema
*OpenapiClient::FormApi* | [**test_form_oneof**](docs/FormApi.md#test_form_oneof) | **POST** /form/oneof | Test form parameter(s) for oneOf schema
*OpenapiClient::HeaderApi* | [**test_header_integer_boolean_string_enums**](docs/HeaderApi.md#test_header_integer_boolean_string_enums) | **GET** /header/integer/boolean/string/enums | Test header parameter(s)
*OpenapiClient::PathApi* | [**tests_path_string_path_string_integer_path_integer_enum_nonref_string_path_enum_ref_string_path**](docs/PathApi.md#tests_path_string_path_string_integer_path_integer_enum_nonref_string_path_enum_ref_string_path) | **GET** /path/string/{path_string}/integer/{path_integer}/{enum_nonref_string_path}/{enum_ref_string_path} | Test path parameter(s)
*OpenapiClient::QueryApi* | [**test_enum_ref_string**](docs/QueryApi.md#test_enum_ref_string) | **GET** /query/enum_ref_string | Test query parameter(s)
*OpenapiClient::QueryApi* | [**test_query_datetime_date_string**](docs/QueryApi.md#test_query_datetime_date_string) | **GET** /query/datetime/date/string | Test query parameter(s)
*OpenapiClient::QueryApi* | [**test_query_integer_boolean_string**](docs/QueryApi.md#test_query_integer_boolean_string) | **GET** /query/integer/boolean/string | Test query parameter(s)
*OpenapiClient::QueryApi* | [**test_query_style_deep_object_explode_true_object**](docs/QueryApi.md#test_query_style_deep_object_explode_true_object) | **GET** /query/style_deepObject/explode_true/object | Test query parameter(s)
*OpenapiClient::QueryApi* | [**test_query_style_deep_object_explode_true_object_all_of**](docs/QueryApi.md#test_query_style_deep_object_explode_true_object_all_of) | **GET** /query/style_deepObject/explode_true/object/allOf | Test query parameter(s)
*OpenapiClient::QueryApi* | [**test_query_style_form_explode_false_array_integer**](docs/QueryApi.md#test_query_style_form_explode_false_array_integer) | **GET** /query/style_form/explode_false/array_integer | Test query parameter(s)
*OpenapiClient::QueryApi* | [**test_query_style_form_explode_false_array_string**](docs/QueryApi.md#test_query_style_form_explode_false_array_string) | **GET** /query/style_form/explode_false/array_string | Test query parameter(s)
*OpenapiClient::QueryApi* | [**test_query_style_form_explode_true_array_string**](docs/QueryApi.md#test_query_style_form_explode_true_array_string) | **GET** /query/style_form/explode_true/array_string | Test query parameter(s)
*OpenapiClient::QueryApi* | [**test_query_style_form_explode_true_object**](docs/QueryApi.md#test_query_style_form_explode_true_object) | **GET** /query/style_form/explode_true/object | Test query parameter(s)
*OpenapiClient::QueryApi* | [**test_query_style_form_explode_true_object_all_of**](docs/QueryApi.md#test_query_style_form_explode_true_object_all_of) | **GET** /query/style_form/explode_true/object/allOf | Test query parameter(s)
*OpenapiClient::QueryApi* | [**test_query_style_json_serialization_object**](docs/QueryApi.md#test_query_style_json_serialization_object) | **GET** /query/style_jsonSerialization/object | Test query parameter(s)


## Documentation for Models

 - [OpenapiClient::Bird](docs/Bird.md)
 - [OpenapiClient::Category](docs/Category.md)
 - [OpenapiClient::DataQuery](docs/DataQuery.md)
 - [OpenapiClient::DefaultValue](docs/DefaultValue.md)
 - [OpenapiClient::NumberPropertiesOnly](docs/NumberPropertiesOnly.md)
 - [OpenapiClient::Pet](docs/Pet.md)
 - [OpenapiClient::Query](docs/Query.md)
 - [OpenapiClient::StringEnumRef](docs/StringEnumRef.md)
 - [OpenapiClient::Tag](docs/Tag.md)
 - [OpenapiClient::TestFormObjectMultipartRequestMarker](docs/TestFormObjectMultipartRequestMarker.md)
 - [OpenapiClient::TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter](docs/TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter.md)
 - [OpenapiClient::TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter](docs/TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter.md)


## Documentation for Authorization


Authentication schemes defined for the API:
### http_auth

- **Type**: HTTP basic authentication

### http_bearer_auth

- **Type**: Bearer authentication

