#' Echo Server API
#'
#' Echo Server API
#'
#' The version of the OpenAPI document: 0.1.0
#' Contact: team@openapitools.org
#' Generated by: https://openapi-generator.tech
#'
#' @docType class
#' @title Form operations
#' @description FormApi
#' @format An \code{R6Class} generator object
#' @field api_client Handles the client-server communication.
#'
#' @examples
#' \dontrun{
#' ####################  TestFormIntegerBooleanString  ####################
#'
#' library(openapi)
#' var_integer_form <- 56 # integer |  (Optional)
#' var_boolean_form <- "boolean_form_example" # character |  (Optional)
#' var_string_form <- "string_form_example" # character |  (Optional)
#'
#' #Test form parameter(s)
#' api_instance <- FormApi$new()
#'
#' # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#' # result <- api_instance$TestFormIntegerBooleanString(integer_form = var_integer_form, boolean_form = var_boolean_form, string_form = var_string_formdata_file = "result.txt")
#' result <- api_instance$TestFormIntegerBooleanString(integer_form = var_integer_form, boolean_form = var_boolean_form, string_form = var_string_form)
#' dput(result)
#'
#'
#' ####################  TestFormObjectMultipart  ####################
#'
#' library(openapi)
#' var_marker <- test_form_object_multipart_request_marker$new("name_example") # TestFormObjectMultipartRequestMarker | 
#'
#' #Test form parameter(s) for multipart schema
#' api_instance <- FormApi$new()
#'
#' # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#' # result <- api_instance$TestFormObjectMultipart(var_markerdata_file = "result.txt")
#' result <- api_instance$TestFormObjectMultipart(var_marker)
#' dput(result)
#'
#'
#' ####################  TestFormOneof  ####################
#'
#' library(openapi)
#' var_form1 <- "form1_example" # character |  (Optional)
#' var_form2 <- 56 # integer |  (Optional)
#' var_form3 <- "form3_example" # character |  (Optional)
#' var_form4 <- "form4_example" # character |  (Optional)
#' var_id <- 56 # integer |  (Optional)
#' var_name <- "name_example" # character |  (Optional)
#'
#' #Test form parameter(s) for oneOf schema
#' api_instance <- FormApi$new()
#'
#' # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#' # result <- api_instance$TestFormOneof(form1 = var_form1, form2 = var_form2, form3 = var_form3, form4 = var_form4, id = var_id, name = var_namedata_file = "result.txt")
#' result <- api_instance$TestFormOneof(form1 = var_form1, form2 = var_form2, form3 = var_form3, form4 = var_form4, id = var_id, name = var_name)
#' dput(result)
#'
#'
#' }
#' @importFrom R6 R6Class
#' @importFrom base64enc base64encode
#' @export
FormApi <- R6::R6Class(
  "FormApi",
  public = list(
    api_client = NULL,

    #' @description
    #' Initialize a new FormApi.
    #'
    #' @param api_client An instance of API client.
    initialize = function(api_client) {
      if (!missing(api_client)) {
        self$api_client <- api_client
      } else {
        self$api_client <- ApiClient$new()
      }
    },

    #' @description
    #' Test form parameter(s)
    #'
    #' @param integer_form (optional) No description
    #' @param boolean_form (optional) No description
    #' @param string_form (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return character
    TestFormIntegerBooleanString = function(integer_form = NULL, boolean_form = NULL, string_form = NULL, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$TestFormIntegerBooleanStringWithHttpInfo(integer_form, boolean_form, string_form, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Test form parameter(s)
    #'
    #' @param integer_form (optional) No description
    #' @param boolean_form (optional) No description
    #' @param string_form (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (character) with additional information such as HTTP status code, headers
    TestFormIntegerBooleanStringWithHttpInfo = function(integer_form = NULL, boolean_form = NULL, string_form = NULL, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (!missing(`integer_form`) && is.null(`integer_form`)) {
        stop("Invalid value for `integer_form` when calling FormApi$TestFormIntegerBooleanString, `integer_form` is not nullable")
      }

      if (!missing(`boolean_form`) && is.null(`boolean_form`)) {
        stop("Invalid value for `boolean_form` when calling FormApi$TestFormIntegerBooleanString, `boolean_form` is not nullable")
      }

      if (!missing(`string_form`) && is.null(`string_form`)) {
        stop("Invalid value for `string_form` when calling FormApi$TestFormIntegerBooleanString, `string_form` is not nullable")
      }

      form_params["integer_form"] <- `integer_form`
      form_params["boolean_form"] <- `boolean_form`
      form_params["string_form"] <- `string_form`
      local_var_url_path <- "/form/integer/boolean/string"

      # The Accept request HTTP header
      local_var_accepts <- list("text/plain")

      # The Content-Type representation header
      local_var_content_types <- list("application/x-www-form-urlencoded")

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "POST",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "character"),
          error = function(e) {
            stop("Failed to deserialize response")
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        ApiResponse$new(content = paste("Server returned ", local_var_resp$status_code, " response status code."),
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        ApiResponse$new(content = "API client error",
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (is.null(local_var_resp$response) || all(local_var_resp$response == "")) {
          local_var_resp$response <- "API server error"
        }
        return(local_var_resp)
      }
    },

    #' @description
    #' Test form parameter(s) for multipart schema
    #'
    #' @param marker 
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return character
    TestFormObjectMultipart = function(marker, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$TestFormObjectMultipartWithHttpInfo(marker, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Test form parameter(s) for multipart schema
    #'
    #' @param marker 
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (character) with additional information such as HTTP status code, headers
    TestFormObjectMultipartWithHttpInfo = function(marker, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`marker`)) {
        stop("Missing required parameter `marker`.")
      }

      if (!missing(`marker`) && is.null(`marker`)) {
        stop("Invalid value for `marker` when calling FormApi$TestFormObjectMultipart, `marker` is not nullable")
      }

      form_params["marker"] <- `marker`
      local_var_url_path <- "/form/object/multipart"

      # The Accept request HTTP header
      local_var_accepts <- list("text/plain")

      # The Content-Type representation header
      local_var_content_types <- list("multipart/form-data")

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "POST",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "character"),
          error = function(e) {
            stop("Failed to deserialize response")
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        ApiResponse$new(content = paste("Server returned ", local_var_resp$status_code, " response status code."),
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        ApiResponse$new(content = "API client error",
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (is.null(local_var_resp$response) || all(local_var_resp$response == "")) {
          local_var_resp$response <- "API server error"
        }
        return(local_var_resp)
      }
    },

    #' @description
    #' Test form parameter(s) for oneOf schema
    #'
    #' @param form1 (optional) No description
    #' @param form2 (optional) No description
    #' @param form3 (optional) No description
    #' @param form4 (optional) No description
    #' @param id (optional) No description
    #' @param name (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return character
    TestFormOneof = function(form1 = NULL, form2 = NULL, form3 = NULL, form4 = NULL, id = NULL, name = NULL, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$TestFormOneofWithHttpInfo(form1, form2, form3, form4, id, name, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Test form parameter(s) for oneOf schema
    #'
    #' @param form1 (optional) No description
    #' @param form2 (optional) No description
    #' @param form3 (optional) No description
    #' @param form4 (optional) No description
    #' @param id (optional) No description
    #' @param name (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (character) with additional information such as HTTP status code, headers
    TestFormOneofWithHttpInfo = function(form1 = NULL, form2 = NULL, form3 = NULL, form4 = NULL, id = NULL, name = NULL, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (!missing(`form1`) && is.null(`form1`)) {
        stop("Invalid value for `form1` when calling FormApi$TestFormOneof, `form1` is not nullable")
      }

      if (!missing(`form2`) && is.null(`form2`)) {
        stop("Invalid value for `form2` when calling FormApi$TestFormOneof, `form2` is not nullable")
      }

      if (!missing(`form3`) && is.null(`form3`)) {
        stop("Invalid value for `form3` when calling FormApi$TestFormOneof, `form3` is not nullable")
      }

      if (!missing(`form4`) && is.null(`form4`)) {
        stop("Invalid value for `form4` when calling FormApi$TestFormOneof, `form4` is not nullable")
      }

      if (!missing(`id`) && is.null(`id`)) {
        stop("Invalid value for `id` when calling FormApi$TestFormOneof, `id` is not nullable")
      }

      if (!missing(`name`) && is.null(`name`)) {
        stop("Invalid value for `name` when calling FormApi$TestFormOneof, `name` is not nullable")
      }

      form_params["form1"] <- `form1`
      form_params["form2"] <- `form2`
      form_params["form3"] <- `form3`
      form_params["form4"] <- `form4`
      form_params["id"] <- `id`
      form_params["name"] <- `name`
      local_var_url_path <- "/form/oneof"

      # The Accept request HTTP header
      local_var_accepts <- list("text/plain")

      # The Content-Type representation header
      local_var_content_types <- list("application/x-www-form-urlencoded")

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "POST",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "character"),
          error = function(e) {
            stop("Failed to deserialize response")
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        ApiResponse$new(content = paste("Server returned ", local_var_resp$status_code, " response status code."),
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        ApiResponse$new(content = "API client error",
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (is.null(local_var_resp$response) || all(local_var_resp$response == "")) {
          local_var_resp$response <- "API server error"
        }
        return(local_var_resp)
      }
    }
  )
)
