#' Echo Server API
#'
#' Echo Server API
#'
#' The version of the OpenAPI document: 0.1.0
#' Contact: team@openapitools.org
#' Generated by: https://openapi-generator.tech
#'
#' @docType class
#' @title Auth operations
#' @description AuthApi
#' @format An \code{R6Class} generator object
#' @field api_client Handles the client-server communication.
#'
#' @examples
#' \dontrun{
#' ####################  TestAuthHttpBasic  ####################
#'
#' library(openapi)
#'
#' #To test HTTP basic authentication
#' api_instance <- AuthApi$new()
#'
#' # Configure HTTP basic authorization: http_auth
#' api_instance$api_client$username <- Sys.getenv("USERNAME")
#' api_instance$api_client$password <- Sys.getenv("PASSWORD")
#'
#' # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#' # result <- api_instance$TestAuthHttpBasic(data_file = "result.txt")
#' result <- api_instance$TestAuthHttpBasic()
#' dput(result)
#'
#'
#' ####################  TestAuthHttpBearer  ####################
#'
#' library(openapi)
#'
#' #To test HTTP bearer authentication
#' api_instance <- AuthApi$new()
#'
#' # Configure HTTP bearer authorization: http_bearer_auth
#' api_instance$api_client$bearer_token <- Sys.getenv("BEARER_TOKEN")
#'
#' # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#' # result <- api_instance$TestAuthHttpBearer(data_file = "result.txt")
#' result <- api_instance$TestAuthHttpBearer()
#' dput(result)
#'
#'
#' }
#' @importFrom R6 R6Class
#' @importFrom base64enc base64encode
#' @export
AuthApi <- R6::R6Class(
  "AuthApi",
  public = list(
    api_client = NULL,

    #' @description
    #' Initialize a new AuthApi.
    #'
    #' @param api_client An instance of API client.
    initialize = function(api_client) {
      if (!missing(api_client)) {
        self$api_client <- api_client
      } else {
        self$api_client <- ApiClient$new()
      }
    },

    #' @description
    #' To test HTTP basic authentication
    #'
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return character
    TestAuthHttpBasic = function(data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$TestAuthHttpBasicWithHttpInfo(data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' To test HTTP basic authentication
    #'
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (character) with additional information such as HTTP status code, headers
    TestAuthHttpBasicWithHttpInfo = function(data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      local_var_url_path <- "/auth/http/basic"
      # HTTP basic auth
      if (!is.null(self$api_client$username) || !is.null(self$api_client$password)) {
        header_params["Authorization"] <- paste("Basic", base64enc::base64encode(charToRaw(paste(self$api_client$username, self$api_client$password, sep = ":"))))
      }

      # The Accept request HTTP header
      local_var_accepts <- list("text/plain")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "POST",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "character"),
          error = function(e) {
            stop("Failed to deserialize response")
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        ApiResponse$new(content = paste("Server returned ", local_var_resp$status_code, " response status code."),
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        ApiResponse$new(content = "API client error",
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (is.null(local_var_resp$response) || all(local_var_resp$response == "")) {
          local_var_resp$response <- "API server error"
        }
        return(local_var_resp)
      }
    },

    #' @description
    #' To test HTTP bearer authentication
    #'
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return character
    TestAuthHttpBearer = function(data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$TestAuthHttpBearerWithHttpInfo(data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' To test HTTP bearer authentication
    #'
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (character) with additional information such as HTTP status code, headers
    TestAuthHttpBearerWithHttpInfo = function(data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      local_var_url_path <- "/auth/http/bearer"
      # Bearer token
      if (!is.null(self$api_client$bearer_token)) {
        header_params["Authorization"] <- paste("Bearer", self$api_client$bearer_token, sep = " ")
      }

      # The Accept request HTTP header
      local_var_accepts <- list("text/plain")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "POST",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "character"),
          error = function(e) {
            stop("Failed to deserialize response")
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        ApiResponse$new(content = paste("Server returned ", local_var_resp$status_code, " response status code."),
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        ApiResponse$new(content = "API client error",
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (is.null(local_var_resp$response) || all(local_var_resp$response == "")) {
          local_var_resp$response <- "API server error"
        }
        return(local_var_resp)
      }
    }
  )
)
