# PSOpenAPITools - the PowerShell module for the Echo Server API

Echo Server API

This PowerShell module is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- SDK version: 0.1.2
- Generator version: 7.20.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.PowerShellClientCodegen

<a id="frameworks-supported"></a>
## Frameworks supported
- PowerShell 6.2 or later

<a id="dependencies"></a>
## Dependencies

<a id="installation"></a>
## Installation


To install from the source, run the following command to build and install the PowerShell module locally:
```powershell
Build.ps1
Import-Module -Name '.\src\PSOpenAPITools' -Verbose
```

To avoid function name collision, one can use `-Prefix`, e.g. `Import-Module -Name '.\src\PSOpenAPITools' -Prefix prefix`

To uninstall the module, simply run:
```powershell
Remove-Module -FullyQualifiedName @{ModuleName = "PSOpenAPITools"; ModuleVersion = "0.1.2"}
```

<a id="tests"></a>
## Tests

To install and run `Pester`, please execute the following commands in the terminal:

```powershell
Install-module -name Pester -force

Invoke-Pester
```

For troubleshooting, please run `$DebugPreference = 'Continue'` to turn on debugging and disable it with `$DebugPreference = 'SilentlyContinue'` when done with the troubleshooting.

## Documentation for API Endpoints

All URIs are relative to *http://localhost:3000*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthApi* | [**Test-AuthHttpBasic**](docs/AuthApi.md#Test-AuthHttpBasic) | **POST** /auth/http/basic | To test HTTP basic authentication
*AuthApi* | [**Test-AuthHttpBearer**](docs/AuthApi.md#Test-AuthHttpBearer) | **POST** /auth/http/bearer | To test HTTP bearer authentication
*BodyApi* | [**Test-BinaryGif**](docs/BodyApi.md#Test-BinaryGif) | **POST** /binary/gif | Test binary (gif) response body
*BodyApi* | [**Test-BodyApplicationOctetstreamBinary**](docs/BodyApi.md#Test-BodyApplicationOctetstreamBinary) | **POST** /body/application/octetstream/binary | Test body parameter(s)
*BodyApi* | [**Test-BodyMultipartFormdataArrayOfBinary**](docs/BodyApi.md#Test-BodyMultipartFormdataArrayOfBinary) | **POST** /body/application/octetstream/array_of_binary | Test array of binary in multipart mime
*BodyApi* | [**Test-BodyMultipartFormdataSingleBinary**](docs/BodyApi.md#Test-BodyMultipartFormdataSingleBinary) | **POST** /body/application/octetstream/single_binary | Test single binary in multipart mime
*BodyApi* | [**Test-EchoBodyFreeFormObjectResponseString**](docs/BodyApi.md#Test-EchoBodyFreeFormObjectResponseString) | **POST** /echo/body/FreeFormObject/response_string | Test free form object
*BodyApi* | [**Test-EchoBodyPet**](docs/BodyApi.md#Test-EchoBodyPet) | **POST** /echo/body/Pet | Test body parameter(s)
*BodyApi* | [**Test-EchoBodyPetResponseString**](docs/BodyApi.md#Test-EchoBodyPetResponseString) | **POST** /echo/body/Pet/response_string | Test empty response body
*BodyApi* | [**Test-EchoBodyTagResponseString**](docs/BodyApi.md#Test-EchoBodyTagResponseString) | **POST** /echo/body/Tag/response_string | Test empty json (request body)
*BodyApi* | [**Test-EchoBodyAllOfPet**](docs/BodyApi.md#Test-EchoBodyAllOfPet) | **POST** /echo/body/allOf/Pet | Test body parameter(s)
*BodyApi* | [**Test-EchoBodyStringEnum**](docs/BodyApi.md#Test-EchoBodyStringEnum) | **POST** /echo/body/string_enum | Test string enum response body
*FormApi* | [**Test-FormIntegerBooleanString**](docs/FormApi.md#Test-FormIntegerBooleanString) | **POST** /form/integer/boolean/string | Test form parameter(s)
*FormApi* | [**Test-FormObjectMultipart**](docs/FormApi.md#Test-FormObjectMultipart) | **POST** /form/object/multipart | Test form parameter(s) for multipart schema
*FormApi* | [**Test-FormOneof**](docs/FormApi.md#Test-FormOneof) | **POST** /form/oneof | Test form parameter(s) for oneOf schema
*HeaderApi* | [**Test-HeaderIntegerBooleanStringEnums**](docs/HeaderApi.md#Test-HeaderIntegerBooleanStringEnums) | **GET** /header/integer/boolean/string/enums | Test header parameter(s)
*PathApi* | [**Test-sPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPath**](docs/PathApi.md#Test-sPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPath) | **GET** /path/string/{path_string}/integer/{path_integer}/{enum_nonref_string_path}/{enum_ref_string_path} | Test path parameter(s)
*QueryApi* | [**Test-EnumRefString**](docs/QueryApi.md#Test-EnumRefString) | **GET** /query/enum_ref_string | Test query parameter(s)
*QueryApi* | [**Test-QueryDatetimeDateString**](docs/QueryApi.md#Test-QueryDatetimeDateString) | **GET** /query/datetime/date/string | Test query parameter(s)
*QueryApi* | [**Test-QueryIntegerBooleanString**](docs/QueryApi.md#Test-QueryIntegerBooleanString) | **GET** /query/integer/boolean/string | Test query parameter(s)
*QueryApi* | [**Test-QueryStyleDeepObjectExplodeTrueObject**](docs/QueryApi.md#Test-QueryStyleDeepObjectExplodeTrueObject) | **GET** /query/style_deepObject/explode_true/object | Test query parameter(s)
*QueryApi* | [**Test-QueryStyleDeepObjectExplodeTrueObjectAllOf**](docs/QueryApi.md#Test-QueryStyleDeepObjectExplodeTrueObjectAllOf) | **GET** /query/style_deepObject/explode_true/object/allOf | Test query parameter(s)
*QueryApi* | [**Test-QueryStyleFormExplodeFalseArrayInteger**](docs/QueryApi.md#Test-QueryStyleFormExplodeFalseArrayInteger) | **GET** /query/style_form/explode_false/array_integer | Test query parameter(s)
*QueryApi* | [**Test-QueryStyleFormExplodeFalseArrayString**](docs/QueryApi.md#Test-QueryStyleFormExplodeFalseArrayString) | **GET** /query/style_form/explode_false/array_string | Test query parameter(s)
*QueryApi* | [**Test-QueryStyleFormExplodeTrueArrayString**](docs/QueryApi.md#Test-QueryStyleFormExplodeTrueArrayString) | **GET** /query/style_form/explode_true/array_string | Test query parameter(s)
*QueryApi* | [**Test-QueryStyleFormExplodeTrueObject**](docs/QueryApi.md#Test-QueryStyleFormExplodeTrueObject) | **GET** /query/style_form/explode_true/object | Test query parameter(s)
*QueryApi* | [**Test-QueryStyleFormExplodeTrueObjectAllOf**](docs/QueryApi.md#Test-QueryStyleFormExplodeTrueObjectAllOf) | **GET** /query/style_form/explode_true/object/allOf | Test query parameter(s)
*QueryApi* | [**Test-QueryStyleJsonSerializationObject**](docs/QueryApi.md#Test-QueryStyleJsonSerializationObject) | **GET** /query/style_jsonSerialization/object | Test query parameter(s)


## Documentation for Models

 - [PSOpenAPITools\Model.Bird](docs/Bird.md)
 - [PSOpenAPITools\Model.Category](docs/Category.md)
 - [PSOpenAPITools\Model.DataQuery](docs/DataQuery.md)
 - [PSOpenAPITools\Model.DefaultValue](docs/DefaultValue.md)
 - [PSOpenAPITools\Model.NumberPropertiesOnly](docs/NumberPropertiesOnly.md)
 - [PSOpenAPITools\Model.Pet](docs/Pet.md)
 - [PSOpenAPITools\Model.Query](docs/Query.md)
 - [PSOpenAPITools\Model.StringEnumRef](docs/StringEnumRef.md)
 - [PSOpenAPITools\Model.Tag](docs/Tag.md)
 - [PSOpenAPITools\Model.TestFormObjectMultipartRequestMarker](docs/TestFormObjectMultipartRequestMarker.md)
 - [PSOpenAPITools\Model.TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter](docs/TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter.md)
 - [PSOpenAPITools\Model.TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter](docs/TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter.md)


<a id="documentation-for-authorization"></a>
## Documentation for Authorization


Authentication schemes defined for the API:
<a id="http_auth"></a>
### http_auth


- **Type**: HTTP basic authentication

<a id="http_bearer_auth"></a>
### http_bearer_auth


- **Type**: HTTP Bearer Token authentication

