<?php
/**
 * HeaderApi
 * PHP version 8.1
 *
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Echo Server API
 *
 * Echo Server API
 *
 * The version of the OpenAPI document: 0.1.0
 * Contact: team@openapitools.org
 * @generated Generated by: https://openapi-generator.tech
 * Generator version: 7.20.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use InvalidArgumentException;
use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\FormDataProcessor;
use OpenAPI\Client\ObjectSerializer;

/**
 * HeaderApi Class Doc Comment
 *
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class HeaderApi
{
    /**
     * @var ClientInterface
     */
    protected ClientInterface $client;

    /**
     * @var Configuration
     */
    protected Configuration $config;

    /**
     * @var HeaderSelector
     */
    protected HeaderSelector $headerSelector;

    /**
     * @var int Host index
     */
    protected int $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'testHeaderIntegerBooleanStringEnums' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface|null $client
     * @param Configuration|null   $config
     * @param HeaderSelector|null  $selector
     * @param int                  $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex(int $hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex(): int
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig(): Configuration
    {
        return $this->config;
    }

    /**
     * Operation testHeaderIntegerBooleanStringEnums
     *
     * Test header parameter(s)
     *
     * @param  int|null $integer_header integer_header (optional)
     * @param  bool|null $boolean_header boolean_header (optional)
     * @param  string|null $string_header string_header (optional)
     * @param  string|null $enum_nonref_string_header enum_nonref_string_header (optional)
     * @param  \OpenAPI\Client\Model\StringEnumRef|null $enum_ref_string_header enum_ref_string_header (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testHeaderIntegerBooleanStringEnums'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return string
     */
    public function testHeaderIntegerBooleanStringEnums(
        ?int $integer_header = null,
        ?bool $boolean_header = null,
        ?string $string_header = null,
        ?string $enum_nonref_string_header = null,
        ?\OpenAPI\Client\Model\StringEnumRef $enum_ref_string_header = null,
        string $contentType = self::contentTypes['testHeaderIntegerBooleanStringEnums'][0]
    ): string
    {
        list($response) = $this->testHeaderIntegerBooleanStringEnumsWithHttpInfo($integer_header, $boolean_header, $string_header, $enum_nonref_string_header, $enum_ref_string_header, $contentType);
        return $response;
    }

    /**
     * Operation testHeaderIntegerBooleanStringEnumsWithHttpInfo
     *
     * Test header parameter(s)
     *
     * @param  int|null $integer_header (optional)
     * @param  bool|null $boolean_header (optional)
     * @param  string|null $string_header (optional)
     * @param  string|null $enum_nonref_string_header (optional)
     * @param  \OpenAPI\Client\Model\StringEnumRef|null $enum_ref_string_header (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testHeaderIntegerBooleanStringEnums'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function testHeaderIntegerBooleanStringEnumsWithHttpInfo(
        ?int $integer_header = null,
        ?bool $boolean_header = null,
        ?string $string_header = null,
        ?string $enum_nonref_string_header = null,
        ?\OpenAPI\Client\Model\StringEnumRef $enum_ref_string_header = null,
        string $contentType = self::contentTypes['testHeaderIntegerBooleanStringEnums'][0]
    ): array
    {
        $request = $this->testHeaderIntegerBooleanStringEnumsRequest($integer_header, $boolean_header, $string_header, $enum_nonref_string_header, $enum_ref_string_header, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testHeaderIntegerBooleanStringEnumsAsync
     *
     * Test header parameter(s)
     *
     * @param  int|null $integer_header (optional)
     * @param  bool|null $boolean_header (optional)
     * @param  string|null $string_header (optional)
     * @param  string|null $enum_nonref_string_header (optional)
     * @param  \OpenAPI\Client\Model\StringEnumRef|null $enum_ref_string_header (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testHeaderIntegerBooleanStringEnums'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testHeaderIntegerBooleanStringEnumsAsync(
        ?int $integer_header = null,
        ?bool $boolean_header = null,
        ?string $string_header = null,
        ?string $enum_nonref_string_header = null,
        ?\OpenAPI\Client\Model\StringEnumRef $enum_ref_string_header = null,
        string $contentType = self::contentTypes['testHeaderIntegerBooleanStringEnums'][0]
    ): PromiseInterface
    {
        return $this->testHeaderIntegerBooleanStringEnumsAsyncWithHttpInfo($integer_header, $boolean_header, $string_header, $enum_nonref_string_header, $enum_ref_string_header, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testHeaderIntegerBooleanStringEnumsAsyncWithHttpInfo
     *
     * Test header parameter(s)
     *
     * @param  int|null $integer_header (optional)
     * @param  bool|null $boolean_header (optional)
     * @param  string|null $string_header (optional)
     * @param  string|null $enum_nonref_string_header (optional)
     * @param  \OpenAPI\Client\Model\StringEnumRef|null $enum_ref_string_header (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testHeaderIntegerBooleanStringEnums'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testHeaderIntegerBooleanStringEnumsAsyncWithHttpInfo(
        ?int $integer_header = null,
        ?bool $boolean_header = null,
        ?string $string_header = null,
        ?string $enum_nonref_string_header = null,
        ?\OpenAPI\Client\Model\StringEnumRef $enum_ref_string_header = null,
        string $contentType = self::contentTypes['testHeaderIntegerBooleanStringEnums'][0]
    ): PromiseInterface
    {
        $returnType = 'string';
        $request = $this->testHeaderIntegerBooleanStringEnumsRequest($integer_header, $boolean_header, $string_header, $enum_nonref_string_header, $enum_ref_string_header, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testHeaderIntegerBooleanStringEnums'
     *
     * @param  int|null $integer_header (optional)
     * @param  bool|null $boolean_header (optional)
     * @param  string|null $string_header (optional)
     * @param  string|null $enum_nonref_string_header (optional)
     * @param  \OpenAPI\Client\Model\StringEnumRef|null $enum_ref_string_header (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testHeaderIntegerBooleanStringEnums'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testHeaderIntegerBooleanStringEnumsRequest(
        ?int $integer_header = null,
        ?bool $boolean_header = null,
        ?string $string_header = null,
        ?string $enum_nonref_string_header = null,
        ?\OpenAPI\Client\Model\StringEnumRef $enum_ref_string_header = null,
        string $contentType = self::contentTypes['testHeaderIntegerBooleanStringEnums'][0]
    ): Request
    {







        $resourcePath = '/header/integer/boolean/string/enums';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($integer_header !== null) {
            $headerParams['integer_header'] = ObjectSerializer::toHeaderValue($integer_header);
        }
        // header params
        if ($boolean_header !== null) {
            $headerParams['boolean_header'] = ObjectSerializer::toHeaderValue($boolean_header);
        }
        // header params
        if ($string_header !== null) {
            $headerParams['string_header'] = ObjectSerializer::toHeaderValue($string_header);
        }
        // header params
        if ($enum_nonref_string_header !== null) {
            $headerParams['enum_nonref_string_header'] = ObjectSerializer::toHeaderValue($enum_nonref_string_header);
        }
        // header params
        if ($enum_ref_string_header !== null) {
            $headerParams['enum_ref_string_header'] = ObjectSerializer::toHeaderValue($enum_ref_string_header->value);
        }



        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption(): array
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response,
    ): array {
        if (in_array($dataType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode,
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
