<?php
/**
 * BodyApi
 * PHP version 8.1
 *
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Echo Server API
 *
 * Echo Server API
 *
 * The version of the OpenAPI document: 0.1.0
 * Contact: team@openapitools.org
 * @generated Generated by: https://openapi-generator.tech
 * Generator version: 7.20.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use InvalidArgumentException;
use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\FormDataProcessor;
use OpenAPI\Client\ObjectSerializer;

/**
 * BodyApi Class Doc Comment
 *
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class BodyApi
{
    /**
     * @var ClientInterface
     */
    protected ClientInterface $client;

    /**
     * @var Configuration
     */
    protected Configuration $config;

    /**
     * @var HeaderSelector
     */
    protected HeaderSelector $headerSelector;

    /**
     * @var int Host index
     */
    protected int $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'testBinaryGif' => [
            'application/json',
        ],
        'testBodyApplicationOctetstreamBinary' => [
            'application/octet-stream',
        ],
        'testBodyMultipartFormdataArrayOfBinary' => [
            'multipart/form-data',
        ],
        'testBodyMultipartFormdataSingleBinary' => [
            'multipart/form-data',
        ],
        'testEchoBodyAllOfPet' => [
            'application/json',
        ],
        'testEchoBodyFreeFormObjectResponseString' => [
            'application/json',
        ],
        'testEchoBodyPet' => [
            'application/json',
        ],
        'testEchoBodyPetResponseString' => [
            'application/json',
        ],
        'testEchoBodyStringEnum' => [
            'application/json',
        ],
        'testEchoBodyTagResponseString' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface|null $client
     * @param Configuration|null   $config
     * @param HeaderSelector|null  $selector
     * @param int                  $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex(int $hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex(): int
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig(): Configuration
    {
        return $this->config;
    }

    /**
     * Operation testBinaryGif
     *
     * Test binary (gif) response body
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBinaryGif'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return \SplFileObject
     */
    public function testBinaryGif(
        string $contentType = self::contentTypes['testBinaryGif'][0]
    ): \SplFileObject
    {
        list($response) = $this->testBinaryGifWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation testBinaryGifWithHttpInfo
     *
     * Test binary (gif) response body
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBinaryGif'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function testBinaryGifWithHttpInfo(
        string $contentType = self::contentTypes['testBinaryGif'][0]
    ): array
    {
        $request = $this->testBinaryGifRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\SplFileObject',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\SplFileObject',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SplFileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testBinaryGifAsync
     *
     * Test binary (gif) response body
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBinaryGif'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testBinaryGifAsync(
        string $contentType = self::contentTypes['testBinaryGif'][0]
    ): PromiseInterface
    {
        return $this->testBinaryGifAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testBinaryGifAsyncWithHttpInfo
     *
     * Test binary (gif) response body
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBinaryGif'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testBinaryGifAsyncWithHttpInfo(
        string $contentType = self::contentTypes['testBinaryGif'][0]
    ): PromiseInterface
    {
        $returnType = '\SplFileObject';
        $request = $this->testBinaryGifRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testBinaryGif'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBinaryGif'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testBinaryGifRequest(
        string $contentType = self::contentTypes['testBinaryGif'][0]
    ): Request
    {


        $resourcePath = '/binary/gif';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['image/gif', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testBodyApplicationOctetstreamBinary
     *
     * Test body parameter(s)
     *
     * @param  \SplFileObject|null $body body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyApplicationOctetstreamBinary'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return string
     */
    public function testBodyApplicationOctetstreamBinary(
        ?\SplFileObject $body = null,
        string $contentType = self::contentTypes['testBodyApplicationOctetstreamBinary'][0]
    ): string
    {
        list($response) = $this->testBodyApplicationOctetstreamBinaryWithHttpInfo($body, $contentType);
        return $response;
    }

    /**
     * Operation testBodyApplicationOctetstreamBinaryWithHttpInfo
     *
     * Test body parameter(s)
     *
     * @param  \SplFileObject|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyApplicationOctetstreamBinary'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function testBodyApplicationOctetstreamBinaryWithHttpInfo(
        ?\SplFileObject $body = null,
        string $contentType = self::contentTypes['testBodyApplicationOctetstreamBinary'][0]
    ): array
    {
        $request = $this->testBodyApplicationOctetstreamBinaryRequest($body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testBodyApplicationOctetstreamBinaryAsync
     *
     * Test body parameter(s)
     *
     * @param  \SplFileObject|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyApplicationOctetstreamBinary'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testBodyApplicationOctetstreamBinaryAsync(
        ?\SplFileObject $body = null,
        string $contentType = self::contentTypes['testBodyApplicationOctetstreamBinary'][0]
    ): PromiseInterface
    {
        return $this->testBodyApplicationOctetstreamBinaryAsyncWithHttpInfo($body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testBodyApplicationOctetstreamBinaryAsyncWithHttpInfo
     *
     * Test body parameter(s)
     *
     * @param  \SplFileObject|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyApplicationOctetstreamBinary'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testBodyApplicationOctetstreamBinaryAsyncWithHttpInfo(
        ?\SplFileObject $body = null,
        string $contentType = self::contentTypes['testBodyApplicationOctetstreamBinary'][0]
    ): PromiseInterface
    {
        $returnType = 'string';
        $request = $this->testBodyApplicationOctetstreamBinaryRequest($body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testBodyApplicationOctetstreamBinary'
     *
     * @param  \SplFileObject|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyApplicationOctetstreamBinary'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testBodyApplicationOctetstreamBinaryRequest(
        ?\SplFileObject $body = null,
        string $contentType = self::contentTypes['testBodyApplicationOctetstreamBinary'][0]
    ): Request
    {



        $resourcePath = '/body/application/octetstream/binary';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testBodyMultipartFormdataArrayOfBinary
     *
     * Test array of binary in multipart mime
     *
     * @param  \SplFileObject[] $files files (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyMultipartFormdataArrayOfBinary'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return string
     */
    public function testBodyMultipartFormdataArrayOfBinary(
        array $files,
        string $contentType = self::contentTypes['testBodyMultipartFormdataArrayOfBinary'][0]
    ): string
    {
        list($response) = $this->testBodyMultipartFormdataArrayOfBinaryWithHttpInfo($files, $contentType);
        return $response;
    }

    /**
     * Operation testBodyMultipartFormdataArrayOfBinaryWithHttpInfo
     *
     * Test array of binary in multipart mime
     *
     * @param  \SplFileObject[] $files (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyMultipartFormdataArrayOfBinary'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function testBodyMultipartFormdataArrayOfBinaryWithHttpInfo(
        array $files,
        string $contentType = self::contentTypes['testBodyMultipartFormdataArrayOfBinary'][0]
    ): array
    {
        $request = $this->testBodyMultipartFormdataArrayOfBinaryRequest($files, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testBodyMultipartFormdataArrayOfBinaryAsync
     *
     * Test array of binary in multipart mime
     *
     * @param  \SplFileObject[] $files (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyMultipartFormdataArrayOfBinary'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testBodyMultipartFormdataArrayOfBinaryAsync(
        array $files,
        string $contentType = self::contentTypes['testBodyMultipartFormdataArrayOfBinary'][0]
    ): PromiseInterface
    {
        return $this->testBodyMultipartFormdataArrayOfBinaryAsyncWithHttpInfo($files, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testBodyMultipartFormdataArrayOfBinaryAsyncWithHttpInfo
     *
     * Test array of binary in multipart mime
     *
     * @param  \SplFileObject[] $files (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyMultipartFormdataArrayOfBinary'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testBodyMultipartFormdataArrayOfBinaryAsyncWithHttpInfo(
        array $files,
        string $contentType = self::contentTypes['testBodyMultipartFormdataArrayOfBinary'][0]
    ): PromiseInterface
    {
        $returnType = 'string';
        $request = $this->testBodyMultipartFormdataArrayOfBinaryRequest($files, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testBodyMultipartFormdataArrayOfBinary'
     *
     * @param  \SplFileObject[] $files (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyMultipartFormdataArrayOfBinary'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testBodyMultipartFormdataArrayOfBinaryRequest(
        array $files,
        string $contentType = self::contentTypes['testBodyMultipartFormdataArrayOfBinary'][0]
    ): Request
    {

        // verify the required parameter 'files' is set
        if ($files === null || (is_array($files) && count($files) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $files when calling testBodyMultipartFormdataArrayOfBinary'
            );
        }


        $resourcePath = '/body/application/octetstream/array_of_binary';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;




        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'files' => $files,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testBodyMultipartFormdataSingleBinary
     *
     * Test single binary in multipart mime
     *
     * @param  \SplFileObject|null $my_file my_file (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyMultipartFormdataSingleBinary'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return string
     */
    public function testBodyMultipartFormdataSingleBinary(
        ?\SplFileObject $my_file = null,
        string $contentType = self::contentTypes['testBodyMultipartFormdataSingleBinary'][0]
    ): string
    {
        list($response) = $this->testBodyMultipartFormdataSingleBinaryWithHttpInfo($my_file, $contentType);
        return $response;
    }

    /**
     * Operation testBodyMultipartFormdataSingleBinaryWithHttpInfo
     *
     * Test single binary in multipart mime
     *
     * @param  \SplFileObject|null $my_file (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyMultipartFormdataSingleBinary'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function testBodyMultipartFormdataSingleBinaryWithHttpInfo(
        ?\SplFileObject $my_file = null,
        string $contentType = self::contentTypes['testBodyMultipartFormdataSingleBinary'][0]
    ): array
    {
        $request = $this->testBodyMultipartFormdataSingleBinaryRequest($my_file, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testBodyMultipartFormdataSingleBinaryAsync
     *
     * Test single binary in multipart mime
     *
     * @param  \SplFileObject|null $my_file (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyMultipartFormdataSingleBinary'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testBodyMultipartFormdataSingleBinaryAsync(
        ?\SplFileObject $my_file = null,
        string $contentType = self::contentTypes['testBodyMultipartFormdataSingleBinary'][0]
    ): PromiseInterface
    {
        return $this->testBodyMultipartFormdataSingleBinaryAsyncWithHttpInfo($my_file, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testBodyMultipartFormdataSingleBinaryAsyncWithHttpInfo
     *
     * Test single binary in multipart mime
     *
     * @param  \SplFileObject|null $my_file (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyMultipartFormdataSingleBinary'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testBodyMultipartFormdataSingleBinaryAsyncWithHttpInfo(
        ?\SplFileObject $my_file = null,
        string $contentType = self::contentTypes['testBodyMultipartFormdataSingleBinary'][0]
    ): PromiseInterface
    {
        $returnType = 'string';
        $request = $this->testBodyMultipartFormdataSingleBinaryRequest($my_file, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testBodyMultipartFormdataSingleBinary'
     *
     * @param  \SplFileObject|null $my_file (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyMultipartFormdataSingleBinary'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testBodyMultipartFormdataSingleBinaryRequest(
        ?\SplFileObject $my_file = null,
        string $contentType = self::contentTypes['testBodyMultipartFormdataSingleBinary'][0]
    ): Request
    {



        $resourcePath = '/body/application/octetstream/single_binary';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;




        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'my_file' => $my_file,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testEchoBodyAllOfPet
     *
     * Test body parameter(s)
     *
     * @param  \OpenAPI\Client\Model\Pet|null $pet Pet object that needs to be added to the store (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyAllOfPet'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return \OpenAPI\Client\Model\Pet
     */
    public function testEchoBodyAllOfPet(
        ?\OpenAPI\Client\Model\Pet $pet = null,
        string $contentType = self::contentTypes['testEchoBodyAllOfPet'][0]
    ): \OpenAPI\Client\Model\Pet
    {
        list($response) = $this->testEchoBodyAllOfPetWithHttpInfo($pet, $contentType);
        return $response;
    }

    /**
     * Operation testEchoBodyAllOfPetWithHttpInfo
     *
     * Test body parameter(s)
     *
     * @param  \OpenAPI\Client\Model\Pet|null $pet Pet object that needs to be added to the store (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyAllOfPet'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Pet, HTTP status code, HTTP response headers (array of strings)
     */
    public function testEchoBodyAllOfPetWithHttpInfo(
        ?\OpenAPI\Client\Model\Pet $pet = null,
        string $contentType = self::contentTypes['testEchoBodyAllOfPet'][0]
    ): array
    {
        $request = $this->testEchoBodyAllOfPetRequest($pet, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Pet',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Pet',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Pet',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testEchoBodyAllOfPetAsync
     *
     * Test body parameter(s)
     *
     * @param  \OpenAPI\Client\Model\Pet|null $pet Pet object that needs to be added to the store (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyAllOfPet'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testEchoBodyAllOfPetAsync(
        ?\OpenAPI\Client\Model\Pet $pet = null,
        string $contentType = self::contentTypes['testEchoBodyAllOfPet'][0]
    ): PromiseInterface
    {
        return $this->testEchoBodyAllOfPetAsyncWithHttpInfo($pet, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testEchoBodyAllOfPetAsyncWithHttpInfo
     *
     * Test body parameter(s)
     *
     * @param  \OpenAPI\Client\Model\Pet|null $pet Pet object that needs to be added to the store (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyAllOfPet'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testEchoBodyAllOfPetAsyncWithHttpInfo(
        ?\OpenAPI\Client\Model\Pet $pet = null,
        string $contentType = self::contentTypes['testEchoBodyAllOfPet'][0]
    ): PromiseInterface
    {
        $returnType = '\OpenAPI\Client\Model\Pet';
        $request = $this->testEchoBodyAllOfPetRequest($pet, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testEchoBodyAllOfPet'
     *
     * @param  \OpenAPI\Client\Model\Pet|null $pet Pet object that needs to be added to the store (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyAllOfPet'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testEchoBodyAllOfPetRequest(
        ?\OpenAPI\Client\Model\Pet $pet = null,
        string $contentType = self::contentTypes['testEchoBodyAllOfPet'][0]
    ): Request
    {



        $resourcePath = '/echo/body/allOf/Pet';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($pet)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($pet));
            } else {
                $httpBody = $pet;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testEchoBodyFreeFormObjectResponseString
     *
     * Test free form object
     *
     * @param  object|null $body Free form object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyFreeFormObjectResponseString'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return string
     */
    public function testEchoBodyFreeFormObjectResponseString(
        ?array $body = null,
        string $contentType = self::contentTypes['testEchoBodyFreeFormObjectResponseString'][0]
    ): string
    {
        list($response) = $this->testEchoBodyFreeFormObjectResponseStringWithHttpInfo($body, $contentType);
        return $response;
    }

    /**
     * Operation testEchoBodyFreeFormObjectResponseStringWithHttpInfo
     *
     * Test free form object
     *
     * @param  object|null $body Free form object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyFreeFormObjectResponseString'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function testEchoBodyFreeFormObjectResponseStringWithHttpInfo(
        ?array $body = null,
        string $contentType = self::contentTypes['testEchoBodyFreeFormObjectResponseString'][0]
    ): array
    {
        $request = $this->testEchoBodyFreeFormObjectResponseStringRequest($body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testEchoBodyFreeFormObjectResponseStringAsync
     *
     * Test free form object
     *
     * @param  object|null $body Free form object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyFreeFormObjectResponseString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testEchoBodyFreeFormObjectResponseStringAsync(
        ?array $body = null,
        string $contentType = self::contentTypes['testEchoBodyFreeFormObjectResponseString'][0]
    ): PromiseInterface
    {
        return $this->testEchoBodyFreeFormObjectResponseStringAsyncWithHttpInfo($body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testEchoBodyFreeFormObjectResponseStringAsyncWithHttpInfo
     *
     * Test free form object
     *
     * @param  object|null $body Free form object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyFreeFormObjectResponseString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testEchoBodyFreeFormObjectResponseStringAsyncWithHttpInfo(
        ?array $body = null,
        string $contentType = self::contentTypes['testEchoBodyFreeFormObjectResponseString'][0]
    ): PromiseInterface
    {
        $returnType = 'string';
        $request = $this->testEchoBodyFreeFormObjectResponseStringRequest($body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testEchoBodyFreeFormObjectResponseString'
     *
     * @param  object|null $body Free form object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyFreeFormObjectResponseString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testEchoBodyFreeFormObjectResponseStringRequest(
        ?array $body = null,
        string $contentType = self::contentTypes['testEchoBodyFreeFormObjectResponseString'][0]
    ): Request
    {



        $resourcePath = '/echo/body/FreeFormObject/response_string';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testEchoBodyPet
     *
     * Test body parameter(s)
     *
     * @param  \OpenAPI\Client\Model\Pet|null $pet Pet object that needs to be added to the store (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyPet'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return \OpenAPI\Client\Model\Pet
     */
    public function testEchoBodyPet(
        ?\OpenAPI\Client\Model\Pet $pet = null,
        string $contentType = self::contentTypes['testEchoBodyPet'][0]
    ): \OpenAPI\Client\Model\Pet
    {
        list($response) = $this->testEchoBodyPetWithHttpInfo($pet, $contentType);
        return $response;
    }

    /**
     * Operation testEchoBodyPetWithHttpInfo
     *
     * Test body parameter(s)
     *
     * @param  \OpenAPI\Client\Model\Pet|null $pet Pet object that needs to be added to the store (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyPet'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Pet, HTTP status code, HTTP response headers (array of strings)
     */
    public function testEchoBodyPetWithHttpInfo(
        ?\OpenAPI\Client\Model\Pet $pet = null,
        string $contentType = self::contentTypes['testEchoBodyPet'][0]
    ): array
    {
        $request = $this->testEchoBodyPetRequest($pet, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Pet',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Pet',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Pet',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testEchoBodyPetAsync
     *
     * Test body parameter(s)
     *
     * @param  \OpenAPI\Client\Model\Pet|null $pet Pet object that needs to be added to the store (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyPet'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testEchoBodyPetAsync(
        ?\OpenAPI\Client\Model\Pet $pet = null,
        string $contentType = self::contentTypes['testEchoBodyPet'][0]
    ): PromiseInterface
    {
        return $this->testEchoBodyPetAsyncWithHttpInfo($pet, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testEchoBodyPetAsyncWithHttpInfo
     *
     * Test body parameter(s)
     *
     * @param  \OpenAPI\Client\Model\Pet|null $pet Pet object that needs to be added to the store (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyPet'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testEchoBodyPetAsyncWithHttpInfo(
        ?\OpenAPI\Client\Model\Pet $pet = null,
        string $contentType = self::contentTypes['testEchoBodyPet'][0]
    ): PromiseInterface
    {
        $returnType = '\OpenAPI\Client\Model\Pet';
        $request = $this->testEchoBodyPetRequest($pet, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testEchoBodyPet'
     *
     * @param  \OpenAPI\Client\Model\Pet|null $pet Pet object that needs to be added to the store (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyPet'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testEchoBodyPetRequest(
        ?\OpenAPI\Client\Model\Pet $pet = null,
        string $contentType = self::contentTypes['testEchoBodyPet'][0]
    ): Request
    {



        $resourcePath = '/echo/body/Pet';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($pet)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($pet));
            } else {
                $httpBody = $pet;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testEchoBodyPetResponseString
     *
     * Test empty response body
     *
     * @param  \OpenAPI\Client\Model\Pet|null $pet Pet object that needs to be added to the store (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyPetResponseString'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return string
     */
    public function testEchoBodyPetResponseString(
        ?\OpenAPI\Client\Model\Pet $pet = null,
        string $contentType = self::contentTypes['testEchoBodyPetResponseString'][0]
    ): string
    {
        list($response) = $this->testEchoBodyPetResponseStringWithHttpInfo($pet, $contentType);
        return $response;
    }

    /**
     * Operation testEchoBodyPetResponseStringWithHttpInfo
     *
     * Test empty response body
     *
     * @param  \OpenAPI\Client\Model\Pet|null $pet Pet object that needs to be added to the store (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyPetResponseString'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function testEchoBodyPetResponseStringWithHttpInfo(
        ?\OpenAPI\Client\Model\Pet $pet = null,
        string $contentType = self::contentTypes['testEchoBodyPetResponseString'][0]
    ): array
    {
        $request = $this->testEchoBodyPetResponseStringRequest($pet, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testEchoBodyPetResponseStringAsync
     *
     * Test empty response body
     *
     * @param  \OpenAPI\Client\Model\Pet|null $pet Pet object that needs to be added to the store (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyPetResponseString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testEchoBodyPetResponseStringAsync(
        ?\OpenAPI\Client\Model\Pet $pet = null,
        string $contentType = self::contentTypes['testEchoBodyPetResponseString'][0]
    ): PromiseInterface
    {
        return $this->testEchoBodyPetResponseStringAsyncWithHttpInfo($pet, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testEchoBodyPetResponseStringAsyncWithHttpInfo
     *
     * Test empty response body
     *
     * @param  \OpenAPI\Client\Model\Pet|null $pet Pet object that needs to be added to the store (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyPetResponseString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testEchoBodyPetResponseStringAsyncWithHttpInfo(
        ?\OpenAPI\Client\Model\Pet $pet = null,
        string $contentType = self::contentTypes['testEchoBodyPetResponseString'][0]
    ): PromiseInterface
    {
        $returnType = 'string';
        $request = $this->testEchoBodyPetResponseStringRequest($pet, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testEchoBodyPetResponseString'
     *
     * @param  \OpenAPI\Client\Model\Pet|null $pet Pet object that needs to be added to the store (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyPetResponseString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testEchoBodyPetResponseStringRequest(
        ?\OpenAPI\Client\Model\Pet $pet = null,
        string $contentType = self::contentTypes['testEchoBodyPetResponseString'][0]
    ): Request
    {



        $resourcePath = '/echo/body/Pet/response_string';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($pet)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($pet));
            } else {
                $httpBody = $pet;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testEchoBodyStringEnum
     *
     * Test string enum response body
     *
     * @param  string|null $body String enum (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyStringEnum'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return \OpenAPI\Client\Model\StringEnumRef
     */
    public function testEchoBodyStringEnum(
        ?string $body = null,
        string $contentType = self::contentTypes['testEchoBodyStringEnum'][0]
    ): \OpenAPI\Client\Model\StringEnumRef
    {
        list($response) = $this->testEchoBodyStringEnumWithHttpInfo($body, $contentType);
        return $response;
    }

    /**
     * Operation testEchoBodyStringEnumWithHttpInfo
     *
     * Test string enum response body
     *
     * @param  string|null $body String enum (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyStringEnum'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\StringEnumRef, HTTP status code, HTTP response headers (array of strings)
     */
    public function testEchoBodyStringEnumWithHttpInfo(
        ?string $body = null,
        string $contentType = self::contentTypes['testEchoBodyStringEnum'][0]
    ): array
    {
        $request = $this->testEchoBodyStringEnumRequest($body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\StringEnumRef',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\StringEnumRef',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\StringEnumRef',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testEchoBodyStringEnumAsync
     *
     * Test string enum response body
     *
     * @param  string|null $body String enum (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyStringEnum'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testEchoBodyStringEnumAsync(
        ?string $body = null,
        string $contentType = self::contentTypes['testEchoBodyStringEnum'][0]
    ): PromiseInterface
    {
        return $this->testEchoBodyStringEnumAsyncWithHttpInfo($body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testEchoBodyStringEnumAsyncWithHttpInfo
     *
     * Test string enum response body
     *
     * @param  string|null $body String enum (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyStringEnum'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testEchoBodyStringEnumAsyncWithHttpInfo(
        ?string $body = null,
        string $contentType = self::contentTypes['testEchoBodyStringEnum'][0]
    ): PromiseInterface
    {
        $returnType = '\OpenAPI\Client\Model\StringEnumRef';
        $request = $this->testEchoBodyStringEnumRequest($body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testEchoBodyStringEnum'
     *
     * @param  string|null $body String enum (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyStringEnum'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testEchoBodyStringEnumRequest(
        ?string $body = null,
        string $contentType = self::contentTypes['testEchoBodyStringEnum'][0]
    ): Request
    {



        $resourcePath = '/echo/body/string_enum';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testEchoBodyTagResponseString
     *
     * Test empty json (request body)
     *
     * @param  \OpenAPI\Client\Model\Tag|null $tag Tag object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyTagResponseString'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return string
     */
    public function testEchoBodyTagResponseString(
        ?\OpenAPI\Client\Model\Tag $tag = null,
        string $contentType = self::contentTypes['testEchoBodyTagResponseString'][0]
    ): string
    {
        list($response) = $this->testEchoBodyTagResponseStringWithHttpInfo($tag, $contentType);
        return $response;
    }

    /**
     * Operation testEchoBodyTagResponseStringWithHttpInfo
     *
     * Test empty json (request body)
     *
     * @param  \OpenAPI\Client\Model\Tag|null $tag Tag object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyTagResponseString'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function testEchoBodyTagResponseStringWithHttpInfo(
        ?\OpenAPI\Client\Model\Tag $tag = null,
        string $contentType = self::contentTypes['testEchoBodyTagResponseString'][0]
    ): array
    {
        $request = $this->testEchoBodyTagResponseStringRequest($tag, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testEchoBodyTagResponseStringAsync
     *
     * Test empty json (request body)
     *
     * @param  \OpenAPI\Client\Model\Tag|null $tag Tag object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyTagResponseString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testEchoBodyTagResponseStringAsync(
        ?\OpenAPI\Client\Model\Tag $tag = null,
        string $contentType = self::contentTypes['testEchoBodyTagResponseString'][0]
    ): PromiseInterface
    {
        return $this->testEchoBodyTagResponseStringAsyncWithHttpInfo($tag, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testEchoBodyTagResponseStringAsyncWithHttpInfo
     *
     * Test empty json (request body)
     *
     * @param  \OpenAPI\Client\Model\Tag|null $tag Tag object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyTagResponseString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testEchoBodyTagResponseStringAsyncWithHttpInfo(
        ?\OpenAPI\Client\Model\Tag $tag = null,
        string $contentType = self::contentTypes['testEchoBodyTagResponseString'][0]
    ): PromiseInterface
    {
        $returnType = 'string';
        $request = $this->testEchoBodyTagResponseStringRequest($tag, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testEchoBodyTagResponseString'
     *
     * @param  \OpenAPI\Client\Model\Tag|null $tag Tag object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEchoBodyTagResponseString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testEchoBodyTagResponseStringRequest(
        ?\OpenAPI\Client\Model\Tag $tag = null,
        string $contentType = self::contentTypes['testEchoBodyTagResponseString'][0]
    ): Request
    {



        $resourcePath = '/echo/body/Tag/response_string';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($tag)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($tag));
            } else {
                $httpBody = $tag;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption(): array
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response,
    ): array {
        if (in_array($dataType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode,
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
