/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package org.openapitools.client.apis

import java.io.IOException
import okhttp3.Call
import okhttp3.HttpUrl


import com.squareup.moshi.Json

import org.openapitools.client.infrastructure.ApiClient
import org.openapitools.client.infrastructure.ApiResponse
import org.openapitools.client.infrastructure.ClientException
import org.openapitools.client.infrastructure.ClientError
import org.openapitools.client.infrastructure.ServerException
import org.openapitools.client.infrastructure.ServerError
import org.openapitools.client.infrastructure.MultiValueMap
import org.openapitools.client.infrastructure.PartConfig
import org.openapitools.client.infrastructure.RequestConfig
import org.openapitools.client.infrastructure.RequestMethod
import org.openapitools.client.infrastructure.ResponseType
import org.openapitools.client.infrastructure.Success
import org.openapitools.client.infrastructure.toMultiValue

open class FormApi(basePath: kotlin.String = defaultBasePath, client: Call.Factory = ApiClient.defaultClient) : ApiClient(basePath, client) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty(ApiClient.baseUrlKey, "http://localhost:3000")
        }
    }

    /**
     * POST /form/integer/boolean/string
     * Test form parameter(s)
     * Test form parameter(s)
     * @param integerForm  (optional)
     * @param booleanForm  (optional)
     * @param stringForm  (optional)
     * @return kotlin.String
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun testFormIntegerBooleanString(integerForm: kotlin.Int? = null, booleanForm: kotlin.Boolean? = null, stringForm: kotlin.String? = null) : kotlin.String {
        val localVarResponse = testFormIntegerBooleanStringWithHttpInfo(integerForm = integerForm, booleanForm = booleanForm, stringForm = stringForm)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.String
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * POST /form/integer/boolean/string
     * Test form parameter(s)
     * Test form parameter(s)
     * @param integerForm  (optional)
     * @param booleanForm  (optional)
     * @param stringForm  (optional)
     * @return ApiResponse<kotlin.String?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun testFormIntegerBooleanStringWithHttpInfo(integerForm: kotlin.Int?, booleanForm: kotlin.Boolean?, stringForm: kotlin.String?) : ApiResponse<kotlin.String?> {
        val localVariableConfig = testFormIntegerBooleanStringRequestConfig(integerForm = integerForm, booleanForm = booleanForm, stringForm = stringForm)

        return request<Map<String, PartConfig<*>>, kotlin.String>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation testFormIntegerBooleanString
     *
     * @param integerForm  (optional)
     * @param booleanForm  (optional)
     * @param stringForm  (optional)
     * @return RequestConfig
     */
    fun testFormIntegerBooleanStringRequestConfig(integerForm: kotlin.Int?, booleanForm: kotlin.Boolean?, stringForm: kotlin.String?) : RequestConfig<Map<String, PartConfig<*>>> {
        val localVariableBody = mapOf(
            "integer_form" to PartConfig(body = integerForm, headers = mutableMapOf()),
            "boolean_form" to PartConfig(body = booleanForm, headers = mutableMapOf()),
            "string_form" to PartConfig(body = stringForm, headers = mutableMapOf()),)
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("Content-Type" to "application/x-www-form-urlencoded")
        localVariableHeaders["Accept"] = "text/plain"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/form/integer/boolean/string",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * POST /form/oneof
     * Test form parameter(s) for oneOf schema
     * Test form parameter(s) for oneOf schema
     * @param form1  (optional)
     * @param form2  (optional)
     * @param form3  (optional)
     * @param form4  (optional)
     * @param id  (optional)
     * @param name  (optional)
     * @return kotlin.String
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun testFormOneof(form1: kotlin.String? = null, form2: kotlin.Int? = null, form3: kotlin.String? = null, form4: kotlin.Boolean? = null, id: kotlin.Long? = null, name: kotlin.String? = null) : kotlin.String {
        val localVarResponse = testFormOneofWithHttpInfo(form1 = form1, form2 = form2, form3 = form3, form4 = form4, id = id, name = name)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.String
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * POST /form/oneof
     * Test form parameter(s) for oneOf schema
     * Test form parameter(s) for oneOf schema
     * @param form1  (optional)
     * @param form2  (optional)
     * @param form3  (optional)
     * @param form4  (optional)
     * @param id  (optional)
     * @param name  (optional)
     * @return ApiResponse<kotlin.String?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun testFormOneofWithHttpInfo(form1: kotlin.String?, form2: kotlin.Int?, form3: kotlin.String?, form4: kotlin.Boolean?, id: kotlin.Long?, name: kotlin.String?) : ApiResponse<kotlin.String?> {
        val localVariableConfig = testFormOneofRequestConfig(form1 = form1, form2 = form2, form3 = form3, form4 = form4, id = id, name = name)

        return request<Map<String, PartConfig<*>>, kotlin.String>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation testFormOneof
     *
     * @param form1  (optional)
     * @param form2  (optional)
     * @param form3  (optional)
     * @param form4  (optional)
     * @param id  (optional)
     * @param name  (optional)
     * @return RequestConfig
     */
    fun testFormOneofRequestConfig(form1: kotlin.String?, form2: kotlin.Int?, form3: kotlin.String?, form4: kotlin.Boolean?, id: kotlin.Long?, name: kotlin.String?) : RequestConfig<Map<String, PartConfig<*>>> {
        val localVariableBody = mapOf(
            "form1" to PartConfig(body = form1, headers = mutableMapOf()),
            "form2" to PartConfig(body = form2, headers = mutableMapOf()),
            "form3" to PartConfig(body = form3, headers = mutableMapOf()),
            "form4" to PartConfig(body = form4, headers = mutableMapOf()),
            "id" to PartConfig(body = id, headers = mutableMapOf()),
            "name" to PartConfig(body = name, headers = mutableMapOf()),)
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("Content-Type" to "application/x-www-form-urlencoded")
        localVariableHeaders["Accept"] = "text/plain"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/form/oneof",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }


    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
